/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.LinkedList;
import java.util.List;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.fo.flow.Character;
import org.apache.fop.fo.properties.CommonBorderPaddingBackground;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontSelector;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;
import org.apache.fop.util.CharUtilities;

public class CharacterLayoutManager
extends LeafNodeLayoutManager {
    private MinOptMax letterSpaceIPD;
    private int hyphIPD;
    private Font font;
    private CommonBorderPaddingBackground borderProps = null;

    public CharacterLayoutManager(Character node) {
        super(node);
    }

    public void initialize() {
        Character fobj = (Character)this.fobj;
        this.font = FontSelector.selectFontForCharacter(fobj, this);
        SpaceVal ls = SpaceVal.makeLetterSpacing(fobj.getLetterSpacing());
        this.letterSpaceIPD = ls.getSpace();
        this.hyphIPD = fobj.getCommonHyphenation().getHyphIPD(this.font);
        this.borderProps = fobj.getCommonBorderPaddingBackground();
        this.setCommonBorderPaddingBackground(this.borderProps);
        TextArea chArea = this.getCharacterInlineArea(fobj);
        chArea.setBaselineOffset(this.font.getAscender());
        this.setCurrentArea(chArea);
    }

    private TextArea getCharacterInlineArea(Character node) {
        TextArea text = new TextArea();
        char ch = node.getCharacter();
        int ipd = this.font.getCharWidth(ch);
        int blockProgressionOffset = 0;
        int level = node.getBidiLevel();
        if (CharUtilities.isAnySpace(ch)) {
            if (!CharUtilities.isZeroWidthSpace(ch)) {
                text.addSpace(ch, ipd, CharUtilities.isAdjustableSpace(ch), blockProgressionOffset, level);
            }
        } else {
            int[] nArray;
            if (level >= 0) {
                int[] nArray2 = new int[1];
                nArray = nArray2;
                nArray2[0] = level;
            } else {
                nArray = null;
            }
            int[] levels = nArray;
            text.addWord(String.valueOf(ch), ipd, null, levels, null, blockProgressionOffset);
        }
        TraitSetter.setProducerID(text, node.getId());
        TraitSetter.addTextDecoration(text, node.getTextDecoration());
        TraitSetter.addStructureTreeElement(text, node.getStructureTreeElement());
        return text;
    }

    public List getNextKnuthElements(LayoutContext context, int alignment) {
        this.curArea = this.get(context);
        InlineKnuthSequence seq = new InlineKnuthSequence();
        if (this.curArea == null) {
            this.setFinished(true);
            return null;
        }
        Character fobj = (Character)this.fobj;
        MinOptMax ipd = MinOptMax.getInstance(this.curArea.getIPD());
        this.curArea.setBPD(this.font.getAscender() - this.font.getDescender());
        TraitSetter.addFontTraits(this.curArea, this.font);
        this.curArea.addTrait(Trait.COLOR, fobj.getColor());
        this.alignmentContext = new AlignmentContext(this.font, this.font.getFontSize(), fobj.getAlignmentAdjust(), fobj.getAlignmentBaseline(), fobj.getBaselineShift(), fobj.getDominantBaseline(), context.getAlignmentContext());
        this.addKnuthElementsForBorderPaddingStart(seq);
        this.areaInfo = new LeafNodeLayoutManager.AreaInfo(this, 0, ipd, false, this.alignmentContext);
        if (this.letterSpaceIPD.isStiff()) {
            seq.add(new KnuthInlineBox(this.areaInfo.ipdArea.getOpt(), this.areaInfo.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), false));
        } else {
            seq.add(new KnuthInlineBox(this.areaInfo.ipdArea.getOpt(), this.areaInfo.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), false));
            seq.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
            seq.add(new KnuthGlue(0, 0, 0, new LeafPosition(this, -1), true));
            seq.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), true));
        }
        this.addKnuthElementsForBorderPaddingEnd(seq);
        LinkedList<InlineKnuthSequence> returnList = new LinkedList<InlineKnuthSequence>();
        returnList.add(seq);
        this.setFinished(true);
        return returnList;
    }

    public String getWordChars(Position pos) {
        return ((TextArea)this.curArea).getText();
    }

    public void hyphenate(Position pos, HyphContext hc) {
        if (hc.getNextHyphPoint() == 1) {
            this.areaInfo.isHyphenated = true;
            this.somethingChanged = true;
        }
        hc.updateOffset(1);
    }

    public boolean applyChanges(List oldList) {
        this.setFinished(false);
        return this.somethingChanged;
    }

    public List getChangedKnuthElements(List oldList, int alignment) {
        if (this.isFinished()) {
            return null;
        }
        LinkedList<KnuthElement> returnList = new LinkedList<KnuthElement>();
        this.addKnuthElementsForBorderPaddingStart(returnList);
        if (this.letterSpaceIPD.isStiff() || this.areaInfo.letterSpaces == 0) {
            returnList.add(new KnuthInlineBox(this.areaInfo.ipdArea.getOpt(), this.areaInfo.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), false));
            if (this.areaInfo.isHyphenated) {
                returnList.add(new KnuthPenalty(this.hyphIPD, 50, true, new LeafPosition(this, -1), false));
            }
        } else {
            returnList.add(new KnuthInlineBox(this.areaInfo.ipdArea.getOpt() - this.areaInfo.letterSpaces * this.letterSpaceIPD.getOpt(), this.areaInfo.alignmentContext, this.notifyPos(new LeafPosition(this, 0)), false));
            returnList.add(new KnuthPenalty(0, 1000, false, new LeafPosition(this, -1), true));
            returnList.add(new KnuthGlue(this.letterSpaceIPD.mult(this.areaInfo.letterSpaces), (Position)new LeafPosition(this, -1), true));
            returnList.add(new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), true));
            if (this.areaInfo.isHyphenated) {
                returnList.add(new KnuthPenalty(this.hyphIPD, 50, true, new LeafPosition(this, -1), false));
            }
        }
        this.addKnuthElementsForBorderPaddingEnd(returnList);
        this.setFinished(true);
        return returnList;
    }
}

