/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.java2d;

import java.awt.Font;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.Typeface;
import org.apache.fop.render.java2d.FontMetricsMapper;
import org.apache.fop.render.java2d.Java2DFontMetrics;

public class SystemFontMetricsMapper
extends Typeface
implements FontMetricsMapper {
    private final Java2DFontMetrics java2DFontMetrics;
    private final String family;
    private final int style;

    public SystemFontMetricsMapper(String family, int style, Java2DFontMetrics java2DFontMetrics) {
        this.family = family;
        this.style = style;
        this.java2DFontMetrics = java2DFontMetrics;
    }

    public String getFontName() {
        return this.family;
    }

    public String getEmbedFontName() {
        return this.getFontName();
    }

    public String getFullName() {
        return this.getFontName();
    }

    public Set getFamilyNames() {
        HashSet<String> s = new HashSet<String>();
        s.add(this.family);
        return s;
    }

    public FontType getFontType() {
        return FontType.OTHER;
    }

    public int getMaxAscent(int size) {
        return this.java2DFontMetrics.getMaxAscent(this.family, this.style, size);
    }

    public int getAscender(int size) {
        return this.java2DFontMetrics.getAscender(this.family, this.style, size);
    }

    public int getCapHeight(int size) {
        return this.java2DFontMetrics.getCapHeight(this.family, this.style, size);
    }

    public int getDescender(int size) {
        return this.java2DFontMetrics.getDescender(this.family, this.style, size);
    }

    public int getXHeight(int size) {
        return this.java2DFontMetrics.getXHeight(this.family, this.style, size);
    }

    public int getWidth(int i, int size) {
        return this.java2DFontMetrics.width(i, this.family, this.style, size);
    }

    public int[] getWidths() {
        return this.java2DFontMetrics.getWidths(this.family, this.style, 1);
    }

    public Font getFont(int size) {
        return this.java2DFontMetrics.getFont(this.family, this.style, size);
    }

    public Map getKerningInfo() {
        return Collections.EMPTY_MAP;
    }

    public boolean hasKerningInfo() {
        return false;
    }

    public String getEncodingName() {
        return null;
    }

    public char mapChar(char c) {
        return c;
    }

    public boolean hasChar(char c) {
        return this.java2DFontMetrics.hasChar(this.family, this.style, 1, c);
    }
}

