/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.accessors;

import java.lang.reflect.Method;
import org.drools.base.base.BaseClassFieldReader;
import org.drools.base.base.ValueResolver;
import org.drools.base.base.ValueType;

public abstract class BaseFloatClassFieldReader
extends BaseClassFieldReader {
    private static final long serialVersionUID = 510L;

    protected BaseFloatClassFieldReader(int index, Class fieldType, ValueType valueType) {
        super(index, fieldType, valueType);
    }

    public BaseFloatClassFieldReader() {
    }

    public Object getValue(ValueResolver valueResolver, Object object) {
        return Float.valueOf(this.getFloatValue(valueResolver, object));
    }

    public boolean getBooleanValue(ValueResolver valueResolver, Object object) {
        throw new RuntimeException("Conversion to boolean not supported from float");
    }

    public byte getByteValue(ValueResolver valueResolver, Object object) {
        return (byte)this.getFloatValue(valueResolver, object);
    }

    public char getCharValue(ValueResolver valueResolver, Object object) {
        throw new RuntimeException("Conversion to char not supported from float");
    }

    public double getDoubleValue(ValueResolver valueResolver, Object object) {
        return this.getFloatValue(valueResolver, object);
    }

    public abstract float getFloatValue(ValueResolver var1, Object var2);

    public int getIntValue(ValueResolver valueResolver, Object object) {
        return (int)this.getFloatValue(valueResolver, object);
    }

    public long getLongValue(ValueResolver valueResolver, Object object) {
        return (long)this.getFloatValue(valueResolver, object);
    }

    public short getShortValue(ValueResolver valueResolver, Object object) {
        return (short)this.getFloatValue(valueResolver, object);
    }

    public boolean isNullValue(ValueResolver valueResolver, Object object) {
        return false;
    }

    public Method getNativeReadMethod() {
        try {
            return ((Object)((Object)this)).getClass().getDeclaredMethod("getFloatValue", ValueResolver.class, Object.class);
        }
        catch (Exception e) {
            throw new RuntimeException("This is a bug. Please report to development team: " + e.getMessage(), e);
        }
    }

    public int getHashCode(ValueResolver valueResolver, Object object) {
        return Float.floatToIntBits(this.getFloatValue(valueResolver, object));
    }
}

