/*
 * Decompiled with CFR 0.152.
 */
package org.drools.mvel.accessors;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UncheckedIOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.drools.base.base.AcceptsClassObjectType;
import org.drools.base.base.AccessorKey;
import org.drools.base.base.BaseClassFieldReader;
import org.drools.base.base.ClassFieldInspector;
import org.drools.base.base.ClassObjectType;
import org.drools.base.base.ClassWireable;
import org.drools.base.base.CoreComponentsBuilder;
import org.drools.base.base.ObjectType;
import org.drools.base.base.ReadAccessorSupplier;
import org.drools.base.rule.TypeDeclaration;
import org.drools.base.rule.accessor.AcceptsReadAccessor;
import org.drools.base.rule.accessor.ReadAccessor;
import org.drools.base.rule.accessor.WriteAccessor;
import org.drools.core.base.BaseClassFieldWriter;
import org.drools.core.base.ClassFieldAccessorCache;
import org.drools.mvel.accessors.ClassFieldAccessor;
import org.drools.mvel.accessors.ClassFieldReader;
import org.drools.mvel.accessors.ClassFieldWriter;
import org.kie.api.definition.type.FactField;
import org.kie.internal.builder.KnowledgeBuilderResult;

public class ClassFieldAccessorStore
implements ReadAccessorSupplier,
Externalizable {
    private static final long serialVersionUID = 510L;
    private Map<AccessorKey, BaseLookupEntry> lookup = new ConcurrentHashMap<AccessorKey, BaseLookupEntry>();
    private ClassFieldAccessorCache cache;
    private boolean eagerWire = true;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.lookup);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.lookup = (Map)in.readObject();
    }

    public void setEagerWire(boolean eagerWire) {
        this.eagerWire = eagerWire;
    }

    public void setClassFieldAccessorCache(ClassFieldAccessorCache cache) {
        this.cache = cache;
    }

    public ClassFieldReader getReader(Class<?> cls, String fieldName) {
        return this.getReader(cls.getName(), fieldName, null, AccessorKey.AccessorType.FieldAccessor);
    }

    public ClassFieldReader getReader(String className, String fieldName, AcceptsReadAccessor target) {
        return this.getReader(className, fieldName, target, AccessorKey.AccessorType.FieldAccessor);
    }

    public synchronized ClassFieldReader getReader(String className, String fieldName, AcceptsReadAccessor target, AccessorKey.AccessorType accessorType) {
        boolean exists;
        AccessorKey key = new AccessorKey(className, fieldName, accessorType);
        FieldLookupEntry entry = (FieldLookupEntry)this.lookup.get(key);
        boolean bl = exists = entry != null;
        if (!exists) {
            entry = new FieldLookupEntry(new ClassFieldReader(className, fieldName));
        }
        if (this.eagerWire) {
            this.wire(entry.getClassFieldReader());
            ClassFieldReader reader = (ClassFieldReader)entry.getClassFieldReader();
            if (!reader.hasReadAccessor()) {
                return null;
            }
        }
        if (target != null) {
            target.setReadAccessor(entry.getClassFieldReader());
        }
        if (!exists) {
            this.lookup.put(key, entry);
        }
        return (ClassFieldReader)entry.getClassFieldReader();
    }

    public ClassFieldReader getReader(AccessorKey key) {
        FieldLookupEntry entry = (FieldLookupEntry)this.lookup.get(key);
        return entry != null ? (ClassFieldReader)entry.getClassFieldReader() : null;
    }

    public ReadAccessor getMVELReader(String pkgName, String className, String expr, boolean typesafe, Class<?> returnType) {
        AccessorKey key = new AccessorKey(pkgName + className, expr, AccessorKey.AccessorType.FieldAccessor);
        FieldLookupEntry entry = (FieldLookupEntry)this.lookup.computeIfAbsent(key, k -> new FieldLookupEntry(ClassFieldAccessorStore.getReadAcessor(className, expr, typesafe, returnType)));
        return entry.getClassFieldReader();
    }

    public static ReadAccessor getReadAcessor(String className, String expr, boolean typesafe, Class<?> returnType) {
        return CoreComponentsBuilder.get().getReadAcessor(className, expr, typesafe, returnType);
    }

    public ClassFieldAccessor getAccessor(Class<?> cls, String fieldName) {
        return this.getAccessor(cls.getName(), fieldName);
    }

    public ClassFieldAccessor getAccessor(String className, String fieldName) {
        AccessorKey key = new AccessorKey(className, fieldName, AccessorKey.AccessorType.FieldAccessor);
        FieldLookupEntry entry = (FieldLookupEntry)this.lookup.computeIfAbsent(key, k -> new FieldLookupEntry(new ClassFieldReader(className, fieldName), new ClassFieldWriter(className, fieldName)));
        ClassFieldAccessor accessor = new ClassFieldAccessor((ClassFieldReader)entry.getClassFieldReader(), entry.getClassFieldWriter());
        if (this.eagerWire) {
            this.wire(entry.getClassFieldReader());
            this.wire(entry.getClassFieldWriter());
        }
        return accessor;
    }

    public ObjectType wireObjectType(ObjectType objectType, AcceptsClassObjectType target) {
        if (!(objectType instanceof ClassObjectType)) {
            return objectType;
        }
        AccessorKey key = new AccessorKey(objectType.getClassName(), objectType.isEvent() ? "$$DROOLS__isEvent__" : null, AccessorKey.AccessorType.ClassObjectType);
        ClassObjectTypeLookupEntry entry = (ClassObjectTypeLookupEntry)this.lookup.computeIfAbsent(key, k -> new ClassObjectTypeLookupEntry(this.cache.getClassObjectType((ClassObjectType)objectType, false)));
        if (target != null) {
            target.setClassObjectType(entry.getClassObjectType());
        }
        return entry.getClassObjectType();
    }

    public void removeType(TypeDeclaration type) {
        this.lookup.remove(new AccessorKey(type.getTypeClassName(), null, AccessorKey.AccessorType.ClassObjectType));
        for (FactField field : type.getTypeClassDef().getFields()) {
            this.lookup.remove(new AccessorKey(type.getTypeClassName(), field.getName(), AccessorKey.AccessorType.FieldAccessor));
        }
    }

    public void removeClass(Class<?> clazz) {
        this.lookup.remove(new AccessorKey(clazz.getName(), null, AccessorKey.AccessorType.ClassObjectType));
        for (Field field : clazz.getDeclaredFields()) {
            this.lookup.remove(new AccessorKey(clazz.getName(), field.getName(), AccessorKey.AccessorType.FieldAccessor));
        }
    }

    public void merge(ClassFieldAccessorStore other) {
        block4: for (Map.Entry<AccessorKey, BaseLookupEntry> entry : other.lookup.entrySet()) {
            switch (entry.getValue().getAccessorType()) {
                case FieldAccessor: {
                    BaseClassFieldReader accessor;
                    FieldLookupEntry lookupEntry = (FieldLookupEntry)this.lookup.computeIfAbsent(entry.getKey(), e -> (BaseLookupEntry)entry.getValue());
                    if (lookupEntry.getClassFieldReader() != null) {
                        ReadAccessor reader = ((FieldLookupEntry)entry.getValue()).getClassFieldReader();
                        accessor = this.wire(reader);
                        if (other.cache != null && reader instanceof ClassFieldReader) {
                            other.cache.setReadAcessor(((ClassFieldReader)reader).getClassName(), ((ClassFieldReader)reader).getFieldName(), (ReadAccessor)accessor);
                        }
                    }
                    if (lookupEntry.getClassFieldWriter() == null) break;
                    ClassFieldWriter writer = ((FieldLookupEntry)entry.getValue()).getClassFieldWriter();
                    accessor = this.wire(writer);
                    if (other.cache == null) continue block4;
                    other.cache.setWriteAcessor(writer.getClassName(), writer.getFieldName(), (BaseClassFieldWriter)accessor);
                    break;
                }
                case ClassObjectType: {
                    if (this.lookup.containsKey(entry.getKey())) break;
                    this.lookup.put(entry.getKey(), this.getBaseLookupEntry(entry));
                }
            }
        }
    }

    private BaseLookupEntry getBaseLookupEntry(Map.Entry<AccessorKey, BaseLookupEntry> entry) {
        ClassObjectType oldObjectType = ((ClassObjectTypeLookupEntry)entry.getValue()).getClassObjectType();
        ClassObjectType newObjectType = this.cache.getClassObjectType(oldObjectType, true);
        oldObjectType.setClassType(newObjectType.getClassType());
        return new ClassObjectTypeLookupEntry(newObjectType);
    }

    public void wire() {
        for (Map.Entry<AccessorKey, BaseLookupEntry> entry : this.lookup.entrySet()) {
            switch (entry.getValue().getAccessorType()) {
                case FieldAccessor: {
                    ClassFieldWriter writer;
                    ReadAccessor reader = ((FieldLookupEntry)entry.getValue()).getClassFieldReader();
                    if (reader != null) {
                        this.wire(reader);
                    }
                    if ((writer = ((FieldLookupEntry)entry.getValue()).getClassFieldWriter()) == null) break;
                    this.wire(writer);
                    break;
                }
                case ClassObjectType: {
                    ClassObjectType classObjectType = ((ClassObjectTypeLookupEntry)entry.getValue()).getClassObjectType();
                    this.wire((ClassWireable)classObjectType);
                    break;
                }
            }
        }
    }

    public BaseClassFieldReader wire(ReadAccessor reader) {
        if (reader instanceof ClassFieldReader) {
            ReadAccessor accessor = this.cache.getReadAccessor(((ClassFieldReader)reader).getClassName(), ((ClassFieldReader)reader).getFieldName());
            ((ClassFieldReader)reader).setReadAccessor(accessor);
            return (BaseClassFieldReader)accessor;
        }
        return null;
    }

    public Class<?> getFieldType(Class<?> clazz, String fieldName) {
        ClassFieldInspector inspector;
        ClassFieldAccessorCache.CacheEntry cache = this.cache.getCacheEntry(clazz);
        try {
            inspector = ClassFieldAccessorStore.getClassFieldInspector(clazz, cache);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        Class fieldType = inspector.getFieldType(fieldName);
        if (fieldType == null && fieldName.length() > 1 && Character.isLowerCase(fieldName.charAt(0)) && Character.isUpperCase(fieldName.charAt(1))) {
            String altFieldName = Character.toUpperCase(fieldName.charAt(0)) + fieldName.substring(1);
            fieldType = inspector.getFieldType(altFieldName);
        }
        return fieldType;
    }

    public static ClassFieldInspector getClassFieldInspector(Class<?> clazz, ClassFieldAccessorCache.CacheEntry cache) throws IOException {
        Map inspectors = cache.getInspectors();
        ClassFieldInspector inspector = (ClassFieldInspector)inspectors.get(clazz);
        if (inspector == null) {
            inspector = CoreComponentsBuilder.get().createClassFieldInspector(clazz);
            inspectors.put(clazz, inspector);
        }
        return inspector;
    }

    public BaseClassFieldWriter wire(ClassFieldWriter writer) {
        WriteAccessor accessor = this.cache.getWriteAccessor(writer.getClassName(), writer.getFieldName());
        writer.setWriteAccessor(accessor);
        return (BaseClassFieldWriter)accessor;
    }

    public void wire(ClassWireable wireable) {
        try {
            if (wireable.getClassType() == null || !wireable.getClassType().isPrimitive()) {
                Class<?> cls = this.cache.getClassLoader().loadClass(wireable.getClassName());
                wireable.wire(cls);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load ClassObjectType class '" + wireable.getClassName() + "'");
        }
    }

    public Collection<KnowledgeBuilderResult> getWiringResults(Class<?> klass, String fieldName) {
        if (this.cache == null) {
            return Collections.EMPTY_LIST;
        }
        Map inspectors = this.cache.getCacheEntry(klass).getInspectors();
        return inspectors.containsKey(klass) ? ((ClassFieldInspector)inspectors.get(klass)).getInspectionResults(fieldName) : Collections.EMPTY_LIST;
    }

    public static class FieldLookupEntry
    implements BaseLookupEntry {
        private ReadAccessor reader;
        private ClassFieldWriter writer;

        public FieldLookupEntry() {
        }

        public FieldLookupEntry(ReadAccessor reader) {
            this(reader, null);
        }

        public FieldLookupEntry(ReadAccessor reader, ClassFieldWriter writer) {
            this.writer = writer;
            this.reader = reader;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.reader);
            out.writeObject(this.writer);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.reader = (ReadAccessor)in.readObject();
            this.writer = (ClassFieldWriter)in.readObject();
        }

        public ReadAccessor getClassFieldReader() {
            return this.reader;
        }

        public ClassFieldWriter getClassFieldWriter() {
            return this.writer;
        }

        @Override
        public AccessorKey.AccessorType getAccessorType() {
            return AccessorKey.AccessorType.FieldAccessor;
        }
    }

    public static class ClassObjectTypeLookupEntry
    implements BaseLookupEntry {
        ClassObjectType classObjectType;

        public ClassObjectTypeLookupEntry() {
        }

        public ClassObjectTypeLookupEntry(ClassObjectType classObjectType) {
            this.classObjectType = classObjectType;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.classObjectType);
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.classObjectType = (ClassObjectType)in.readObject();
        }

        public ClassObjectType getClassObjectType() {
            return this.classObjectType;
        }

        public void setClassObjectType(ClassObjectType classObjectType) {
            this.classObjectType = classObjectType;
        }

        @Override
        public AccessorKey.AccessorType getAccessorType() {
            return AccessorKey.AccessorType.ClassObjectType;
        }
    }

    public static interface BaseLookupEntry
    extends Externalizable {
        public AccessorKey.AccessorType getAccessorType();
    }
}

