/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.client.security.user.privileges.ApplicationPrivilege;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;

public final class GetPrivilegesResponse {
    private Set<ApplicationPrivilege> privileges;

    public Set<ApplicationPrivilege> getPrivileges() {
        return this.privileges;
    }

    public GetPrivilegesResponse(Collection<ApplicationPrivilege> privileges) {
        this.privileges = Collections.unmodifiableSet(new HashSet<ApplicationPrivilege>(privileges));
    }

    public static GetPrivilegesResponse fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token;
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), () -> ((XContentParser)parser).getTokenLocation());
        ArrayList<ApplicationPrivilege> privileges = new ArrayList<ApplicationPrivilege>();
        while ((token = parser.nextToken()) != null) {
            if (token != XContentParser.Token.FIELD_NAME) continue;
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), () -> ((XContentParser)parser).getTokenLocation());
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                privileges.add((ApplicationPrivilege)ApplicationPrivilege.PARSER.parse(parser, null));
            }
        }
        return new GetPrivilegesResponse(new HashSet<ApplicationPrivilege>(privileges));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetPrivilegesResponse that = (GetPrivilegesResponse)o;
        return Objects.equals(this.privileges, that.privileges);
    }

    public int hashCode() {
        return Objects.hash(this.privileges);
    }
}

