/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.cmmn.engine.impl.cmd;

import java.util.Map;
import org.flowable.cmmn.engine.CmmnEngineConfiguration;
import org.flowable.cmmn.engine.impl.cmd.AbstractExternalWorkerJobCmd;
import org.flowable.cmmn.engine.impl.persistence.entity.CountingPlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.persistence.entity.PlanItemInstanceEntity;
import org.flowable.cmmn.engine.impl.util.CommandContextUtil;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.job.service.impl.persistence.entity.ExternalWorkerJobEntity;
import org.flowable.variable.service.VariableService;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.persistence.entity.VariableInstanceEntity;

public class ExternalWorkerJobCompleteCmd
extends AbstractExternalWorkerJobCmd
implements Command<Void> {
    protected Map<String, Object> variables;

    public ExternalWorkerJobCompleteCmd(String externalJobId, String workerId, Map<String, Object> variables) {
        super(externalJobId, workerId);
        this.variables = variables;
    }

    @Override
    protected void runJobLogic(ExternalWorkerJobEntity externalWorkerJob, CommandContext commandContext) {
        externalWorkerJob.setJobHandlerConfiguration(null);
        if (this.variables != null && !this.variables.isEmpty()) {
            CmmnEngineConfiguration cmmnEngineConfiguration = CommandContextUtil.getCmmnEngineConfiguration(commandContext);
            VariableServiceConfiguration variableServiceConfiguration = cmmnEngineConfiguration.getVariableServiceConfiguration();
            VariableService variableService = variableServiceConfiguration.getVariableService();
            for (Map.Entry<String, Object> variableEntry : this.variables.entrySet()) {
                String varName = variableEntry.getKey();
                Object varValue = variableEntry.getValue();
                VariableInstanceEntity variableInstance = variableService.createVariableInstance(varName);
                variableInstance.setScopeId(externalWorkerJob.getScopeId());
                variableInstance.setSubScopeId(externalWorkerJob.getSubScopeId());
                variableInstance.setScopeType("cmmnExternalWorker");
                variableService.insertVariableInstanceWithValue(variableInstance, varValue, externalWorkerJob.getTenantId());
            }
            PlanItemInstanceEntity planItemInstanceEntity = (PlanItemInstanceEntity)cmmnEngineConfiguration.getPlanItemInstanceEntityManager().findById(externalWorkerJob.getSubScopeId());
            if (planItemInstanceEntity instanceof CountingPlanItemInstanceEntity) {
                ((CountingPlanItemInstanceEntity)((Object)planItemInstanceEntity)).setVariableCount(((CountingPlanItemInstanceEntity)((Object)planItemInstanceEntity)).getVariableCount() + this.variables.size());
            }
        }
        this.moveExternalWorkerJobToExecutableJob(externalWorkerJob, commandContext);
    }
}

