/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.content.engine.test;

import java.util.ArrayList;
import java.util.List;
import org.flowable.content.api.ContentService;
import org.flowable.content.engine.ContentEngine;
import org.flowable.content.engine.ContentEngineConfiguration;
import org.flowable.content.engine.test.ContentTestHelper;
import org.junit.internal.AssumptionViolatedException;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class FlowableContentRule
implements TestRule {
    protected String configurationResource = "flowable.content.cfg.xml";
    protected String deploymentId;
    protected ContentEngineConfiguration contentEngineConfiguration;
    protected ContentEngine contentEngine;
    protected ContentService contentService;

    public FlowableContentRule() {
    }

    public FlowableContentRule(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public FlowableContentRule(ContentEngine contentEngine) {
        this.setContentEngine(contentEngine);
    }

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                FlowableContentRule.this.startingQuietly(description, errors);
                try {
                    base.evaluate();
                    FlowableContentRule.this.succeededQuietly(description, errors);
                }
                catch (AssumptionViolatedException e) {
                    errors.add(e);
                    FlowableContentRule.this.skippedQuietly(e, description, errors);
                }
                catch (Throwable t) {
                    errors.add(t);
                    FlowableContentRule.this.failedQuietly(t, description, errors);
                }
                finally {
                    FlowableContentRule.this.finishedQuietly(description, errors);
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }

    private void succeededQuietly(Description description, List<Throwable> errors) {
        try {
            this.succeeded(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void failedQuietly(Throwable t, Description description, List<Throwable> errors) {
        try {
            this.failed(t, description);
        }
        catch (Throwable t1) {
            errors.add(t1);
        }
    }

    private void skippedQuietly(AssumptionViolatedException e, Description description, List<Throwable> errors) {
        try {
            this.skipped(e, description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void startingQuietly(Description description, List<Throwable> errors) {
        try {
            this.starting(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    private void finishedQuietly(Description description, List<Throwable> errors) {
        try {
            this.finished(description);
        }
        catch (Throwable t) {
            errors.add(t);
        }
    }

    protected void succeeded(Description description) {
    }

    protected void failed(Throwable e, Description description) {
    }

    protected void skipped(AssumptionViolatedException e, Description description) {
    }

    protected void starting(Description description) {
        if (this.contentEngine == null) {
            this.initializeContentEngine();
        }
        if (this.contentEngineConfiguration == null) {
            this.initializeServices();
        }
        this.configureContentEngine();
    }

    protected void initializeContentEngine() {
        this.contentEngine = ContentTestHelper.getContentEngine(this.configurationResource);
    }

    protected void initializeServices() {
        this.contentEngineConfiguration = this.contentEngine.getContentEngineConfiguration();
        this.contentService = this.contentEngine.getContentService();
    }

    protected void configureContentEngine() {
    }

    protected void finished(Description description) {
        this.contentEngineConfiguration.getClock().reset();
    }

    public String getConfigurationResource() {
        return this.configurationResource;
    }

    public void setConfigurationResource(String configurationResource) {
        this.configurationResource = configurationResource;
    }

    public ContentEngine getContentEngine() {
        return this.contentEngine;
    }

    public void setContentEngine(ContentEngine contentEngine) {
        this.contentEngine = contentEngine;
        this.initializeServices();
    }

    public ContentService getContentService() {
        return this.contentService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setContentEngineConfiguration(ContentEngineConfiguration contentEngineConfiguration) {
        this.contentEngineConfiguration = contentEngineConfiguration;
    }
}

