/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.form.engine.impl.cmd;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.flowable.common.engine.impl.interceptor.Command;
import org.flowable.common.engine.impl.interceptor.CommandContext;
import org.flowable.form.api.FormDeployment;
import org.flowable.form.api.FormDeploymentQuery;
import org.flowable.form.engine.FormEngineConfiguration;
import org.flowable.form.engine.impl.FormDeploymentQueryImpl;
import org.flowable.form.engine.impl.persistence.entity.FormDeploymentEntity;
import org.flowable.form.engine.impl.persistence.entity.FormResourceEntity;
import org.flowable.form.engine.impl.repository.FormDeploymentBuilderImpl;
import org.flowable.form.engine.impl.util.CommandContextUtil;

public class DeployCmd<T>
implements Command<FormDeployment>,
Serializable {
    private static final long serialVersionUID = 1L;
    protected FormDeploymentBuilderImpl deploymentBuilder;

    public DeployCmd(FormDeploymentBuilderImpl deploymentBuilder) {
        this.deploymentBuilder = deploymentBuilder;
    }

    public FormDeployment execute(CommandContext commandContext) {
        FormDeploymentEntity deployment = this.deploymentBuilder.getDeployment();
        FormEngineConfiguration formEngineConfiguration = CommandContextUtil.getFormEngineConfiguration();
        deployment.setDeploymentTime(formEngineConfiguration.getClock().getCurrentTime());
        if (this.deploymentBuilder.isDuplicateFilterEnabled()) {
            ArrayList<FormDeployment> existingDeployments = new ArrayList<FormDeployment>();
            if (deployment.getTenantId() == null || "".equals(deployment.getTenantId())) {
                List deploymentEntities = ((FormDeploymentQuery)new FormDeploymentQueryImpl(formEngineConfiguration.getCommandExecutor()).deploymentName(deployment.getName()).orderByDeploymentTime().desc()).listPage(0, 1);
                if (!deploymentEntities.isEmpty()) {
                    existingDeployments.add((FormDeployment)deploymentEntities.get(0));
                }
            } else {
                List deploymentList = ((FormDeploymentQuery)formEngineConfiguration.getFormRepositoryService().createDeploymentQuery().deploymentName(deployment.getName()).deploymentTenantId(deployment.getTenantId()).orderByDeploymentTime().desc()).listPage(0, 1);
                if (!deploymentList.isEmpty()) {
                    existingDeployments.addAll(deploymentList);
                }
            }
            if (!existingDeployments.isEmpty()) {
                FormDeploymentEntity existingDeployment = (FormDeploymentEntity)existingDeployments.get(0);
                HashMap<String, FormResourceEntity> resourceMap = new HashMap<String, FormResourceEntity>();
                List<FormResourceEntity> resourceList = formEngineConfiguration.getResourceEntityManager().findResourcesByDeploymentId(existingDeployment.getId());
                for (FormResourceEntity resourceEntity : resourceList) {
                    resourceMap.put(resourceEntity.getName(), resourceEntity);
                }
                existingDeployment.setResources(resourceMap);
                if (!this.deploymentsDiffer(deployment, existingDeployment)) {
                    return existingDeployment;
                }
            }
        }
        deployment.setNew(true);
        formEngineConfiguration.getDeploymentEntityManager().insert(deployment);
        if (StringUtils.isEmpty((CharSequence)deployment.getParentDeploymentId())) {
            deployment.setParentDeploymentId(deployment.getId());
        }
        formEngineConfiguration.getDeploymentManager().deploy(deployment);
        return deployment;
    }

    protected boolean deploymentsDiffer(FormDeploymentEntity deployment, FormDeploymentEntity saved) {
        if (deployment.getResources() == null || saved.getResources() == null) {
            return true;
        }
        Map<String, FormResourceEntity> resources = deployment.getResources();
        Map<String, FormResourceEntity> savedResources = saved.getResources();
        for (String resourceName : resources.keySet()) {
            byte[] savedBytes;
            FormResourceEntity savedResource = savedResources.get(resourceName);
            if (savedResource == null) {
                return true;
            }
            FormResourceEntity resource = resources.get(resourceName);
            byte[] bytes = resource.getBytes();
            if (Arrays.equals(bytes, savedBytes = savedResource.getBytes())) continue;
            return true;
        }
        return false;
    }
}

