/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.auth;

import com.alibaba.nacos.auth.AbstractProtocolAuthService;
import com.alibaba.nacos.auth.annotation.Secured;
import com.alibaba.nacos.auth.config.AuthConfigs;
import com.alibaba.nacos.auth.context.HttpIdentityContextBuilder;
import com.alibaba.nacos.auth.parser.http.AbstractHttpResourceParser;
import com.alibaba.nacos.auth.parser.http.ConfigHttpResourceParser;
import com.alibaba.nacos.auth.parser.http.NamingHttpResourceParser;
import com.alibaba.nacos.auth.util.Loggers;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.auth.api.IdentityContext;
import com.alibaba.nacos.plugin.auth.api.Resource;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class HttpProtocolAuthService
extends AbstractProtocolAuthService<HttpServletRequest> {
    private final Map<String, AbstractHttpResourceParser> resourceParserMap = new HashMap<String, AbstractHttpResourceParser>(2);
    private final HttpIdentityContextBuilder identityContextBuilder;

    public HttpProtocolAuthService(AuthConfigs authConfigs) {
        super(authConfigs);
        this.identityContextBuilder = new HttpIdentityContextBuilder(authConfigs);
    }

    @Override
    public void initialize() {
        this.resourceParserMap.put("naming", new NamingHttpResourceParser());
        this.resourceParserMap.put("config", new ConfigHttpResourceParser());
    }

    @Override
    public Resource parseResource(HttpServletRequest request, Secured secured) {
        if (StringUtils.isNotBlank((String)secured.resource())) {
            return this.parseSpecifiedResource(secured);
        }
        String type = secured.signType();
        if (!this.resourceParserMap.containsKey(type)) {
            Loggers.AUTH.warn("Can't find Http request resourceParser for type {} use specified resource parser", (Object)type);
            return this.useSpecifiedParserToParse(secured, request);
        }
        return this.resourceParserMap.get(type).parse(request, secured);
    }

    @Override
    public IdentityContext parseIdentity(HttpServletRequest request) {
        return this.identityContextBuilder.build(request);
    }
}

