/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.embedded;

import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.exception.runtime.NacosRuntimeException;
import com.alibaba.nacos.common.notify.NotifyCenter;
import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.Pair;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.configuration.ConditionOnEmbeddedStorage;
import com.alibaba.nacos.config.server.enums.FileTypeEnum;
import com.alibaba.nacos.config.server.exception.NacosConfigException;
import com.alibaba.nacos.config.server.model.ConfigAdvanceInfo;
import com.alibaba.nacos.config.server.model.ConfigAllInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.ConfigInfoBase;
import com.alibaba.nacos.config.server.model.ConfigInfoWrapper;
import com.alibaba.nacos.config.server.model.ConfigKey;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.model.SameConfigPolicy;
import com.alibaba.nacos.config.server.model.event.DerbyImportEvent;
import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.config.server.service.repository.ConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.HistoryConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.RowMapperManager;
import com.alibaba.nacos.config.server.service.repository.embedded.DatabaseOperate;
import com.alibaba.nacos.config.server.service.repository.embedded.EmbeddedPaginationHelperImpl;
import com.alibaba.nacos.config.server.service.sql.EmbeddedStorageContextUtils;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.config.server.utils.ParamUtils;
import com.alibaba.nacos.core.distributed.id.IdGeneratorManager;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigInfoMapper;
import com.alibaba.nacos.plugin.datasource.mapper.ConfigTagsRelationMapper;
import com.alibaba.nacos.plugin.encryption.handler.EncryptionHandler;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Conditional;
import org.springframework.stereotype.Service;

@Conditional(value={ConditionOnEmbeddedStorage.class})
@Service(value="embeddedConfigInfoPersistServiceImpl")
public class EmbeddedConfigInfoPersistServiceImpl
implements ConfigInfoPersistService {
    private static final String RESOURCE_CONFIG_INFO_ID = "config-info-id";
    private static final String RESOURCE_CONFIG_HISTORY_ID = "config-history-id";
    private static final String RESOURCE_CONFIG_TAG_RELATION_ID = "config-tag-relation-id";
    private static final String RESOURCE_APP_CONFIGDATA_RELATION_SUBS = "app-configdata-relation-subs";
    private static final String RESOURCE_CONFIG_BETA_ID = "config-beta-id";
    private static final String RESOURCE_NAMESPACE_ID = "namespace-id";
    private static final String RESOURCE_USER_ID = "user-id";
    private static final String RESOURCE_ROLE_ID = "role-id";
    private static final String RESOURCE_PERMISSIONS_ID = "permissions_id";
    private static final String DATA_ID = "dataId";
    private static final String GROUP = "group";
    private static final String APP_NAME = "appName";
    private static final String CONTENT = "content";
    private static final String TENANT = "tenant_id";
    public static final String SPOT = ".";
    private DataSourceService dataSourceService;
    private final DatabaseOperate databaseOperate;
    private final IdGeneratorManager idGeneratorManager;
    private MapperManager mapperManager;
    private HistoryConfigInfoPersistService historyConfigInfoPersistService;

    public EmbeddedConfigInfoPersistServiceImpl(DatabaseOperate databaseOperate, IdGeneratorManager idGeneratorManager, @Qualifier(value="embeddedHistoryConfigInfoPersistServiceImpl") HistoryConfigInfoPersistService historyConfigInfoPersistService) {
        this.databaseOperate = databaseOperate;
        this.idGeneratorManager = idGeneratorManager;
        idGeneratorManager.register(new String[]{RESOURCE_CONFIG_INFO_ID, RESOURCE_CONFIG_HISTORY_ID, RESOURCE_CONFIG_TAG_RELATION_ID, RESOURCE_APP_CONFIGDATA_RELATION_SUBS, RESOURCE_CONFIG_BETA_ID, RESOURCE_NAMESPACE_ID, RESOURCE_USER_ID, RESOURCE_ROLE_ID, RESOURCE_PERMISSIONS_ID});
        this.dataSourceService = DynamicDataSource.getInstance().getDataSource();
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
        this.historyConfigInfoPersistService = historyConfigInfoPersistService;
        NotifyCenter.registerToSharePublisher(DerbyImportEvent.class);
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new EmbeddedPaginationHelperImpl(this.databaseOperate);
    }

    @Override
    public String generateLikeArgument(String s) {
        String fuzzySearchSign = "\\*";
        String sqlLikePercentSign = "%";
        if (s.contains("*")) {
            return s.replaceAll(fuzzySearchSign, sqlLikePercentSign);
        }
        return s;
    }

    @Override
    public void addConfigInfo(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        this.addConfigInfo(srcIp, srcUser, configInfo, time, configAdvanceInfo, notify, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addConfigInfo(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify, BiConsumer<Boolean, Throwable> consumer) {
        try {
            String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
            configInfo.setTenant(tenantTmp);
            long configId = this.idGeneratorManager.nextId(RESOURCE_CONFIG_INFO_ID);
            long hisId = this.idGeneratorManager.nextId(RESOURCE_CONFIG_HISTORY_ID);
            this.addConfigInfoAtomic(configId, srcIp, srcUser, configInfo, time, configAdvanceInfo);
            String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
            this.addConfigTagsRelation(configId, configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
            this.historyConfigInfoPersistService.insertConfigHistoryAtomic(hisId, configInfo, srcIp, srcUser, time, "I");
            EmbeddedStorageContextUtils.onModifyConfigInfo(configInfo, srcIp, time);
            this.databaseOperate.blockUpdate(consumer);
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public void insertOrUpdate(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo) {
        this.insertOrUpdate(srcIp, srcUser, configInfo, time, configAdvanceInfo, true);
    }

    @Override
    public void insertOrUpdate(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        if (Objects.isNull(this.findConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()))) {
            this.addConfigInfo(srcIp, srcUser, configInfo, time, configAdvanceInfo, notify);
        } else {
            this.updateConfigInfo(configInfo, srcIp, srcUser, time, configAdvanceInfo, notify);
        }
    }

    @Override
    public boolean insertOrUpdateCas(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo) {
        return this.insertOrUpdateCas(srcIp, srcUser, configInfo, time, configAdvanceInfo, true);
    }

    @Override
    public boolean insertOrUpdateCas(String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        if (Objects.isNull(this.findConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant()))) {
            this.addConfigInfo(srcIp, srcUser, configInfo, time, configAdvanceInfo, notify);
            return true;
        }
        return this.updateConfigInfoCas(configInfo, srcIp, srcUser, time, configAdvanceInfo, notify);
    }

    @Override
    public long addConfigInfoAtomic(long id, String srcIp, String srcUser, ConfigInfo configInfo, Timestamp time, Map<String, Object> configAdvanceInfo) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String encryptedDataKey = configInfo.getEncryptedDataKey() == null ? "" : configInfo.getEncryptedDataKey();
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.insert(Arrays.asList("id", "data_id", "group_id", TENANT, "app_name", CONTENT, "md5", "src_ip", "src_user", "gmt_create", "gmt_modified", "c_desc", "c_use", "effect", "type", "c_schema", "encrypted_data_key"));
        Object[] args = new Object[]{id, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, appNameTmp, configInfo.getContent(), md5Tmp, srcIp, srcUser, time, time, desc, use, effect, type, schema, encryptedDataKey};
        EmbeddedStorageContextUtils.addSqlContext(sql, args);
        return id;
    }

    @Override
    public void addConfigTagRelationAtomic(long configId, String tagName, String dataId, String group, String tenant) {
        ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
        String sql = configTagsRelationMapper.insert(Arrays.asList("id", "tag_name", "tag_type", "data_id", "group_id", TENANT));
        Object[] args = new Object[]{configId, tagName, "", dataId, group, tenant};
        EmbeddedStorageContextUtils.addSqlContext(sql, args);
    }

    @Override
    public void addConfigTagsRelation(long configId, String configTags, String dataId, String group, String tenant) {
        if (StringUtils.isNotBlank((String)configTags)) {
            String[] tagArr = configTags.split(",");
            for (int i = 0; i < tagArr.length; ++i) {
                this.addConfigTagRelationAtomic(configId, tagArr[i], dataId, group, tenant);
            }
        }
    }

    @Override
    public Map<String, Object> batchInsertOrUpdate(List<ConfigAllInfo> configInfoList, String srcUser, String srcIp, Map<String, Object> configAdvanceInfo, Timestamp time, boolean notify, SameConfigPolicy policy) throws NacosException {
        int succCount = 0;
        int skipCount = 0;
        ArrayList failData = null;
        ArrayList skipData = null;
        BiConsumer<Boolean, Throwable> callFinally = (result, t) -> {
            if (t != null) {
                throw new NacosRuntimeException(0, t);
            }
        };
        for (int i = 0; i < configInfoList.size(); ++i) {
            ConfigAllInfo configInfo = configInfoList.get(i);
            try {
                ParamUtils.checkParam(configInfo.getDataId(), configInfo.getGroup(), "datumId", configInfo.getContent());
            }
            catch (Throwable e) {
                LogUtil.DEFAULT_LOG.error("data verification failed", e);
                throw e;
            }
            ConfigInfo configInfo2Save = new ConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant(), configInfo.getAppName(), configInfo.getContent());
            configInfo2Save.setEncryptedDataKey(configInfo.getEncryptedDataKey() == null ? "" : configInfo.getEncryptedDataKey());
            String type = configInfo.getType();
            if (StringUtils.isBlank((CharSequence)type)) {
                if (configInfo.getDataId().contains(SPOT)) {
                    String extName = configInfo.getDataId().substring(configInfo.getDataId().lastIndexOf(SPOT) + 1);
                    FileTypeEnum fileTypeEnum = FileTypeEnum.getFileTypeEnumByFileExtensionOrFileType(extName);
                    type = fileTypeEnum.getFileType();
                } else {
                    type = FileTypeEnum.getFileTypeEnumByFileExtensionOrFileType(null).getFileType();
                }
            }
            if (configAdvanceInfo == null) {
                configAdvanceInfo = new HashMap<String, Object>(16);
            }
            configAdvanceInfo.put("type", type);
            configAdvanceInfo.put("desc", configInfo.getDesc());
            try {
                ConfigInfoWrapper foundCfg = this.findConfigInfo(configInfo2Save.getDataId(), configInfo2Save.getGroup(), configInfo2Save.getTenant());
                if (foundCfg != null) {
                    throw new Throwable("DuplicateKeyException: config already exists, should be overridden");
                }
                this.addConfigInfo(srcIp, srcUser, configInfo2Save, time, configAdvanceInfo, notify, callFinally);
                ++succCount;
                continue;
            }
            catch (Throwable e) {
                if (!StringUtils.contains((CharSequence)e.toString(), (CharSequence)"DuplicateKeyException")) {
                    throw new NacosException(500, e);
                }
                if (SameConfigPolicy.ABORT.equals((Object)policy)) {
                    failData = new ArrayList();
                    skipData = new ArrayList();
                    HashMap<String, String> faileditem = new HashMap<String, String>(2);
                    faileditem.put(DATA_ID, configInfo2Save.getDataId());
                    faileditem.put(GROUP, configInfo2Save.getGroup());
                    failData.add(faileditem);
                    for (int j = i + 1; j < configInfoList.size(); ++j) {
                        ConfigInfo skipConfigInfo = configInfoList.get(j);
                        HashMap<String, String> skipitem = new HashMap<String, String>(2);
                        skipitem.put(DATA_ID, skipConfigInfo.getDataId());
                        skipitem.put(GROUP, skipConfigInfo.getGroup());
                        skipData.add(skipitem);
                    }
                    break;
                }
                if (SameConfigPolicy.SKIP.equals((Object)policy)) {
                    ++skipCount;
                    if (skipData == null) {
                        skipData = new ArrayList();
                    }
                    HashMap<String, String> skipitem = new HashMap<String, String>(2);
                    skipitem.put(DATA_ID, configInfo2Save.getDataId());
                    skipitem.put(GROUP, configInfo2Save.getGroup());
                    skipData.add(skipitem);
                    continue;
                }
                if (!SameConfigPolicy.OVERWRITE.equals((Object)policy)) continue;
                ++succCount;
                this.updateConfigInfo(configInfo2Save, srcIp, srcUser, time, configAdvanceInfo, notify);
            }
        }
        HashMap<String, Object> result2 = new HashMap<String, Object>(4);
        result2.put("succCount", succCount);
        result2.put("skipCount", skipCount);
        if (failData != null && !failData.isEmpty()) {
            result2.put("failData", failData);
        }
        if (skipData != null && !skipData.isEmpty()) {
            result2.put("skipData", skipData);
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConfigInfo(String dataId, String group, String tenant, String srcIp, String srcUser) {
        Timestamp time = new Timestamp(System.currentTimeMillis());
        ConfigInfoWrapper configInfo = this.findConfigInfo(dataId, group, tenant);
        if (Objects.nonNull(configInfo)) {
            try {
                String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
                this.removeConfigInfoAtomic(dataId, group, tenantTmp, srcIp, srcUser);
                this.removeTagByIdAtomic(configInfo.getId());
                this.historyConfigInfoPersistService.insertConfigHistoryAtomic(configInfo.getId(), configInfo, srcIp, srcUser, time, "D");
                EmbeddedStorageContextUtils.onDeleteConfigInfo(tenantTmp, group, dataId, srcIp, time);
                boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
                if (!result) {
                    throw new NacosConfigException("config deletion failed");
                }
            }
            finally {
                EmbeddedStorageContextUtils.cleanAllContext();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ConfigInfo> removeConfigInfoByIds(List<Long> ids, String srcIp, String srcUser) {
        if (CollectionUtils.isEmpty(ids)) {
            return null;
        }
        ids.removeAll(Collections.singleton(null));
        Timestamp time = new Timestamp(System.currentTimeMillis());
        try {
            String idsStr = StringUtils.join(ids, (String)",");
            List<ConfigInfo> configInfoList = this.findConfigInfosByIds(idsStr);
            if (CollectionUtils.isNotEmpty(configInfoList)) {
                this.removeConfigInfoByIdsAtomic(idsStr);
                for (ConfigInfo configInfo : configInfoList) {
                    this.removeTagByIdAtomic(configInfo.getId());
                    this.historyConfigInfoPersistService.insertConfigHistoryAtomic(configInfo.getId(), configInfo, srcIp, srcUser, time, "D");
                }
            }
            EmbeddedStorageContextUtils.onBatchDeleteConfigInfo(configInfoList);
            boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (!result) {
                throw new NacosConfigException("Failed to config batch deletion");
            }
            List<ConfigInfo> list = configInfoList;
            return list;
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public void removeTagByIdAtomic(long id) {
        ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
        String sql = configTagsRelationMapper.delete(Arrays.asList("id"));
        Object[] args = new Object[]{id};
        EmbeddedStorageContextUtils.addSqlContext(sql, args);
    }

    @Override
    public void removeConfigInfoAtomic(String dataId, String group, String tenant, String srcIp, String srcUser) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.delete(Arrays.asList("data_id", "group_id", TENANT));
        Object[] args = new Object[]{dataId, group, tenantTmp};
        EmbeddedStorageContextUtils.addSqlContext(sql, args);
    }

    @Override
    public void removeConfigInfoByIdsAtomic(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return;
        }
        ArrayList<Long> paramList = new ArrayList<Long>();
        String[] tagArr = ids.split(",");
        for (int i = 0; i < tagArr.length; ++i) {
            paramList.add(Long.parseLong(tagArr[i]));
        }
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.removeConfigInfoByIdsAtomic(paramList.size());
        EmbeddedStorageContextUtils.addSqlContext(sql, paramList.toArray());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateConfigInfo(ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        try {
            String configTags;
            ConfigInfoWrapper oldConfigInfo = this.findConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
            String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
            oldConfigInfo.setTenant(tenantTmp);
            String appNameTmp = oldConfigInfo.getAppName();
            if (configInfo.getAppName() == null) {
                configInfo.setAppName(appNameTmp);
            }
            this.updateConfigInfoAtomic(configInfo, srcIp, srcUser, time, configAdvanceInfo);
            String string = configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
            if (configTags != null) {
                this.removeTagByIdAtomic(oldConfigInfo.getId());
                this.addConfigTagsRelation(oldConfigInfo.getId(), configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
            }
            this.historyConfigInfoPersistService.insertConfigHistoryAtomic(oldConfigInfo.getId(), oldConfigInfo, srcIp, srcUser, time, "U");
            EmbeddedStorageContextUtils.onModifyConfigInfo(configInfo, srcIp, time);
            this.databaseOperate.blockUpdate();
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean updateConfigInfoCas(ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, Map<String, Object> configAdvanceInfo, boolean notify) {
        try {
            String configTags;
            ConfigInfoWrapper oldConfigInfo = this.findConfigInfo(configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
            String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
            oldConfigInfo.setTenant(tenantTmp);
            String appNameTmp = oldConfigInfo.getAppName();
            if (configInfo.getAppName() == null) {
                configInfo.setAppName(appNameTmp);
            }
            this.updateConfigInfoAtomicCas(configInfo, srcIp, srcUser, time, configAdvanceInfo);
            String string = configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
            if (configTags != null) {
                this.removeTagByIdAtomic(oldConfigInfo.getId());
                this.addConfigTagsRelation(oldConfigInfo.getId(), configTags, configInfo.getDataId(), configInfo.getGroup(), configInfo.getTenant());
            }
            this.historyConfigInfoPersistService.insertConfigHistoryAtomic(oldConfigInfo.getId(), oldConfigInfo, srcIp, srcUser, time, "U");
            EmbeddedStorageContextUtils.onModifyConfigInfo(configInfo, srcIp, time);
            boolean bl = this.databaseOperate.blockUpdate();
            return bl;
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    private void updateConfigInfoAtomicCas(ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, Map<String, Object> configAdvanceInfo) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.updateConfigInfoAtomicCas();
        Object[] args = new Object[]{configInfo.getContent(), md5Tmp, srcIp, srcUser, time, appNameTmp, desc, use, effect, type, schema, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, configInfo.getMd5()};
        EmbeddedStorageContextUtils.addSqlContext(sql, args);
    }

    @Override
    public void updateConfigInfoAtomic(ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, Map<String, Object> configAdvanceInfo) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String desc = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("desc");
        String use = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("use");
        String effect = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("effect");
        String type = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("type");
        String schema = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("schema");
        String encryptedDataKey = configInfo.getEncryptedDataKey() == null ? "" : configInfo.getEncryptedDataKey();
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.update(Arrays.asList(CONTENT, "md5", "src_ip", "src_user", "gmt_modified", "app_name", "c_desc", "c_use", "effect", "type", "c_schema", "encrypted_data_key"), Arrays.asList("data_id", "group_id", TENANT));
        Object[] args = new Object[]{configInfo.getContent(), md5Tmp, srcIp, srcUser, time, appNameTmp, desc, use, effect, type, schema, encryptedDataKey, configInfo.getDataId(), configInfo.getGroup(), tenantTmp};
        EmbeddedStorageContextUtils.addSqlContext(sql, args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateMd5(String dataId, String group, String tenant, String md5, Timestamp lastTime) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        try {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            String sql = configInfoMapper.update(Arrays.asList("md5"), Arrays.asList("data_id", "group_id", TENANT, "gmt_modified"));
            Object[] args = new Object[]{md5, dataId, group, tenantTmp, lastTime};
            EmbeddedStorageContextUtils.addSqlContext(sql, args);
            boolean result = this.databaseOperate.update(EmbeddedStorageContextUtils.getCurrentSqlContext());
            if (!result) {
                throw new NacosConfigException("Failed to config the MD5 modification");
            }
        }
        finally {
            EmbeddedStorageContextUtils.cleanAllContext();
        }
    }

    @Override
    public long findConfigMaxId() {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.findConfigMaxId();
        return Optional.ofNullable(this.databaseOperate.queryOne(sql, Long.class)).orElse(0L);
    }

    @Override
    public List<ConfigInfo> findAllDataIdAndGroup() {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.findAllDataIdAndGroup();
        return this.databaseOperate.queryMany(sql, EMPTY_ARRAY, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public ConfigInfoBase findConfigInfoBase(String dataId, String group) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.select(Arrays.asList("id", "data_id", "group_id", CONTENT), Arrays.asList("data_id", "group_id", TENANT));
        return this.databaseOperate.queryOne(sql, new Object[]{dataId, group, ""}, RowMapperManager.CONFIG_INFO_BASE_ROW_MAPPER);
    }

    @Override
    public ConfigInfo findConfigInfo(long id) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.select(Arrays.asList("id", "data_id", "group_id", TENANT, "app_name", CONTENT), Collections.singletonList("id"));
        return this.databaseOperate.queryOne(sql, new Object[]{id}, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public ConfigInfoWrapper findConfigInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.select(Arrays.asList("id", "data_id", "group_id", TENANT, "app_name", CONTENT, "md5", "type", "encrypted_data_key"), Arrays.asList("data_id", "group_id", TENANT));
        Object[] args = new Object[]{dataId, group, tenantTmp};
        return this.databaseOperate.queryOne(sql, args, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfo> findConfigInfo4Page(int pageNo, int pageSize, String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get(APP_NAME);
        String content = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get(CONTENT);
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        String sql = null;
        String sqlCount = null;
        ArrayList<String> paramList = new ArrayList<String>();
        paramList.add(tenantTmp);
        HashMap<String, String> paramsMap = new HashMap<String, String>(16);
        if (StringUtils.isNotBlank((String)dataId)) {
            paramList.add(dataId);
            paramsMap.put(DATA_ID, DATA_ID);
        }
        if (StringUtils.isNotBlank((String)group)) {
            paramList.add(group);
            paramsMap.put(GROUP, GROUP);
        }
        if (StringUtils.isNotBlank((String)appName)) {
            paramList.add(appName);
            paramsMap.put(APP_NAME, APP_NAME);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            paramList.add(content);
            paramsMap.put(CONTENT, CONTENT);
        }
        int startRow = (pageNo - 1) * pageSize;
        if (StringUtils.isNotBlank((String)configTags)) {
            String[] tagArr = configTags.split(",");
            paramList.addAll(Arrays.asList(tagArr));
            ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
            sqlCount = configTagsRelationMapper.findConfigInfo4PageCountRows(paramsMap, tagArr.length);
            sql = configTagsRelationMapper.findConfigInfo4PageFetchRows(paramsMap, tagArr.length, startRow, pageSize);
        } else {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            sqlCount = configInfoMapper.findConfigInfo4PageCountRows(paramsMap);
            sql = configInfoMapper.findConfigInfo4PageFetchRows(paramsMap, startRow, pageSize);
        }
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        Page<ConfigInfo> page = helper.fetchPage(sqlCount, sql, paramList.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        for (ConfigInfo configInfo : page.getPageItems()) {
            Pair pair = EncryptionHandler.decryptHandler((String)configInfo.getDataId(), (String)configInfo.getEncryptedDataKey(), (String)configInfo.getContent());
            configInfo.setContent((String)pair.getSecond());
        }
        return page;
    }

    @Override
    public Page<ConfigInfo> findConfigInfoByApp(int pageNo, int pageSize, String tenant, String appName) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        return helper.fetchPage(configInfoMapper.findConfigInfoByAppCountRows(), configInfoMapper.findConfigInfoByAppFetchRows(startRow, pageSize), new Object[]{this.generateLikeArgument(tenantTmp), appName}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfoBase> findConfigInfoBaseByGroup(int pageNo, int pageSize, String group) {
        PaginationHelper<ConfigInfoBase> helper = this.createPaginationHelper();
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        return helper.fetchPage(configInfoMapper.count(Arrays.asList("group_id", TENANT)), configInfoMapper.findConfigInfoBaseByGroupFetchRows(startRow, pageSize), new Object[]{group, ""}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_BASE_ROW_MAPPER);
    }

    @Override
    public int configInfoCount() {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.count(null);
        Integer result = this.databaseOperate.queryOne(sql, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoCount error");
        }
        return result;
    }

    @Override
    public int configInfoCount(String tenant) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.configInfoLikeTenantCount();
        Integer result = this.databaseOperate.queryOne(sql, new Object[]{tenant}, Integer.class);
        if (result == null) {
            throw new IllegalArgumentException("configInfoCount error");
        }
        return result;
    }

    @Override
    public List<String> getTenantIdList(int page, int pageSize) {
        PaginationHelper<Map<String, Object>> helper = this.createPaginationHelper();
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        int from = (page - 1) * pageSize;
        String sql = configInfoMapper.getTenantIdList(from, pageSize);
        Page<Map<String, Object>> pageList = helper.fetchPageLimit(sql, new Object[0], page, pageSize, RowMapperManager.MAP_ROW_MAPPER);
        return pageList.getPageItems().stream().map(map -> String.valueOf(map.get("TENANT_ID"))).collect(Collectors.toList());
    }

    @Override
    public List<String> getGroupIdList(int page, int pageSize) {
        PaginationHelper<Map<String, Object>> helper = this.createPaginationHelper();
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        int from = (page - 1) * pageSize;
        String sql = configInfoMapper.getGroupIdList(from, pageSize);
        Page<Map<String, Object>> pageList = helper.fetchPageLimit(sql, new Object[0], page, pageSize, RowMapperManager.MAP_ROW_MAPPER);
        return pageList.getPageItems().stream().map(map -> String.valueOf(map.get("GROUP_ID"))).collect(Collectors.toList());
    }

    @Override
    public Page<ConfigInfo> findAllConfigInfo(int pageNo, int pageSize, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sqlCountRows = configInfoMapper.count(null);
        String sqlFetchRows = configInfoMapper.findAllConfigInfoFetchRows(startRow, pageSize);
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[]{this.generateLikeArgument(tenantTmp), (pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public Page<ConfigKey> findAllConfigKey(int pageNo, int pageSize, String tenant) {
        int pageCount;
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String select = configInfoMapper.findAllConfigKey((pageNo - 1) * pageSize, pageSize);
        int totalCount = this.configInfoCount(tenant);
        if (totalCount > pageSize * (pageCount = totalCount / pageSize)) {
            ++pageCount;
        }
        if (pageNo > pageCount) {
            return null;
        }
        Page<ConfigKey> page = new Page<ConfigKey>();
        page.setPageNumber(pageNo);
        page.setPagesAvailable(pageCount);
        page.setTotalCount(totalCount);
        List<ConfigKey> result = this.databaseOperate.queryMany(select, new Object[]{this.generateLikeArgument(tenantTmp)}, RowMapperManager.CONFIG_KEY_ROW_MAPPER);
        for (ConfigKey item : result) {
            page.getPageItems().add(item);
        }
        return page;
    }

    @Override
    public Page<ConfigInfoWrapper> findAllConfigInfoFragment(long lastMaxId, int pageSize) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String select = configInfoMapper.findAllConfigInfoFragment(0, pageSize);
        PaginationHelper<ConfigInfoWrapper> helper = this.createPaginationHelper();
        return helper.fetchPageLimit(select, new Object[]{lastMaxId}, 1, pageSize, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfo> findConfigInfoLike(int pageNo, int pageSize, ConfigKey[] configKeys, boolean blacklist) {
        String sqlCountRows = "SELECT count(*) FROM config_info WHERE ";
        String sqlFetchRows = "SELECT id,data_id,group_id,tenant_id,app_name,content FROM config_info WHERE ";
        StringBuilder where = new StringBuilder(" 1=1 ");
        if (configKeys.length == 0 && !blacklist) {
            Page<ConfigInfo> page = new Page<ConfigInfo>();
            page.setTotalCount(0);
            return page;
        }
        ArrayList<String> params = new ArrayList<String>();
        boolean isFirst = true;
        for (ConfigKey configInfo : configKeys) {
            boolean isFirstSub;
            String dataId = configInfo.getDataId();
            String group = configInfo.getGroup();
            String appName = configInfo.getAppName();
            if (StringUtils.isBlank((CharSequence)dataId) && StringUtils.isBlank((CharSequence)group) && StringUtils.isBlank((CharSequence)appName)) break;
            if (blacklist) {
                if (isFirst) {
                    isFirst = false;
                    where.append(" AND ");
                } else {
                    where.append(" AND ");
                }
                where.append('(');
                isFirstSub = true;
                if (!StringUtils.isBlank((CharSequence)dataId)) {
                    where.append(" data_id NOT LIKE ? ");
                    params.add(this.generateLikeArgument(dataId));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((CharSequence)group)) {
                    if (!isFirstSub) {
                        where.append(" OR ");
                    }
                    where.append(" group_id NOT LIKE ? ");
                    params.add(this.generateLikeArgument(group));
                    isFirstSub = false;
                }
                if (!StringUtils.isBlank((CharSequence)appName)) {
                    if (!isFirstSub) {
                        where.append(" OR ");
                    }
                    where.append(" app_name != ? ");
                    params.add(appName);
                    isFirstSub = false;
                }
                where.append(") ");
                continue;
            }
            if (isFirst) {
                isFirst = false;
                where.append(" AND ");
            } else {
                where.append(" OR ");
            }
            where.append('(');
            isFirstSub = true;
            if (!StringUtils.isBlank((CharSequence)dataId)) {
                where.append(" data_id LIKE ? ");
                params.add(this.generateLikeArgument(dataId));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((CharSequence)group)) {
                if (!isFirstSub) {
                    where.append(" AND ");
                }
                where.append(" group_id LIKE ? ");
                params.add(this.generateLikeArgument(group));
                isFirstSub = false;
            }
            if (!StringUtils.isBlank((CharSequence)appName)) {
                if (!isFirstSub) {
                    where.append(" AND ");
                }
                where.append(" app_name = ? ");
                params.add(appName);
                isFirstSub = false;
            }
            where.append(") ");
        }
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        return helper.fetchPage(sqlCountRows + where, sqlFetchRows + where, params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfo> findConfigInfoLike4Page(int pageNo, int pageSize, String dataId, String group, String tenant, Map<String, Object> configAdvanceInfo) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        String appName = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get(APP_NAME);
        String content = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get(CONTENT);
        String configTags = configAdvanceInfo == null ? null : (String)configAdvanceInfo.get("config_tags");
        String sqlCountRows = null;
        String sqlFetchRows = null;
        HashMap<String, String> paramsMap = new HashMap<String, String>(16);
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.generateLikeArgument(tenantTmp));
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            params.add(this.generateLikeArgument(dataId));
            paramsMap.put(DATA_ID, DATA_ID);
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            params.add(this.generateLikeArgument(group));
            paramsMap.put(GROUP, GROUP);
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            params.add(appName);
            paramsMap.put(APP_NAME, APP_NAME);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            params.add(this.generateLikeArgument(content));
            paramsMap.put(CONTENT, CONTENT);
        }
        int startRow = (pageNo - 1) * pageSize;
        if (StringUtils.isNotBlank((String)configTags)) {
            String[] tagArr = configTags.split(",");
            params.addAll(Arrays.asList(tagArr));
            ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
            sqlCountRows = configTagsRelationMapper.findConfigInfoLike4PageCountRows(paramsMap, tagArr.length);
            sqlFetchRows = configTagsRelationMapper.findConfigInfoLike4PageFetchRows(paramsMap, tagArr.length, startRow, pageSize);
        } else {
            ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
            sqlCountRows = configInfoMapper.findConfigInfoLike4PageCountRows(paramsMap);
            sqlFetchRows = configInfoMapper.findConfigInfoLike4PageFetchRows(paramsMap, startRow, pageSize);
        }
        PaginationHelper<ConfigInfo> helper = this.createPaginationHelper();
        Page<ConfigInfo> page = helper.fetchPage(sqlCountRows, sqlFetchRows, params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_ROW_MAPPER);
        for (ConfigInfo configInfo : page.getPageItems()) {
            Pair pair = EncryptionHandler.decryptHandler((String)configInfo.getDataId(), (String)configInfo.getEncryptedDataKey(), (String)configInfo.getContent());
            configInfo.setContent((String)pair.getSecond());
        }
        return page;
    }

    @Override
    public Page<ConfigInfoBase> findConfigInfoBaseLike(int pageNo, int pageSize, String dataId, String group, String content) throws IOException {
        if (StringUtils.isBlank((CharSequence)dataId) && StringUtils.isBlank((CharSequence)group)) {
            throw new IOException("invalid param");
        }
        HashMap<String, String> paramsMap = new HashMap<String, String>(16);
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            params.add(this.generateLikeArgument(dataId));
            paramsMap.put(DATA_ID, DATA_ID);
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            params.add(this.generateLikeArgument(group));
            paramsMap.put(GROUP, GROUP);
        }
        if (!StringUtils.isBlank((CharSequence)content)) {
            params.add(this.generateLikeArgument(content));
            paramsMap.put(CONTENT, CONTENT);
        }
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sqlCountRows = configInfoMapper.findConfigInfoBaseLikeCountRows(paramsMap);
        String sqlFetchRows = configInfoMapper.findConfigInfoBaseLikeFetchRows(paramsMap, startRow, pageSize);
        PaginationHelper<ConfigInfoBase> helper = this.createPaginationHelper();
        return helper.fetchPage(sqlCountRows, sqlFetchRows, params.toArray(), pageNo, pageSize, RowMapperManager.CONFIG_INFO_BASE_ROW_MAPPER);
    }

    @Override
    public List<ConfigInfoWrapper> findChangeConfig(Timestamp startTime, Timestamp endTime) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        List<Map<String, Object>> list = this.databaseOperate.queryMany(configInfoMapper.findChangeConfig(), new Object[]{startTime, endTime});
        return this.convertChangeConfig(list);
    }

    @Override
    public Page<ConfigInfoWrapper> findChangeConfig(String dataId, String group, String tenant, String appName, Timestamp startTime, Timestamp endTime, int pageNo, int pageSize, long lastMaxId) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        HashMap<String, String> paramsMap = new HashMap<String, String>(16);
        ArrayList<Object> params = new ArrayList<Object>();
        if (!StringUtils.isBlank((CharSequence)dataId)) {
            params.add(this.generateLikeArgument(dataId));
            paramsMap.put(DATA_ID, DATA_ID);
        }
        if (!StringUtils.isBlank((CharSequence)group)) {
            params.add(this.generateLikeArgument(group));
            paramsMap.put(GROUP, GROUP);
        }
        if (!StringUtils.isBlank((CharSequence)tenantTmp)) {
            params.add(tenantTmp);
            paramsMap.put(TENANT, TENANT);
        }
        if (!StringUtils.isBlank((CharSequence)appName)) {
            params.add(appName);
            paramsMap.put(APP_NAME, APP_NAME);
        }
        if (startTime != null) {
            params.add(startTime);
        }
        if (endTime != null) {
            params.add(endTime);
        }
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sqlCountRows = configInfoMapper.findChangeConfigCountRows(paramsMap, startTime, endTime);
        String sqlFetchRows = configInfoMapper.findChangeConfigFetchRows(paramsMap, startTime, endTime, startRow, pageSize, lastMaxId);
        PaginationHelper<ConfigInfoWrapper> helper = this.createPaginationHelper();
        return helper.fetchPage(sqlCountRows, sqlFetchRows, params.toArray(), pageNo, pageSize, lastMaxId, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
    }

    @Override
    public List<String> selectTagByConfig(String dataId, String group, String tenant) {
        ConfigTagsRelationMapper configTagsRelationMapper = (ConfigTagsRelationMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_tags_relation");
        String sql = configTagsRelationMapper.select(Arrays.asList("tag_name"), Arrays.asList("data_id", "group_id", TENANT));
        return this.databaseOperate.queryMany(sql, new Object[]{dataId, group, tenant}, String.class);
    }

    @Override
    public List<ConfigInfo> findConfigInfosByIds(String ids) {
        if (StringUtils.isBlank((CharSequence)ids)) {
            return null;
        }
        ArrayList<Long> paramList = new ArrayList<Long>();
        String[] tagArr = ids.split(",");
        for (int i = 0; i < tagArr.length; ++i) {
            paramList.add(Long.parseLong(tagArr[i]));
        }
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        return this.databaseOperate.queryMany(configInfoMapper.findConfigInfosByIds(tagArr.length), paramList.toArray(), RowMapperManager.CONFIG_INFO_ROW_MAPPER);
    }

    @Override
    public ConfigAdvanceInfo findConfigAdvanceInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        List<String> configTagList = this.selectTagByConfig(dataId, group, tenant);
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        ConfigAdvanceInfo configAdvance = this.databaseOperate.queryOne(configInfoMapper.select(Arrays.asList("gmt_create", "gmt_modified", "src_user", "src_ip", "c_desc", "c_use", "effect", "type", "c_schema"), Arrays.asList("data_id", "group_id", TENANT)), new Object[]{dataId, group, tenantTmp}, RowMapperManager.CONFIG_ADVANCE_INFO_ROW_MAPPER);
        if (CollectionUtils.isNotEmpty(configTagList)) {
            StringBuilder configTagsTmp = new StringBuilder();
            for (String configTag : configTagList) {
                if (configTagsTmp.length() == 0) {
                    configTagsTmp.append(configTag);
                    continue;
                }
                configTagsTmp.append(',').append(configTag);
            }
            configAdvance.setConfigTags(configTagsTmp.toString());
        }
        return configAdvance;
    }

    @Override
    public ConfigAllInfo findConfigAllInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.select(Arrays.asList("id", "data_id", "group_id", TENANT, "app_name", CONTENT, "md5", "gmt_create", "gmt_modified", "src_user", "src_ip", "c_desc", "c_use", "effect", "type", "c_schema", "encrypted_data_key"), Arrays.asList("data_id", "group_id", TENANT));
        List<String> configTagList = this.selectTagByConfig(dataId, group, tenant);
        ConfigAllInfo configAdvance = this.databaseOperate.queryOne(sql, new Object[]{dataId, group, tenantTmp}, RowMapperManager.CONFIG_ALL_INFO_ROW_MAPPER);
        if (configTagList != null && !configTagList.isEmpty()) {
            StringBuilder configTagsTmp = new StringBuilder();
            for (String configTag : configTagList) {
                if (configTagsTmp.length() == 0) {
                    configTagsTmp.append(configTag);
                    continue;
                }
                configTagsTmp.append(',').append(configTag);
            }
            configAdvance.setConfigTags(configTagsTmp.toString());
        }
        return configAdvance;
    }

    @Override
    public List<ConfigInfo> convertDeletedConfig(List<Map<String, Object>> list) {
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        for (Map<String, Object> map : list) {
            String dataId = (String)map.get("data_id");
            String group = (String)map.get("group_id");
            String tenant = (String)map.get(TENANT);
            ConfigInfo config = new ConfigInfo();
            config.setDataId(dataId);
            config.setGroup(group);
            config.setTenant(tenant);
            configs.add(config);
        }
        return configs;
    }

    @Override
    public List<ConfigInfoWrapper> convertChangeConfig(List<Map<String, Object>> list) {
        ArrayList<ConfigInfoWrapper> configs = new ArrayList<ConfigInfoWrapper>();
        for (Map<String, Object> map : list) {
            String dataId = (String)map.get("data_id");
            String group = (String)map.get("group_id");
            String tenant = (String)map.get(TENANT);
            String content = (String)map.get(CONTENT);
            long mTime = ((Timestamp)map.get("gmt_modified")).getTime();
            ConfigInfoWrapper config = new ConfigInfoWrapper();
            config.setDataId(dataId);
            config.setGroup(group);
            config.setTenant(tenant);
            config.setContent(content);
            config.setLastModified(mTime);
            configs.add(config);
        }
        return configs;
    }

    @Override
    public List<ConfigInfoWrapper> listAllGroupKeyMd5() {
        int pageSize = 10000;
        int totalCount = this.configInfoCount();
        int pageCount = (int)Math.ceil((double)totalCount * 1.0 / 10000.0);
        ArrayList<ConfigInfoWrapper> allConfigInfo = new ArrayList<ConfigInfoWrapper>();
        for (int pageNo = 1; pageNo <= pageCount; ++pageNo) {
            List<ConfigInfoWrapper> configInfoList = this.listGroupKeyMd5ByPage(pageNo, 10000);
            allConfigInfo.addAll(configInfoList);
        }
        return allConfigInfo;
    }

    @Override
    public List<ConfigInfoWrapper> listGroupKeyMd5ByPage(int pageNo, int pageSize) {
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sqlCountRows = configInfoMapper.count(null);
        String sqlFetchRows = configInfoMapper.listGroupKeyMd5ByPageFetchRows((pageNo - 1) * pageSize, pageSize);
        PaginationHelper<ConfigInfoWrapper> helper = this.createPaginationHelper();
        Page<ConfigInfoWrapper> page = helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[0], pageNo, pageSize, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
        return page.getPageItems();
    }

    @Override
    public ConfigInfoWrapper queryConfigInfo(String dataId, String group, String tenant) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.select(Arrays.asList("id", "data_id", "group_id", TENANT, "app_name", CONTENT, "type", "gmt_modified", "md5", "encrypted_data_key"), Arrays.asList("data_id", "group_id", TENANT));
        return this.databaseOperate.queryOne(sql, new Object[]{dataId, group, tenantTmp}, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
    }

    @Override
    public List<ConfigAllInfo> findAllConfigInfo4Export(String dataId, String group, String tenant, String appName, List<Long> ids) {
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        HashMap<String, String> params = new HashMap<String, String>(16);
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (!CollectionUtils.isEmpty(ids)) {
            paramList.addAll(ids);
        } else {
            paramList.add(tenantTmp);
            params.put(TENANT, TENANT);
            if (!StringUtils.isBlank((CharSequence)dataId)) {
                paramList.add(this.generateLikeArgument(dataId));
                params.put(DATA_ID, DATA_ID);
            }
            if (StringUtils.isNotBlank((String)group)) {
                paramList.add(group);
                params.put(GROUP, GROUP);
            }
            if (StringUtils.isNotBlank((String)appName)) {
                paramList.add(appName);
                params.put(APP_NAME, APP_NAME);
            }
        }
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.findAllConfigInfo4Export(ids, params);
        return this.databaseOperate.queryMany(sql, paramList.toArray(), RowMapperManager.CONFIG_ALL_INFO_ROW_MAPPER);
    }

    @Override
    public List<ConfigInfoWrapper> queryConfigInfoByNamespace(String tenantId) {
        if (Objects.isNull(tenantId)) {
            throw new IllegalArgumentException("tenantId can not be null");
        }
        String tenantTmp = StringUtils.isBlank((CharSequence)tenantId) ? "" : tenantId;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sql = configInfoMapper.select(Arrays.asList("data_id", "group_id", TENANT, "app_name", "type"), Collections.singletonList(TENANT));
        return this.databaseOperate.queryMany(sql, new Object[]{tenantTmp}, RowMapperManager.CONFIG_INFO_WRAPPER_ROW_MAPPER);
    }

    @Override
    public Page<ConfigInfoBase> findAllConfigInfoBase(int pageNo, int pageSize) {
        int startRow = (pageNo - 1) * pageSize;
        ConfigInfoMapper configInfoMapper = (ConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "config_info");
        String sqlCountRows = configInfoMapper.count(null);
        String sqlFetchRows = configInfoMapper.findAllConfigInfoBaseFetchRows(startRow, pageSize);
        PaginationHelper<ConfigInfoBase> helper = this.createPaginationHelper();
        return helper.fetchPageLimit(sqlCountRows, sqlFetchRows, new Object[]{(pageNo - 1) * pageSize, pageSize}, pageNo, pageSize, RowMapperManager.CONFIG_INFO_BASE_ROW_MAPPER);
    }
}

