/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.config.server.service.repository.extrnal;

import com.alibaba.nacos.common.utils.MD5Utils;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.config.server.configuration.ConditionOnExternalStorage;
import com.alibaba.nacos.config.server.model.ConfigHistoryInfo;
import com.alibaba.nacos.config.server.model.ConfigInfo;
import com.alibaba.nacos.config.server.model.Page;
import com.alibaba.nacos.config.server.service.datasource.DataSourceService;
import com.alibaba.nacos.config.server.service.datasource.DynamicDataSource;
import com.alibaba.nacos.config.server.service.repository.HistoryConfigInfoPersistService;
import com.alibaba.nacos.config.server.service.repository.PaginationHelper;
import com.alibaba.nacos.config.server.service.repository.RowMapperManager;
import com.alibaba.nacos.config.server.service.repository.extrnal.ExternalStoragePaginationHelperImpl;
import com.alibaba.nacos.config.server.utils.LogUtil;
import com.alibaba.nacos.plugin.datasource.MapperManager;
import com.alibaba.nacos.plugin.datasource.mapper.HistoryConfigInfoMapper;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.springframework.context.annotation.Conditional;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionTemplate;

@Conditional(value={ConditionOnExternalStorage.class})
@Service(value="externalHistoryConfigInfoPersistServiceImpl")
public class ExternalHistoryConfigInfoPersistServiceImpl
implements HistoryConfigInfoPersistService {
    private DataSourceService dataSourceService = DynamicDataSource.getInstance().getDataSource();
    protected JdbcTemplate jt = this.dataSourceService.getJdbcTemplate();
    protected TransactionTemplate tjt = this.dataSourceService.getTransactionTemplate();
    private MapperManager mapperManager;

    public ExternalHistoryConfigInfoPersistServiceImpl() {
        Boolean isDataSourceLogEnable = (Boolean)EnvUtil.getProperty((String)"nacos.plugin.datasource.log.enabled", Boolean.class, (Object)false);
        this.mapperManager = MapperManager.instance((boolean)isDataSourceLogEnable);
    }

    @Override
    public <E> PaginationHelper<E> createPaginationHelper() {
        return new ExternalStoragePaginationHelperImpl(this.jt);
    }

    @Override
    public List<ConfigInfo> convertDeletedConfig(List<Map<String, Object>> list) {
        ArrayList<ConfigInfo> configs = new ArrayList<ConfigInfo>();
        for (Map<String, Object> map : list) {
            String dataId = (String)map.get("data_id");
            String group = (String)map.get("group_id");
            String tenant = (String)map.get("tenant_id");
            ConfigInfo config = new ConfigInfo();
            config.setDataId(dataId);
            config.setGroup(group);
            config.setTenant(tenant);
            configs.add(config);
        }
        return configs;
    }

    @Override
    public void insertConfigHistoryAtomic(long id, ConfigInfo configInfo, String srcIp, String srcUser, Timestamp time, String ops) {
        String appNameTmp = StringUtils.isBlank((CharSequence)configInfo.getAppName()) ? "" : configInfo.getAppName();
        String tenantTmp = StringUtils.isBlank((CharSequence)configInfo.getTenant()) ? "" : configInfo.getTenant();
        String md5Tmp = MD5Utils.md5Hex((String)configInfo.getContent(), (String)"UTF-8");
        String encryptedDataKey = StringUtils.isBlank((CharSequence)configInfo.getEncryptedDataKey()) ? "" : configInfo.getEncryptedDataKey();
        try {
            HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
            this.jt.update(historyConfigInfoMapper.insert(Arrays.asList("id", "data_id", "group_id", "tenant_id", "app_name", "content", "md5", "src_ip", "src_user", "gmt_modified", "op_type", "encrypted_data_key")), new Object[]{id, configInfo.getDataId(), configInfo.getGroup(), tenantTmp, appNameTmp, configInfo.getContent(), md5Tmp, srcIp, srcUser, time, ops, encryptedDataKey});
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public void removeConfigHistory(Timestamp startTime, int limitSize) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        String sql = historyConfigInfoMapper.removeConfigHistory();
        PaginationHelper paginationHelper = this.createPaginationHelper();
        paginationHelper.updateLimit(sql, new Object[]{startTime, limitSize});
    }

    @Override
    public List<ConfigInfo> findDeletedConfig(Timestamp startTime, Timestamp endTime) {
        try {
            HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
            List list = this.jt.queryForList(historyConfigInfoMapper.findDeletedConfig(), new Object[]{startTime, endTime});
            return this.convertDeletedConfig(list);
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[db-error] " + (Object)((Object)e), (Throwable)e);
            throw e;
        }
    }

    @Override
    public Page<ConfigHistoryInfo> findConfigHistory(String dataId, String group, String tenant, int pageNo, int pageSize) {
        PaginationHelper<ConfigHistoryInfo> helper = this.createPaginationHelper();
        String tenantTmp = StringUtils.isBlank((CharSequence)tenant) ? "" : tenant;
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        String sqlCountRows = historyConfigInfoMapper.count(Arrays.asList("data_id", "group_id", "tenant_id"));
        String sqlFetchRows = historyConfigInfoMapper.pageFindConfigHistoryFetchRows(pageNo, pageSize);
        Page<ConfigHistoryInfo> page = null;
        try {
            page = helper.fetchPage(sqlCountRows, sqlFetchRows, new Object[]{dataId, group, tenantTmp}, pageNo, pageSize, RowMapperManager.HISTORY_LIST_ROW_MAPPER);
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[list-config-history] error, dataId:{}, group:{}", (Object)new Object[]{dataId, group}, (Object)e);
            throw e;
        }
        return page;
    }

    @Override
    public ConfigHistoryInfo detailConfigHistory(Long nid) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        String sqlFetchRows = historyConfigInfoMapper.select(Arrays.asList("nid", "data_id", "group_id", "tenant_id", "app_name", "content", "md5", "src_user", "src_ip", "op_type", "gmt_create", "gmt_modified", "encrypted_data_key"), Collections.singletonList("nid"));
        try {
            ConfigHistoryInfo historyInfo = (ConfigHistoryInfo)this.jt.queryForObject(sqlFetchRows, new Object[]{nid}, (RowMapper)RowMapperManager.HISTORY_DETAIL_ROW_MAPPER);
            return historyInfo;
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[detail-config-history] error, nid:{}", (Object)new Object[]{nid}, (Object)e);
            throw e;
        }
    }

    @Override
    public ConfigHistoryInfo detailPreviousConfigHistory(Long id) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        String sqlFetchRows = historyConfigInfoMapper.detailPreviousConfigHistory();
        try {
            ConfigHistoryInfo historyInfo = (ConfigHistoryInfo)this.jt.queryForObject(sqlFetchRows, new Object[]{id}, (RowMapper)RowMapperManager.HISTORY_DETAIL_ROW_MAPPER);
            return historyInfo;
        }
        catch (DataAccessException e) {
            LogUtil.FATAL_LOG.error("[detail-previous-config-history] error, id:{}", (Object)new Object[]{id}, (Object)e);
            throw e;
        }
    }

    @Override
    public int findConfigHistoryCountByTime(Timestamp startTime) {
        HistoryConfigInfoMapper historyConfigInfoMapper = (HistoryConfigInfoMapper)this.mapperManager.findMapper(this.dataSourceService.getDataSourceType(), "his_config_info");
        String sql = historyConfigInfoMapper.findConfigHistoryCountByTime();
        Integer result = (Integer)this.jt.queryForObject(sql, Integer.class, new Object[]{startTime});
        if (result == null) {
            throw new IllegalArgumentException("findConfigHistoryCountByTime error");
        }
        return result;
    }
}

