/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.control.ruleactivator;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.control.Loggers;
import com.alibaba.nacos.plugin.control.configs.ControlConfigs;
import com.alibaba.nacos.plugin.control.ruleactivator.ControlRuleChangeActivator;
import com.alibaba.nacos.plugin.control.ruleactivator.ExternalRuleStorage;
import com.alibaba.nacos.plugin.control.ruleactivator.LocalDiskRuleStorage;
import com.alibaba.nacos.plugin.control.ruleactivator.RuleStorage;
import java.util.Collection;
import org.slf4j.Logger;

public class RuleStorageProxy {
    private static final Logger LOGGER = Loggers.CONTROL;
    private static final RuleStorageProxy INSTANCE = new RuleStorageProxy();
    private LocalDiskRuleStorage localDiskRuleStorage = null;
    private ExternalRuleStorage externalRuleStorage = null;
    ControlRuleChangeActivator controlRuleChangeActivator = null;

    public RuleStorageProxy() {
        Collection persistRuleActivators = NacosServiceLoader.load(ExternalRuleStorage.class);
        String rulePersistActivator = ControlConfigs.getInstance().getRuleExternalStorage();
        for (ExternalRuleStorage persistRuleActivator : persistRuleActivators) {
            if (!persistRuleActivator.getName().equalsIgnoreCase(rulePersistActivator)) continue;
            LOGGER.info("Found persist rule storage of name \uff1a" + rulePersistActivator);
            this.externalRuleStorage = persistRuleActivator;
            break;
        }
        if (this.externalRuleStorage == null && StringUtils.isNotBlank((String)rulePersistActivator)) {
            LOGGER.error("Fail to found persist rule storage of name \uff1a" + rulePersistActivator);
        }
        this.localDiskRuleStorage = new LocalDiskRuleStorage();
        if (StringUtils.isNotBlank((String)ControlConfigs.getInstance().getLocalRuleStorageBaseDir())) {
            this.localDiskRuleStorage.setLocalRruleBaseDir(ControlConfigs.getInstance().getLocalRuleStorageBaseDir());
        }
        this.controlRuleChangeActivator = new ControlRuleChangeActivator();
    }

    public RuleStorage getLocalDiskStorage() {
        return this.localDiskRuleStorage;
    }

    public RuleStorage getExternalStorage() {
        return this.externalRuleStorage;
    }

    public static final RuleStorageProxy getInstance() {
        return INSTANCE;
    }
}

