/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region.service;

import java.io.IOException;
import org.lionsoul.ip2region.service.Config;
import org.lionsoul.ip2region.service.SearcherPool;
import org.lionsoul.ip2region.xdb.InetAddressException;
import org.lionsoul.ip2region.xdb.Searcher;
import org.lionsoul.ip2region.xdb.Util;
import org.lionsoul.ip2region.xdb.XdbException;

public class Ip2Region {
    private final SearcherPool v4Pool;
    private final Searcher v4InMemSearcher;
    private final SearcherPool v6Pool;
    private final Searcher v6InMemSearcher;

    public static final Ip2Region create(Config v4Config, Config v6Config) throws IOException {
        return new Ip2Region(v4Config, v6Config).init();
    }

    public static final Ip2Region create(String v4XdbPath, String v6XdbPath) throws IOException, XdbException {
        return new Ip2Region(v4XdbPath, v6XdbPath).init();
    }

    protected Ip2Region(String v4XdbPath, String v6XdbPath) throws IOException, XdbException {
        this(v4XdbPath == null ? null : Config.custom().setXdbPath(v4XdbPath).asV4(), v6XdbPath == null ? null : Config.custom().setXdbPath(v6XdbPath).asV6());
    }

    protected Ip2Region(Config v4Config, Config v6Config) throws IOException {
        if (v4Config == null) {
            this.v4InMemSearcher = null;
            this.v4Pool = null;
        } else if (v4Config.cachePolicy == 2) {
            this.v4InMemSearcher = Searcher.newWithBuffer(v4Config.ipVersion, v4Config.cBuffer);
            this.v4Pool = null;
        } else {
            this.v4InMemSearcher = null;
            this.v4Pool = new SearcherPool(v4Config);
        }
        if (v6Config == null) {
            this.v6InMemSearcher = null;
            this.v6Pool = null;
        } else if (v6Config.cachePolicy == 2) {
            this.v6InMemSearcher = Searcher.newWithBuffer(v6Config.ipVersion, v6Config.cBuffer);
            this.v6Pool = null;
        } else {
            this.v6InMemSearcher = null;
            this.v6Pool = new SearcherPool(v6Config);
        }
    }

    protected Ip2Region init() throws IOException {
        if (this.v4Pool != null) {
            this.v4Pool.init();
        }
        if (this.v6Pool != null) {
            this.v6Pool.init();
        }
        return this;
    }

    public String search(String ipString) throws InetAddressException, IOException, InterruptedException {
        return this.search(Util.parseIP(ipString));
    }

    public String search(byte[] ipBytes) throws InetAddressException, IOException, InterruptedException {
        if (ipBytes.length == 4) {
            return this.v4Search(ipBytes);
        }
        if (ipBytes.length == 16) {
            return this.v6Search(ipBytes);
        }
        throw new InetAddressException("invalid byte ip address with length=" + ipBytes.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String v4Search(byte[] ipBytes) throws IOException, InetAddressException, InterruptedException {
        if (this.v4InMemSearcher != null) {
            return this.v4InMemSearcher.search(ipBytes);
        }
        if (this.v4Pool == null) {
            return null;
        }
        Searcher searcher = this.v4Pool.borrowSearcher();
        try {
            String string = searcher.search(ipBytes);
            return string;
        }
        finally {
            this.v4Pool.returnSearcher(searcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String v6Search(byte[] ipBytes) throws IOException, InetAddressException, InterruptedException {
        if (this.v6InMemSearcher != null) {
            return this.v6InMemSearcher.search(ipBytes);
        }
        if (this.v6Pool == null) {
            return null;
        }
        Searcher searcher = this.v6Pool.borrowSearcher();
        try {
            String string = searcher.search(ipBytes);
            return string;
        }
        finally {
            this.v6Pool.returnSearcher(searcher);
        }
    }

    public void close() throws InterruptedException {
        this.close(10000L);
    }

    public void close(long timeoutMillis) throws InterruptedException {
        if (this.v4Pool != null) {
            this.v4Pool.close(timeoutMillis);
        }
        if (this.v6Pool != null) {
            this.v6Pool.close(timeoutMillis);
        }
    }
}

