/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region.service;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.lionsoul.ip2region.service.Config;
import org.lionsoul.ip2region.xdb.Searcher;

public class SearcherPool {
    public final Config config;
    private final Queue<Searcher> pool;
    private final ReentrantLock lock;
    private final Condition emptyCondition;
    private final Condition fullCondition;
    private int loanCount;

    public static final SearcherPool create(Config config) throws IOException {
        return new SearcherPool(config).init();
    }

    public static final SearcherPool create(Config config, boolean fair) throws IOException {
        return new SearcherPool(config, fair).init();
    }

    protected SearcherPool(Config config) throws IOException {
        this(config, false);
    }

    protected SearcherPool(Config config, boolean fair) {
        assert (config.searchers > 0);
        this.config = config;
        this.pool = new LinkedList<Searcher>();
        this.lock = new ReentrantLock(fair);
        this.emptyCondition = this.lock.newCondition();
        this.fullCondition = this.lock.newCondition();
        this.loanCount = 0;
    }

    protected SearcherPool init() throws IOException {
        for (int i = this.pool.size(); i < this.config.searchers; ++i) {
            Searcher searcher = new Searcher(this.config.ipVersion, this.config.xdbPath, this.config.vIndex, this.config.cBuffer);
            this.pool.add(searcher);
        }
        return this;
    }

    public int getLoanCount() {
        this.lock.lock();
        int lc = this.loanCount;
        this.lock.unlock();
        return lc;
    }

    public Searcher borrowSearcher() throws InterruptedException {
        this.lock.lock();
        try {
            while (this.pool.isEmpty()) {
                this.emptyCondition.await();
            }
            ++this.loanCount;
            Searcher searcher = this.pool.poll();
            return searcher;
        }
        finally {
            this.lock.unlock();
        }
    }

    public void returnSearcher(Searcher searcher) {
        this.lock.lock();
        try {
            this.pool.add(searcher);
            --this.loanCount;
            this.emptyCondition.signal();
            if (this.loanCount == 0) {
                this.fullCondition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void close() throws InterruptedException {
        this.close(10000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(long timeoutMillis) throws InterruptedException {
        this.lock.lock();
        try {
            while (this.loanCount > 0) {
                this.fullCondition.wait(timeoutMillis);
            }
            Iterator it = this.pool.iterator();
            while (it.hasNext()) {
                Searcher searcher = (Searcher)it.next();
                try {
                    searcher.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                it.remove();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

