/*
 * Decompiled with CFR 0.152.
 */
package org.lionsoul.ip2region.xdb;

import org.lionsoul.ip2region.xdb.LittleEndian;

public class Header {
    public final int version;
    public final int indexPolicy;
    public final long createdAt;
    public final long startIndexPtr;
    public final long endIndexPtr;
    public final int ipVersion;
    public final int runtimePtrBytes;
    public final byte[] buffer;

    public Header(byte[] buff) {
        assert (buff.length >= 16);
        this.version = LittleEndian.getUint16(buff, 0);
        this.indexPolicy = LittleEndian.getUint16(buff, 2);
        this.createdAt = LittleEndian.getUint32(buff, 4);
        this.startIndexPtr = LittleEndian.getUint32(buff, 8);
        this.endIndexPtr = LittleEndian.getUint32(buff, 12);
        this.ipVersion = LittleEndian.getUint16(buff, 16);
        this.runtimePtrBytes = LittleEndian.getUint16(buff, 18);
        this.buffer = buff;
    }

    public String toString() {
        return "{Version: " + this.version + ',' + "IndexPolicy: " + this.indexPolicy + ',' + "CreatedAt: " + this.createdAt + ',' + "StartIndexPtr: " + this.startIndexPtr + ',' + "EndIndexPtr: " + this.endIndexPtr + ',' + "IPVersion: " + this.ipVersion + ',' + "RuntimePtrBytes: " + this.runtimePtrBytes + '}';
    }
}

