/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.codec;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.smartboot.http.common.codec.h2.codec.Http2Frame;

public class GoAwayFrame
extends Http2Frame {
    private static final int STATE_DEFAULT = 0;
    private static final int STATE_DEBUG_DATA = 1;
    private int state = 0;
    private int lastStream;
    private int errorCode;
    private byte[] debugData;

    public GoAwayFrame(int streamId, int flags, int remaining) {
        super(streamId, flags, remaining);
    }

    @Override
    public boolean decode(ByteBuffer buffer) {
        if (this.finishDecode()) {
            return true;
        }
        switch (this.state) {
            case 0: {
                if (buffer.remaining() < 8) {
                    return false;
                }
                this.lastStream = buffer.getInt();
                this.errorCode = buffer.getInt();
                this.remaining -= 8;
                this.state = 1;
            }
            case 1: {
                if (this.remaining > 0) {
                    if (buffer.remaining() < this.remaining) {
                        return false;
                    }
                    this.debugData = new byte[this.remaining];
                    buffer.get(this.debugData);
                } else {
                    this.debugData = new byte[0];
                }
                this.remaining = 0;
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.checkEndRemaining();
        return true;
    }

    @Override
    public int type() {
        return 7;
    }

    public String toString() {
        return super.toString() + " Debugdata: " + new String(this.debugData, StandardCharsets.UTF_8);
    }

    public int getLastStream() {
        return this.lastStream;
    }

    public byte[] getDebugData() {
        return (byte[])this.debugData.clone();
    }
}

