/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.common.codec.h2.codec;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.smartboot.http.common.HeaderValue;

public class HpackDecoder {
    private static final int STATIC_TABLE_LENGTH = 61;
    private static final Map<Integer, HeaderValue> STATIC_TABLE = HpackDecoder.createStaticTable();
    private static final HuffmanDecoder HUFFMAN_DECODER = new HuffmanDecoder();
    private final List<HeaderValue> dynamicTable = new ArrayList<HeaderValue>();
    private int dynamicTableSize = 0;
    private int maxDynamicTableSize;

    public HpackDecoder(int maxDynamicTableSize) {
        this.maxDynamicTableSize = maxDynamicTableSize;
    }

    public List<HeaderValue> decode(ByteBuffer headerBlock) throws HpackException {
        ArrayList<HeaderValue> headers = new ArrayList<HeaderValue>();
        while (headerBlock.hasRemaining()) {
            String value;
            String name;
            int index;
            int b = headerBlock.get() & 0xFF;
            if ((b & 0x80) != 0) {
                index = this.decodeInteger(headerBlock, 7);
                headers.add(this.getIndexedHeader(index));
                continue;
            }
            if ((b & 0x40) != 0) {
                index = this.decodeInteger(headerBlock, 6);
                name = this.getHeaderFieldName(index, headerBlock);
                value = this.decodeString(headerBlock);
                HeaderValue header = new HeaderValue(name, value);
                headers.add(header);
                this.addToDynamicTable(header);
                continue;
            }
            if ((b & 0x20) != 0) {
                int newMaxDynamicTableSize = this.decodeInteger(headerBlock, 5);
                this.setMaxDynamicTableSize(newMaxDynamicTableSize);
                continue;
            }
            index = this.decodeInteger(headerBlock, 4);
            name = this.getHeaderFieldName(index, headerBlock);
            value = this.decodeString(headerBlock);
            headers.add(new HeaderValue(name, value));
        }
        return headers;
    }

    private HeaderValue getIndexedHeader(int index) throws HpackException {
        if (index <= 0 || index > 61 + this.dynamicTable.size()) {
            throw new HpackException("Invalid header index: " + index);
        }
        if (index <= 61) {
            return STATIC_TABLE.get(index);
        }
        return this.dynamicTable.get(index - 61 - 1);
    }

    private String getHeaderFieldName(int index, ByteBuffer headerBlock) throws HpackException {
        if (index == 0) {
            return this.decodeString(headerBlock);
        }
        return this.getIndexedHeader(index).getName();
    }

    private void addToDynamicTable(HeaderValue header) {
        int headerSize = header.getName().length() + header.getValue().length() + 32;
        while (this.dynamicTableSize + headerSize > this.maxDynamicTableSize && !this.dynamicTable.isEmpty()) {
            HeaderValue removed = this.dynamicTable.remove(this.dynamicTable.size() - 1);
            this.dynamicTableSize -= removed.getName().length() + removed.getValue().length() + 32;
        }
        if (headerSize <= this.maxDynamicTableSize) {
            this.dynamicTable.add(0, header);
            this.dynamicTableSize += headerSize;
        }
    }

    private void setMaxDynamicTableSize(int newMaxDynamicTableSize) {
        this.maxDynamicTableSize = newMaxDynamicTableSize;
        while (this.dynamicTableSize > this.maxDynamicTableSize && !this.dynamicTable.isEmpty()) {
            HeaderValue removed = this.dynamicTable.remove(this.dynamicTable.size() - 1);
            this.dynamicTableSize -= removed.getName().length() + removed.getValue().length() + 32;
        }
    }

    private int decodeInteger(ByteBuffer buf, int n) throws HpackException {
        int b;
        int max = (1 << n) - 1;
        int value = buf.get() & max;
        if (value < max) {
            return value;
        }
        int m = 0;
        do {
            if (!buf.hasRemaining()) {
                throw new HpackException("Incomplete integer encoding");
            }
            b = buf.get() & 0xFF;
            value += (b & 0x7F) << m;
            if ((m += 7) <= 32) continue;
            throw new HpackException("Integer encoding too large");
        } while ((b & 0x80) == 128);
        return value;
    }

    private String decodeString(ByteBuffer buf) throws HpackException {
        if (!buf.hasRemaining()) {
            throw new HpackException("Empty string encoding");
        }
        int h = buf.get() & 0xFF;
        int length = this.decodeInteger(buf, 7);
        if (buf.remaining() < length) {
            throw new HpackException("Incomplete string encoding");
        }
        byte[] array = new byte[length];
        buf.get(array);
        if ((h & 0x80) == 128) {
            return HUFFMAN_DECODER.decode(array);
        }
        return new String(array, StandardCharsets.UTF_8);
    }

    private static Map<Integer, HeaderValue> createStaticTable() {
        HashMap<Integer, HeaderValue> table = new HashMap<Integer, HeaderValue>();
        table.put(1, new HeaderValue(":authority", ""));
        table.put(2, new HeaderValue(":method", "GET"));
        table.put(3, new HeaderValue(":method", "POST"));
        table.put(4, new HeaderValue(":path", "/"));
        table.put(5, new HeaderValue(":path", "/index.html"));
        table.put(6, new HeaderValue(":scheme", "http"));
        table.put(7, new HeaderValue(":scheme", "https"));
        table.put(8, new HeaderValue(":status", "200"));
        table.put(9, new HeaderValue(":status", "204"));
        table.put(10, new HeaderValue(":status", "206"));
        table.put(11, new HeaderValue(":status", "304"));
        table.put(12, new HeaderValue(":status", "400"));
        table.put(13, new HeaderValue(":status", "404"));
        table.put(14, new HeaderValue(":status", "500"));
        table.put(15, new HeaderValue("accept-charset", ""));
        table.put(16, new HeaderValue("accept-encoding", "gzip, deflate"));
        table.put(17, new HeaderValue("accept-language", ""));
        table.put(18, new HeaderValue("accept-ranges", ""));
        table.put(19, new HeaderValue("accept", ""));
        table.put(20, new HeaderValue("access-control-allow-origin", ""));
        table.put(21, new HeaderValue("age", ""));
        table.put(22, new HeaderValue("allow", ""));
        table.put(23, new HeaderValue("authorization", ""));
        table.put(24, new HeaderValue("cache-control", ""));
        table.put(25, new HeaderValue("content-disposition", ""));
        table.put(26, new HeaderValue("content-encoding", ""));
        table.put(27, new HeaderValue("content-language", ""));
        table.put(28, new HeaderValue("content-length", ""));
        table.put(29, new HeaderValue("content-location", ""));
        table.put(30, new HeaderValue("content-range", ""));
        table.put(31, new HeaderValue("content-type", ""));
        table.put(32, new HeaderValue("cookie", ""));
        table.put(33, new HeaderValue("date", ""));
        table.put(34, new HeaderValue("etag", ""));
        table.put(35, new HeaderValue("expect", ""));
        table.put(36, new HeaderValue("expires", ""));
        table.put(37, new HeaderValue("from", ""));
        table.put(38, new HeaderValue("host", ""));
        table.put(39, new HeaderValue("if-match", ""));
        table.put(40, new HeaderValue("if-modified-since", ""));
        table.put(41, new HeaderValue("if-none-match", ""));
        table.put(42, new HeaderValue("if-range", ""));
        table.put(43, new HeaderValue("if-unmodified-since", ""));
        table.put(44, new HeaderValue("last-modified", ""));
        table.put(45, new HeaderValue("link", ""));
        table.put(46, new HeaderValue("location", ""));
        table.put(47, new HeaderValue("max-forwards", ""));
        table.put(48, new HeaderValue("proxy-authenticate", ""));
        table.put(49, new HeaderValue("proxy-authorization", ""));
        table.put(50, new HeaderValue("range", ""));
        table.put(51, new HeaderValue("referer", ""));
        table.put(52, new HeaderValue("refresh", ""));
        table.put(53, new HeaderValue("retry-after", ""));
        table.put(54, new HeaderValue("server", ""));
        table.put(55, new HeaderValue("set-cookie", ""));
        table.put(56, new HeaderValue("strict-transport-security", ""));
        table.put(57, new HeaderValue("transfer-encoding", ""));
        table.put(58, new HeaderValue("user-agent", ""));
        table.put(59, new HeaderValue("vary", ""));
        table.put(60, new HeaderValue("via", ""));
        table.put(61, new HeaderValue("www-authenticate", ""));
        return table;
    }

    private static class HuffmanDecoder {
        private static final int[] CODES = new int[]{8184, 8388568, 0xFFFFFE2, 0xFFFFFE3, 0xFFFFFE4, 0xFFFFFE5, 0xFFFFFE6, 0xFFFFFE7, 0xFFFFFE8, 0xFFFFEA, 0x3FFFFFFC, 0xFFFFFE9, 0xFFFFFEA, 0x3FFFFFFD, 0xFFFFFEB, 0xFFFFFEC, 0xFFFFFED, 0xFFFFFEE, 0xFFFFFEF, 0xFFFFFF0, 0xFFFFFF1, 0xFFFFFF2, 0x3FFFFFFE, 0xFFFFFF3, 0xFFFFFF4, 0xFFFFFF5, 0xFFFFFF6, 0xFFFFFF7, 0xFFFFFF8, 0xFFFFFF9, 0xFFFFFFA, 0xFFFFFFB, 20, 1016, 1017, 4090, 8185, 21, 248, 2042, 1018, 1019, 249, 2043, 250, 22, 23, 24, 0, 1, 2, 25, 26, 27, 28, 29, 30, 31, 92, 251, 32764, 32, 4091, 1020, 8186, 33, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 252, 115, 253, 8187, 524272, 8188, 16380, 34, 32765, 3, 35, 4, 36, 5, 37, 38, 39, 6, 116, 117, 40, 41, 42, 7, 43, 118, 44, 8, 9, 45, 119, 120, 121, 122, 123, 32766, 2044, 16381, 8189, 0xFFFFFFC, 1048550, 4194258, 1048551, 1048552, 0x3FFFD3, 4194260, 4194261, 8388569, 4194262, 8388570, 8388571, 8388572, 0x7FFFDD, 8388574, 0xFFFFEB, 0x7FFFDF, 0xFFFFEC, 0xFFFFED, 4194263, 8388576, 0xFFFFEE, 8388577, 8388578, 8388579, 8388580, 2097116, 4194264, 8388581, 4194265, 8388582, 0x7FFFE7, 0xFFFFEF, 4194266, 0x1FFFDD, 1048553, 4194267, 4194268, 8388584, 8388585, 2097118, 8388586, 0x3FFFDD, 4194270, 0xFFFFF0, 0x1FFFDF, 0x3FFFDF, 8388587, 8388588, 2097120, 0x1FFFE1, 4194272, 2097122, 8388589, 4194273, 0x7FFFEE, 0x7FFFEF, 1048554, 4194274, 0x3FFFE3, 4194276, 0x7FFFF0, 4194277, 4194278, 0x7FFFF1, 67108832, 67108833, 1048555, 524273, 4194279, 0x7FFFF2, 4194280, 33554412, 67108834, 0x3FFFFE3, 67108836, 134217694, 0x7FFFFDF, 67108837, 0xFFFFF1, 33554413, 524274, 2097123, 67108838, 134217696, 134217697, 67108839, 134217698, 0xFFFFF2, 2097124, 2097125, 67108840, 67108841, 0xFFFFFFD, 134217699, 134217700, 134217701, 1048556, 0xFFFFF3, 1048557, 2097126, 4194281, 2097127, 2097128, 0x7FFFF3, 4194282, 4194283, 0x1FFFFEE, 0x1FFFFEF, 0xFFFFF4, 0xFFFFF5, 67108842, 0x7FFFF4, 67108843, 134217702, 67108844, 67108845, 0x7FFFFE7, 134217704, 134217705, 134217706, 134217707, 0xFFFFFFE, 134217708, 134217709, 0x7FFFFEE, 0x7FFFFEF, 0x7FFFFF0, 0x3FFFFEE};
        private static final byte[] LENGTHS = new byte[]{13, 23, 28, 28, 28, 28, 28, 28, 28, 24, 30, 28, 28, 30, 28, 28, 28, 28, 28, 28, 28, 28, 30, 28, 28, 28, 28, 28, 28, 28, 28, 28, 6, 10, 10, 12, 13, 6, 8, 11, 10, 10, 8, 11, 8, 6, 6, 6, 5, 5, 5, 6, 6, 6, 6, 6, 6, 6, 7, 8, 15, 6, 12, 10, 13, 6, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 8, 7, 8, 13, 19, 13, 14, 6, 15, 5, 6, 5, 6, 5, 6, 6, 6, 5, 7, 7, 6, 6, 6, 5, 6, 7, 6, 5, 5, 6, 7, 7, 7, 7, 7, 15, 11, 14, 13, 28, 20, 22, 20, 20, 22, 22, 22, 23, 22, 23, 23, 23, 23, 23, 24, 23, 24, 24, 22, 23, 24, 23, 23, 23, 23, 21, 22, 23, 22, 23, 23, 24, 22, 21, 20, 22, 22, 23, 23, 21, 23, 22, 22, 24, 21, 22, 23, 23, 21, 21, 22, 21, 23, 22, 23, 23, 20, 22, 22, 22, 23, 22, 22, 23, 26, 26, 20, 19, 22, 23, 22, 25, 26, 26, 26, 27, 27, 26, 24, 25, 19, 21, 26, 27, 27, 26, 27, 24, 21, 21, 26, 26, 28, 27, 27, 27, 20, 24, 20, 21, 22, 21, 21, 23, 22, 22, 25, 25, 24, 24, 26, 23, 26, 27, 26, 26, 27, 27, 27, 27, 27, 28, 27, 27, 27, 27, 27, 26};

        private HuffmanDecoder() {
        }

        public String decode(byte[] buf) throws HpackException {
            int found;
            StringBuilder result = new StringBuilder();
            long current = 0L;
            int bits = 0;
            for (byte b : buf) {
                current = current << 8 | (long)(b & 0xFF);
                bits += 8;
                while (bits >= 8) {
                    int found2 = this.findCodeIndex((int)(current >>> bits - 8));
                    if (found2 == -1) {
                        throw new HpackException("Invalid Huffman code");
                    }
                    if (found2 == 256) {
                        return result.toString();
                    }
                    result.append((char)found2);
                    bits -= LENGTHS[found2];
                }
            }
            if (bits > 0 && (found = this.findCodeIndex((int)(current << 8 - bits))) != 256 && found != -1) {
                throw new HpackException("Invalid Huffman code");
            }
            return result.toString();
        }

        private int findCodeIndex(int code) {
            for (int i = 0; i < CODES.length; ++i) {
                if (code >>> 8 - LENGTHS[i] != CODES[i] >>> 32 - LENGTHS[i]) continue;
                return i;
            }
            return -1;
        }
    }

    public static class HpackException
    extends Exception {
        public HpackException(String message) {
            super(message);
        }
    }

    public static class Header {
        public final String name;
        public final String value;

        public Header(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String toString() {
            return this.name + ": " + this.value;
        }
    }
}

