/*
 * Decompiled with CFR 0.152.
 */
package org.smartboot.http.server.waf;

import org.smartboot.http.common.enums.HttpStatus;
import org.smartboot.http.common.utils.CollectionUtils;
import org.smartboot.http.server.HttpServerConfiguration;
import org.smartboot.http.server.impl.Request;
import org.smartboot.http.server.waf.WafConfiguration;
import org.smartboot.http.server.waf.WafException;

public class WAF {
    public static void methodCheck(HttpServerConfiguration configuration, Request request) {
        WafConfiguration wafConfiguration = configuration.getWafConfiguration();
        if (!wafConfiguration.getAllowMethods().isEmpty() && !wafConfiguration.getAllowMethods().contains(request.getMethod())) {
            throw new WafException(HttpStatus.METHOD_NOT_ALLOWED, "Mysterious Power from the East Is Protecting This Area.");
        }
        if (!wafConfiguration.getDenyMethods().isEmpty() && wafConfiguration.getDenyMethods().contains(request.getMethod())) {
            throw new WafException(HttpStatus.METHOD_NOT_ALLOWED, "Mysterious Power from the East Is Protecting This Area.");
        }
    }

    public static void checkUri(HttpServerConfiguration configuration, Request request) {
        WafConfiguration wafConfiguration = configuration.getWafConfiguration();
        if (request.getUri().equals("/") || CollectionUtils.isEmpty(wafConfiguration.getAllowUriPrefixes()) && CollectionUtils.isEmpty(wafConfiguration.getAllowUriSuffixes())) {
            return;
        }
        for (String prefix : wafConfiguration.getAllowUriPrefixes()) {
            if (!request.getUri().startsWith(prefix)) continue;
            return;
        }
        for (String suffix : wafConfiguration.getAllowUriSuffixes()) {
            if (!request.getUri().endsWith(suffix)) continue;
            return;
        }
        throw new WafException(HttpStatus.BAD_REQUEST, "Mysterious Power from the East Is Protecting This Area.");
    }
}

