/*
 * Decompiled with CFR 0.152.
 */
package org.noear.solon.net.socketd.listener;

import java.io.IOException;
import org.noear.socketd.transport.core.Listener;
import org.noear.socketd.transport.core.Session;
import org.noear.socketd.transport.core.listener.EventListener;
import org.noear.socketd.transport.core.listener.PathListener;
import org.noear.socketd.transport.core.listener.RouteSelector;
import org.noear.solon.net.socketd.listener.ExpressListener;
import org.noear.solon.net.socketd.listener.RouteSelectorExpress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PathListenerPlus
extends PathListener {
    static final Logger log = LoggerFactory.getLogger(PathListenerPlus.class);
    private final boolean autoClose;

    public PathListenerPlus() {
        this(false);
    }

    public PathListenerPlus(boolean autoClose) {
        super((RouteSelector)new RouteSelectorExpress());
        this.autoClose = autoClose;
    }

    public void onOpen(Session session) throws IOException {
        Listener l1 = (Listener)this.pathRouteSelector.select(session.path());
        if (l1 != null) {
            l1.onOpen(session);
        } else if (this.autoClose) {
            session.close();
            log.warn("Route failed. The connection will close. path={}", (Object)session.path());
        }
    }

    public PathListener doOf(String path, Listener listener) {
        this.pathRouteSelector.put(path, (Object)new ExpressListener(path, listener));
        return this;
    }

    public EventListener of(String path) {
        EventListener listener = new EventListener();
        this.pathRouteSelector.put(path, (Object)new ExpressListener(path, (Listener)listener));
        return listener;
    }
}

