/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.continuations;

import com.uwyn.rife.continuations.ContinuationConfig;
import com.uwyn.rife.continuations.ContinuationDebug;
import com.uwyn.rife.continuations.TypesClassVisitor;
import com.uwyn.rife.continuations.TypesContext;
import com.uwyn.rife.continuations.asm.AnnotationVisitor;
import com.uwyn.rife.continuations.asm.Attribute;
import com.uwyn.rife.continuations.asm.Label;
import com.uwyn.rife.continuations.asm.MethodVisitor;
import com.uwyn.rife.continuations.asm.Opcodes;
import com.uwyn.rife.continuations.util.StringUtils;
import java.util.Stack;
import java.util.logging.Level;

class ResumableMethodAdapter
implements MethodVisitor,
Opcodes {
    private static final String CONTINUATION_DEBUG = "com/uwyn/rife/continuations/ContinuationDebug";
    private static final String CONTINUATION_CONTEXT = "com/uwyn/rife/continuations/ContinuationContext";
    private static final String CONTINUATION_STACK = "com/uwyn/rife/continuations/ContinuationStack";
    private static final String PAUSE_EXCEPTION = "com/uwyn/rife/continuations/exceptions/PauseException";
    private static final String CALL_EXCEPTION = "com/uwyn/rife/continuations/exceptions/CallException";
    private TypesClassVisitor mTypes = null;
    private MethodVisitor mMethodVisitor = null;
    private String mClassName = null;
    private String mClassNameInternal = null;
    private boolean mVisit = false;
    private boolean mAdapt = false;
    private int mContextIndex = -1;
    private int mCallNameIndex = -1;
    private int mTempIndex = -1;
    private Label mDefaultLabel = null;
    private Label mRethrowLabel = null;
    private boolean mUseRethrowLabel = false;
    private Label[] mLabels = null;
    private int mLabelIndex = 0;
    private int mMaxLocalIndex = 0;
    private TypesContext mLabelContext = null;
    private boolean mDisableCodeguideBackInTime = false;
    private boolean mDisabledCodeguideBackInTime = false;

    private void debugMessage(String message) {
    }

    ResumableMethodAdapter(TypesClassVisitor types, MethodVisitor methodVisitor, String className, boolean adapt, int maxLocals, int pauseCount) {
        this.mTypes = types;
        this.mMethodVisitor = methodVisitor;
        this.mClassName = className;
        if (className != null) {
            this.mClassNameInternal = this.mClassName.replace('.', '/');
        }
        this.mVisit = this.mMethodVisitor != null;
        this.mAdapt = adapt;
        this.mContextIndex = maxLocals;
        this.mCallNameIndex = this.mContextIndex + 1;
        this.mTempIndex = this.mCallNameIndex + 1;
        if (this.mAdapt) {
            if (pauseCount > 0) {
                this.mDefaultLabel = new Label();
                this.mRethrowLabel = new Label();
                this.mLabels = new Label[pauseCount];
                for (int i = 0; i < pauseCount; ++i) {
                    this.mLabels[i] = new Label();
                }
            }
            this.debugMessage("CONT: context initializing");
            this.mMethodVisitor.visitMethodInsn(184, CONTINUATION_CONTEXT, "getContext", "()Lcom/uwyn/rife/continuations/ContinuationContext;");
            this.mMethodVisitor.visitVarInsn(58, this.mContextIndex);
            this.debugMessage("CONT: context set up");
            if (pauseCount > 0) {
                this.debugMessage("CONT: context obtain label");
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getLabel", "()I");
                this.debugMessage("CONT: evaluate tableswitch");
                this.mMethodVisitor.visitTableSwitchInsn(0, pauseCount - 1, this.mDefaultLabel, this.mLabels);
                this.mMethodVisitor.visitLabel(this.mDefaultLabel);
                this.debugMessage("CONT: begin of code");
            }
        }
    }

    private void addIntegerConst(int value) {
        switch (value) {
            case 0: {
                this.mMethodVisitor.visitInsn(3);
                break;
            }
            case 1: {
                this.mMethodVisitor.visitInsn(4);
                break;
            }
            case 2: {
                this.mMethodVisitor.visitInsn(5);
                break;
            }
            case 3: {
                this.mMethodVisitor.visitInsn(6);
                break;
            }
            case 4: {
                this.mMethodVisitor.visitInsn(7);
                break;
            }
            case 5: {
                this.mMethodVisitor.visitInsn(8);
                break;
            }
            default: {
                this.mMethodVisitor.visitLdcInsn(new Integer(value));
            }
        }
    }

    public void visitVarInsn(int opcode, int var) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitVarInsn            (" + ContinuationDebug.OPCODES[opcode] + ", " + var + ")");
        }
        if (this.mAdapt) {
            this.mMethodVisitor.visitVarInsn(opcode, var);
            if (this.mLabelContext != null && 1 == this.mLabelContext.getSort() && 58 == opcode) {
                Label label = new Label();
                this.mMethodVisitor.visitVarInsn(25, var);
                this.mMethodVisitor.visitTypeInsn(193, PAUSE_EXCEPTION);
                this.mMethodVisitor.visitJumpInsn(153, label);
                this.mMethodVisitor.visitVarInsn(25, var);
                this.mMethodVisitor.visitJumpInsn(167, this.mRethrowLabel);
                this.mMethodVisitor.visitLabel(label);
                this.mUseRethrowLabel = true;
            }
            if (opcode == 54 || opcode == 55 || opcode == 56 || opcode == 57 || opcode == 58) {
                if (var > this.mMaxLocalIndex) {
                    this.mMaxLocalIndex = var;
                }
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getLocalVars", "()Lcom/uwyn/rife/continuations/ContinuationStack;");
                this.addIntegerConst(var);
                switch (opcode) {
                    case 54: {
                        this.mMethodVisitor.visitVarInsn(21, var);
                        this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "storeInt", "(II)V");
                        break;
                    }
                    case 55: {
                        this.mMethodVisitor.visitVarInsn(22, var);
                        this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "storeLong", "(IJ)V");
                        break;
                    }
                    case 56: {
                        this.mMethodVisitor.visitVarInsn(23, var);
                        this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "storeFloat", "(IF)V");
                        break;
                    }
                    case 57: {
                        this.mMethodVisitor.visitVarInsn(24, var);
                        this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "storeDouble", "(ID)V");
                        break;
                    }
                    case 58: {
                        this.mMethodVisitor.visitVarInsn(25, var);
                        this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "storeReference", "(ILjava/lang/Object;)V");
                    }
                }
            }
            if (this.mLabelContext != null && 1 == this.mLabelContext.getSort() && 58 == opcode) {
                this.restoreLocalStack(this.mLabelContext);
                this.mLabelContext.setSort(0);
            }
        } else if (this.mVisit) {
            this.mMethodVisitor.visitVarInsn(opcode, var);
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitMethodInsn         (" + ContinuationDebug.OPCODES[opcode] + ", \"" + owner + "\", \"" + name + "\", \"" + desc + "\")");
        }
        if (this.mAdapt) {
            String owner_classname = owner.replace('/', '.');
            if (ContinuationConfig.getInstance().getContinuableClassOrInterfaceName().equals(owner_classname) || this.mClassName.equals(owner_classname)) {
                if ("pause".equals(name)) {
                    this.debugMessage("CONT: pause : undoing method call");
                    this.mMethodVisitor.visitVarInsn(58, this.mTempIndex);
                    this.mMethodVisitor.visitInsn(87);
                    TypesContext context = this.mTypes.nextPauseContext();
                    Stack stack = context.getStackClone();
                    this.debugMessage("CONT: pause : saving operand stack");
                    this.saveOperandStack(stack);
                    this.debugMessage("CONT: pause : storing resume label");
                    this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                    this.addIntegerConst(this.mLabelIndex);
                    this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "setLabel", "(I)V");
                    this.debugMessage("CONT: pause : throwing pause exception");
                    this.mMethodVisitor.visitTypeInsn(187, PAUSE_EXCEPTION);
                    this.mMethodVisitor.visitInsn(89);
                    this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                    this.mMethodVisitor.visitVarInsn(25, this.mTempIndex);
                    this.mMethodVisitor.visitMethodInsn(183, PAUSE_EXCEPTION, "<init>", "(Lcom/uwyn/rife/continuations/ContinuationContext;Ljava/lang/Object;)V");
                    this.mMethodVisitor.visitInsn(191);
                    this.mMethodVisitor.visitLabel(this.mLabels[this.mLabelIndex]);
                    this.debugMessage("CONT: pause : resumed execution");
                    this.debugMessage("CONT: pause : restoring local stack");
                    this.restoreLocalStack(context);
                    this.debugMessage("CONT: pause : restoring operand stack");
                    this.restoreOperandStack(stack);
                    ++this.mLabelIndex;
                    return;
                }
                if ("call".equals(name) && "(Ljava/lang/String;)Ljava/lang/Object;".equals(desc)) {
                    this.debugMessage("CONT: call : storing exit name");
                    this.mMethodVisitor.visitVarInsn(58, this.mCallNameIndex);
                    this.debugMessage("CONT: call : undoing method call");
                    this.mMethodVisitor.visitInsn(87);
                    TypesContext context = this.mTypes.nextPauseContext();
                    Stack stack = context.getStackClone();
                    stack.pop();
                    this.debugMessage("CONT: call : saving operand stack");
                    this.saveOperandStack(stack);
                    this.debugMessage("CONT: call : storing resume label");
                    this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                    this.addIntegerConst(this.mLabelIndex);
                    this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "setLabel", "(I)V");
                    this.debugMessage("CONT: call : throwing call exception");
                    this.mMethodVisitor.visitTypeInsn(187, CALL_EXCEPTION);
                    this.mMethodVisitor.visitInsn(89);
                    this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                    this.mMethodVisitor.visitVarInsn(25, this.mCallNameIndex);
                    this.mMethodVisitor.visitMethodInsn(183, CALL_EXCEPTION, "<init>", "(Lcom/uwyn/rife/continuations/ContinuationContext;Ljava/lang/String;)V");
                    this.mMethodVisitor.visitInsn(191);
                    this.mMethodVisitor.visitLabel(this.mLabels[this.mLabelIndex]);
                    this.debugMessage("CONT: call : resumed execution");
                    this.debugMessage("CONT: call : restoring local stack");
                    this.restoreLocalStack(context);
                    this.debugMessage("CONT: call : restoring operand stack");
                    this.restoreOperandStack(stack);
                    this.debugMessage("CONT: call : retrieving call answer");
                    this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                    this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getCallAnswer", "()Ljava/lang/Object;");
                    ++this.mLabelIndex;
                    return;
                }
            }
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitMethodInsn(opcode, owner, name, desc);
        }
    }

    private void restoreLocalStack(TypesContext context) {
        int i;
        block9: for (i = 1; i <= this.mMaxLocalIndex; ++i) {
            if (!context.hasVar(i)) continue;
            switch (context.getVarType(i)) {
                case 5: {
                    this.debugMessage("CONT: restore local : " + i + ", int");
                    this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                    this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getLocalVars", "()Lcom/uwyn/rife/continuations/ContinuationStack;");
                    this.addIntegerConst(i);
                    this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "getInt", "(I)I");
                    this.mMethodVisitor.visitVarInsn(54, i);
                    continue block9;
                }
                case 6: {
                    this.debugMessage("CONT: restore local : " + i + ", float");
                    this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                    this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getLocalVars", "()Lcom/uwyn/rife/continuations/ContinuationStack;");
                    this.addIntegerConst(i);
                    this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "getFloat", "(I)F");
                    this.mMethodVisitor.visitVarInsn(56, i);
                    continue block9;
                }
                case 10: {
                    this.debugMessage("CONT: restore local : " + i + ", " + context.getVar(i) + "");
                    String type = context.getVar(i);
                    if ("NULL" == type) {
                        this.mMethodVisitor.visitInsn(1);
                        this.mMethodVisitor.visitVarInsn(58, i);
                        continue block9;
                    }
                    this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                    this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getLocalVars", "()Lcom/uwyn/rife/continuations/ContinuationStack;");
                    this.addIntegerConst(i);
                    this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "getReference", "(I)Ljava/lang/Object;");
                    this.mMethodVisitor.visitTypeInsn(192, type);
                    this.mMethodVisitor.visitVarInsn(58, i);
                }
            }
        }
        block10: for (i = 1; i <= this.mMaxLocalIndex; ++i) {
            if (!context.hasVar(i)) continue;
            switch (context.getVarType(i)) {
                case 7: {
                    this.debugMessage("CONT: restore local : " + i + ", long");
                    this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                    this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getLocalVars", "()Lcom/uwyn/rife/continuations/ContinuationStack;");
                    this.addIntegerConst(i);
                    this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "getLong", "(I)J");
                    this.mMethodVisitor.visitVarInsn(55, i);
                    continue block10;
                }
                case 8: {
                    this.debugMessage("CONT: restore local : " + i + ", double");
                    this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                    this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getLocalVars", "()Lcom/uwyn/rife/continuations/ContinuationStack;");
                    this.addIntegerConst(i);
                    this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "getDouble", "(I)D");
                    this.mMethodVisitor.visitVarInsn(57, i);
                }
            }
        }
    }

    private void saveOperandStack(Stack stack) {
        String tupe = null;
        for (int i = stack.size() - 1; i >= 0; --i) {
            tupe = (String)stack.get(i);
            if (tupe.equals("1Z") || tupe.equals("1C") || tupe.equals("1B") || tupe.equals("1S") || tupe.equals("1I")) {
                this.mMethodVisitor.visitVarInsn(54, this.mTempIndex);
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getLocalStack", "()Lcom/uwyn/rife/continuations/ContinuationStack;");
                this.mMethodVisitor.visitVarInsn(21, this.mTempIndex);
                this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "pushInt", "(I)V");
                continue;
            }
            if (tupe.equals("1F")) {
                this.mMethodVisitor.visitVarInsn(56, this.mTempIndex);
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getLocalStack", "()Lcom/uwyn/rife/continuations/ContinuationStack;");
                this.mMethodVisitor.visitVarInsn(23, this.mTempIndex);
                this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "pushFloat", "(F)V");
                continue;
            }
            if (tupe.equals("2D")) {
                this.mMethodVisitor.visitVarInsn(57, this.mTempIndex);
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getLocalStack", "()Lcom/uwyn/rife/continuations/ContinuationStack;");
                this.mMethodVisitor.visitVarInsn(24, this.mTempIndex);
                this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "pushDouble", "(D)V");
                continue;
            }
            if (tupe.equals("2J")) {
                this.mMethodVisitor.visitVarInsn(55, this.mTempIndex);
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getLocalStack", "()Lcom/uwyn/rife/continuations/ContinuationStack;");
                this.mMethodVisitor.visitVarInsn(22, this.mTempIndex);
                this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "pushLong", "(J)V");
                continue;
            }
            if (tupe.equals("1A")) {
                throw new RuntimeException("Invalid local stack type");
            }
            this.mMethodVisitor.visitVarInsn(58, this.mTempIndex);
            this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
            this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getLocalStack", "()Lcom/uwyn/rife/continuations/ContinuationStack;");
            this.mMethodVisitor.visitVarInsn(25, this.mTempIndex);
            this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "pushReference", "(Ljava/lang/Object;)V");
        }
    }

    private void restoreOperandStack(Stack stack) {
        String type = null;
        for (int i = 0; i < stack.size(); ++i) {
            type = (String)stack.get(i);
            if (type.equals("1Z") || type.equals("1C") || type.equals("1B") || type.equals("1S") || type.equals("1I")) {
                this.debugMessage("CONT: restore operand : " + i + ", int");
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getLocalStack", "()Lcom/uwyn/rife/continuations/ContinuationStack;");
                this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "popInt", "()I");
                continue;
            }
            if (type.equals("1F")) {
                this.debugMessage("CONT: restore operand : " + i + ", float");
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getLocalStack", "()Lcom/uwyn/rife/continuations/ContinuationStack;");
                this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "popFloat", "()F");
                continue;
            }
            if (type.equals("2D")) {
                this.debugMessage("CONT: restore operand : " + i + ", double");
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getLocalStack", "()Lcom/uwyn/rife/continuations/ContinuationStack;");
                this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "popDouble", "()D");
                continue;
            }
            if (type.equals("2J")) {
                this.debugMessage("CONT: restore operand : " + i + ", long");
                this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
                this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getLocalStack", "()Lcom/uwyn/rife/continuations/ContinuationStack;");
                this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "popLong", "()J");
                continue;
            }
            if (type.equals("1A")) {
                throw new RuntimeException("Invalid local stack type");
            }
            this.debugMessage("CONT: restore operand : " + i + ", " + type);
            if ("NULL" == type) {
                this.mMethodVisitor.visitInsn(1);
                this.mMethodVisitor.visitVarInsn(58, i);
                continue;
            }
            this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
            this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getLocalStack", "()Lcom/uwyn/rife/continuations/ContinuationStack;");
            this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "popReference", "()Ljava/lang/Object;");
            this.mMethodVisitor.visitTypeInsn(192, type);
        }
    }

    public void visitTypeInsn(int opcode, String desc) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitTypeInsn           (" + ContinuationDebug.OPCODES[opcode] + ", \"" + desc + "\")");
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitTypeInsn(opcode, desc);
        }
    }

    public void visitLdcInsn(Object cst) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitLdcInsn            (" + cst + ")");
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitLdcInsn(cst);
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitMultiANewArrayInsn (\"" + desc + "\", " + dims + ")");
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitMultiANewArrayInsn(desc, dims);
        }
    }

    public void visitInsn(int opcode) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitInsn               (" + ContinuationDebug.OPCODES[opcode] + ")");
        }
        if (this.mAdapt && 177 == opcode) {
            this.debugMessage("CONT: context removal");
            this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
            this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "remove", "()V");
            this.mMethodVisitor.visitInsn(opcode);
            if (this.mUseRethrowLabel) {
                this.mMethodVisitor.visitLabel(this.mRethrowLabel);
                this.debugMessage("CONT: rethrowing exception");
                this.mMethodVisitor.visitInsn(191);
            }
        } else if (this.mVisit) {
            this.mMethodVisitor.visitInsn(opcode);
        }
    }

    public void visitIincInsn(int var, int increment) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitIincInsn           (" + var + ", " + increment + ")");
        }
        if (this.mAdapt) {
            this.mMethodVisitor.visitIincInsn(var, increment);
            if (var > this.mMaxLocalIndex) {
                this.mMaxLocalIndex = var;
            }
            this.mMethodVisitor.visitVarInsn(25, this.mContextIndex);
            this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_CONTEXT, "getLocalVars", "()Lcom/uwyn/rife/continuations/ContinuationStack;");
            this.addIntegerConst(var);
            this.addIntegerConst(increment);
            this.mMethodVisitor.visitMethodInsn(182, CONTINUATION_STACK, "incrementInt", "(II)V");
        } else if (this.mVisit) {
            this.mMethodVisitor.visitIincInsn(var, increment);
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitFieldInsn          (" + ContinuationDebug.OPCODES[opcode] + ", \"" + owner + "\", \"" + name + "\", \"" + desc + "\")");
        }
        if (this.mAdapt && !this.mDisabledCodeguideBackInTime && opcode == 178 && this.mClassNameInternal.equals(owner) && name.startsWith("debugEnabled$") && "Z".equals(desc)) {
            this.mDisableCodeguideBackInTime = true;
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitFieldInsn(opcode, owner, name, desc);
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitIntInsn            (" + ContinuationDebug.OPCODES[opcode] + ", " + operand + ")");
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitIntInsn(opcode, operand);
        }
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitTryCatchBlock      (" + start + ", " + end + ", " + handler + ", \"" + type + "\")");
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitTryCatchBlock(start, end, handler, type);
        }
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitLookupSwitchInsn   (" + dflt + ", " + (null == keys ? null : StringUtils.join(keys, ",")) + ", " + (null == labels ? null : StringUtils.join(labels, ",")) + ")");
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitLookupSwitchInsn(dflt, keys, labels);
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitJumpInsn           (" + ContinuationDebug.OPCODES[opcode] + ", " + label + ")");
        }
        if (this.mAdapt && this.mDisableCodeguideBackInTime && opcode == 153) {
            this.mMethodVisitor.visitInsn(87);
            this.mMethodVisitor.visitJumpInsn(167, label);
            this.mDisableCodeguideBackInTime = false;
            this.mDisabledCodeguideBackInTime = true;
        } else if (this.mVisit) {
            this.mMethodVisitor.visitJumpInsn(opcode, label);
        }
    }

    public void visitLabel(Label label) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitLabel              (" + label + ")");
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitLabel(label);
        }
        if (this.mAdapt) {
            this.mLabelContext = this.mTypes.nextLabelTypes();
        }
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitTableSwitchInsn    (" + min + ", " + max + ", " + dflt + ", " + (null == labels ? null : StringUtils.join(labels, ",")) + ")");
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitTableSwitchInsn(min, max, dflt, labels);
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitMaxs               (" + maxStack + ", " + maxLocals + ")");
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitMaxs(maxStack, maxLocals);
        }
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitLocalVariable      (\"" + name + "\", \"" + desc + ", \"" + signature + "\", " + start + ", " + end + ", " + index + ")");
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitLocalVariable(name, desc, signature, start, end, index);
        }
    }

    public void visitLineNumber(int line, Label start) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitLineNumber         (" + line + ", " + start + ")");
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitLineNumber(line, start);
        }
    }

    public void visitAttribute(Attribute attr) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitAttribute          (" + attr + ")");
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitAttribute(attr);
        }
    }

    public void visitCode() {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitCode               ()");
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitCode();
        }
    }

    public AnnotationVisitor visitAnnotationDefault() {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitAnnotationDefault  ()");
        }
        if (this.mVisit) {
            return this.mMethodVisitor.visitAnnotationDefault();
        }
        return null;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitAnnotation         (\"" + desc + "\", " + visible + ")");
        }
        if (this.mVisit) {
            return this.mMethodVisitor.visitAnnotation(desc, visible);
        }
        return null;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitAnnotation         (" + parameter + ", \"" + desc + "\", " + visible + ")");
        }
        if (this.mVisit) {
            return this.mMethodVisitor.visitParameterAnnotation(parameter, desc, visible);
        }
        return null;
    }

    public void visitEnd() {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitEnd                ()");
        }
        if (this.mVisit) {
            this.mMethodVisitor.visitEnd();
        }
    }
}

