/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.continuations;

import com.uwyn.rife.continuations.ContinuationConfig;
import com.uwyn.rife.continuations.ContinuationDebug;
import com.uwyn.rife.continuations.TypesClassVisitor;
import com.uwyn.rife.continuations.TypesContext;
import com.uwyn.rife.continuations.TypesInstruction;
import com.uwyn.rife.continuations.TypesNode;
import com.uwyn.rife.continuations.TypesSuccessor;
import com.uwyn.rife.continuations.asm.AnnotationVisitor;
import com.uwyn.rife.continuations.asm.Attribute;
import com.uwyn.rife.continuations.asm.Label;
import com.uwyn.rife.continuations.asm.MethodVisitor;
import com.uwyn.rife.continuations.asm.Opcodes;
import com.uwyn.rife.continuations.asm.Type;
import com.uwyn.rife.continuations.util.StringUtils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;

class TypesMethodVisitor
implements MethodVisitor,
Opcodes {
    private TypesClassVisitor mClassVisitor = null;
    private String mClassName = null;
    private String mClassNameInternal = null;
    private TypesNode mCurrentNode = null;
    private TypesNode mRootNode = null;
    private HashMap mLabelMapping = null;
    private TypesContext[] mPauseContexts = null;
    private TypesContext[] mLabelContexts = null;
    private int mPausecount = -1;
    private int mLabelcount = -1;

    TypesMethodVisitor(TypesClassVisitor classVisitor, String className) {
        this.mClassVisitor = classVisitor;
        this.mClassName = className;
        this.mClassNameInternal = this.mClassName.replace('.', '/');
        this.mLabelMapping = new HashMap();
        this.mRootNode = this.mCurrentNode = new TypesNode();
    }

    public void visitVarInsn(int opcode, int var) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitVarInsn            (" + ContinuationDebug.OPCODES[opcode] + ", " + var + ")");
        }
        if (this.mCurrentNode != null) {
            switch (opcode) {
                case 54: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(1, var, "1I"));
                    break;
                }
                case 56: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(1, var, "1F"));
                    break;
                }
                case 55: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(1, var, "2J"));
                    break;
                }
                case 57: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(1, var, "2D"));
                    break;
                }
                case 58: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(1, var, null));
                    break;
                }
                case 21: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(2, var, "1I"));
                    break;
                }
                case 23: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(2, var, "1F"));
                    break;
                }
                case 22: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(2, var, "2J"));
                    break;
                }
                case 24: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(2, var, "2D"));
                    break;
                }
                case 25: {
                    if (0 == var) {
                        this.mCurrentNode.addInstruction(new TypesInstruction(2, var, this.mClassNameInternal));
                        break;
                    }
                    this.mCurrentNode.addInstruction(new TypesInstruction(2, var, null));
                    break;
                }
                case 169: {
                    this.mCurrentNode = null;
                }
            }
        }
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitMethodInsn         (" + ContinuationDebug.OPCODES[opcode] + ", \"" + owner + "\", \"" + name + "\", \"" + desc + "\")");
        }
        if (this.mCurrentNode != null) {
            String owner_classname = owner.replace('/', '.');
            if ((ContinuationConfig.getInstance().getContinuableClassOrInterfaceName().equals(owner_classname) || this.mClassName.equals(owner_classname)) && ("pause".equals(name) || "call".equals(name) && "(Ljava/lang/String;)Ljava/lang/Object;".equals(desc))) {
                this.mCurrentNode.addInstruction(new TypesInstruction(4));
                this.mCurrentNode.addInstruction(new TypesInstruction(4));
                this.mCurrentNode.addInstruction(new TypesInstruction(15, ++this.mPausecount));
                return;
            }
            Type[] arguments = Type.getArgumentTypes(desc);
            for (int i = 0; i < arguments.length; ++i) {
                Type argument = arguments[i];
                this.mCurrentNode.addInstruction(new TypesInstruction(4));
            }
            if (184 != opcode) {
                this.mCurrentNode.addInstruction(new TypesInstruction(4));
            }
            if (!"<init>".equals(name) || 183 != opcode) {
                Type type = Type.getReturnType(desc);
                switch (type.getSort()) {
                    case 10: {
                        this.mCurrentNode.addInstruction(new TypesInstruction(6, type.getInternalName()));
                        break;
                    }
                    case 9: {
                        this.mCurrentNode.addInstruction(new TypesInstruction(6, type.getDescriptor()));
                        break;
                    }
                    case 1: {
                        this.mCurrentNode.addInstruction(new TypesInstruction(6, "1Z"));
                        break;
                    }
                    case 3: {
                        this.mCurrentNode.addInstruction(new TypesInstruction(6, "1B"));
                        break;
                    }
                    case 2: {
                        this.mCurrentNode.addInstruction(new TypesInstruction(6, "1C"));
                        break;
                    }
                    case 6: {
                        this.mCurrentNode.addInstruction(new TypesInstruction(6, "1F"));
                        break;
                    }
                    case 5: {
                        this.mCurrentNode.addInstruction(new TypesInstruction(6, "1I"));
                        break;
                    }
                    case 4: {
                        this.mCurrentNode.addInstruction(new TypesInstruction(6, "1S"));
                        break;
                    }
                    case 8: {
                        this.mCurrentNode.addInstruction(new TypesInstruction(6, "2D"));
                        break;
                    }
                    case 7: {
                        this.mCurrentNode.addInstruction(new TypesInstruction(6, "2J"));
                    }
                }
            }
        }
    }

    public void visitTypeInsn(int opcode, String desc) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitTypeInsn           (" + ContinuationDebug.OPCODES[opcode] + ", \"" + desc + "\")");
        }
        if (this.mCurrentNode != null) {
            switch (opcode) {
                case 187: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, desc));
                    break;
                }
                case 189: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    if (desc.startsWith("[")) {
                        this.mCurrentNode.addInstruction(new TypesInstruction(6, "[" + desc));
                        break;
                    }
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "[L" + desc + ";"));
                    break;
                }
                case 192: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, desc));
                    break;
                }
                case 193: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, desc));
                }
            }
        }
    }

    public void visitLdcInsn(Object cst) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitLdcInsn            (" + cst + ")");
        }
        if (this.mCurrentNode != null) {
            this.mCurrentNode.addInstruction(new TypesInstruction(6, Type.getInternalName(cst.getClass())));
        }
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitMultiANewArrayInsn (\"" + desc + "\", " + dims + ")");
        }
        if (this.mCurrentNode != null) {
            for (int i = 1; i <= dims; ++i) {
                this.mCurrentNode.addInstruction(new TypesInstruction(4));
            }
            this.mCurrentNode.addInstruction(new TypesInstruction(6, desc));
        }
    }

    public void visitInsn(int opcode) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitInsn               (" + ContinuationDebug.OPCODES[opcode] + ")");
        }
        if (this.mCurrentNode != null) {
            switch (opcode) {
                case 177: {
                    this.mCurrentNode = null;
                    break;
                }
                case 191: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    break;
                }
                case 1: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "NULL"));
                    break;
                }
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "1I"));
                    break;
                }
                case 11: 
                case 12: 
                case 13: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "1F"));
                    break;
                }
                case 9: 
                case 10: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "2J"));
                    break;
                }
                case 14: 
                case 15: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "2D"));
                    break;
                }
                case 50: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(7));
                    break;
                }
                case 46: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "1I"));
                    break;
                }
                case 48: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "1F"));
                    break;
                }
                case 51: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "1B"));
                    break;
                }
                case 52: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "1C"));
                    break;
                }
                case 53: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "1S"));
                    break;
                }
                case 47: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "2J"));
                    break;
                }
                case 49: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "2D"));
                    break;
                }
                case 79: 
                case 80: 
                case 81: 
                case 82: 
                case 83: 
                case 84: 
                case 85: 
                case 86: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    break;
                }
                case 87: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    break;
                }
                case 88: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(5));
                    break;
                }
                case 89: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(8));
                    break;
                }
                case 90: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(9));
                    break;
                }
                case 91: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(10));
                    break;
                }
                case 92: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(11));
                    break;
                }
                case 93: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(12));
                    break;
                }
                case 94: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(13));
                    break;
                }
                case 95: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(14));
                    break;
                }
                case 96: 
                case 97: 
                case 98: 
                case 99: 
                case 100: 
                case 101: 
                case 102: 
                case 103: 
                case 104: 
                case 105: 
                case 106: 
                case 107: 
                case 108: 
                case 109: 
                case 110: 
                case 111: 
                case 112: 
                case 113: 
                case 114: 
                case 115: 
                case 120: 
                case 121: 
                case 122: 
                case 123: 
                case 124: 
                case 125: 
                case 126: 
                case 127: 
                case 128: 
                case 129: 
                case 130: 
                case 131: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    break;
                }
                case 116: 
                case 117: 
                case 118: 
                case 119: {
                    break;
                }
                case 134: 
                case 138: 
                case 139: 
                case 143: 
                case 145: 
                case 146: 
                case 147: {
                    break;
                }
                case 133: 
                case 140: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "2J"));
                    break;
                }
                case 135: 
                case 141: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "2D"));
                    break;
                }
                case 136: 
                case 142: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "1I"));
                    break;
                }
                case 137: 
                case 144: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "1F"));
                    break;
                }
                case 148: 
                case 149: 
                case 150: 
                case 151: 
                case 152: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "1I"));
                    break;
                }
                case 190: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "1I"));
                    break;
                }
                case 194: 
                case 195: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                }
            }
        }
    }

    public void visitIincInsn(int var, int increment) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitIincInsn           (" + var + ", " + increment + ")");
        }
        if (this.mCurrentNode != null) {
            this.mCurrentNode.addInstruction(new TypesInstruction(3, var));
        }
    }

    public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitFieldInsn          (" + ContinuationDebug.OPCODES[opcode] + ", \"" + owner + "\", \"" + name + "\", \"" + desc + "\")");
        }
        if (this.mCurrentNode != null) {
            switch (opcode) {
                case 178: 
                case 180: {
                    if (178 != opcode) {
                        this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    }
                    Type type = Type.getType(desc);
                    switch (type.getSort()) {
                        case 10: {
                            this.mCurrentNode.addInstruction(new TypesInstruction(6, type.getInternalName()));
                            break;
                        }
                        case 9: {
                            this.mCurrentNode.addInstruction(new TypesInstruction(6, type.getDescriptor()));
                            break;
                        }
                        case 1: {
                            this.mCurrentNode.addInstruction(new TypesInstruction(6, "1Z"));
                            break;
                        }
                        case 3: {
                            this.mCurrentNode.addInstruction(new TypesInstruction(6, "1B"));
                            break;
                        }
                        case 2: {
                            this.mCurrentNode.addInstruction(new TypesInstruction(6, "1C"));
                            break;
                        }
                        case 6: {
                            this.mCurrentNode.addInstruction(new TypesInstruction(6, "1F"));
                            break;
                        }
                        case 5: {
                            this.mCurrentNode.addInstruction(new TypesInstruction(6, "1I"));
                            break;
                        }
                        case 4: {
                            this.mCurrentNode.addInstruction(new TypesInstruction(6, "1S"));
                            break;
                        }
                        case 8: {
                            this.mCurrentNode.addInstruction(new TypesInstruction(6, "2D"));
                            break;
                        }
                        case 7: {
                            this.mCurrentNode.addInstruction(new TypesInstruction(6, "2J"));
                        }
                    }
                    break;
                }
                case 179: 
                case 181: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    if (178 == opcode) break;
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                }
            }
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitIntInsn            (" + ContinuationDebug.OPCODES[opcode] + ", " + operand + ")");
        }
        if (this.mCurrentNode != null) {
            block0 : switch (opcode) {
                case 16: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "1B"));
                    break;
                }
                case 17: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "1S"));
                    break;
                }
                case 188: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    switch (operand) {
                        case 4: {
                            this.mCurrentNode.addInstruction(new TypesInstruction(6, "[Z"));
                            break block0;
                        }
                        case 5: {
                            this.mCurrentNode.addInstruction(new TypesInstruction(6, "[C"));
                            break block0;
                        }
                        case 6: {
                            this.mCurrentNode.addInstruction(new TypesInstruction(6, "[F"));
                            break block0;
                        }
                        case 7: {
                            this.mCurrentNode.addInstruction(new TypesInstruction(6, "[D"));
                            break block0;
                        }
                        case 8: {
                            this.mCurrentNode.addInstruction(new TypesInstruction(6, "[B"));
                            break block0;
                        }
                        case 9: {
                            this.mCurrentNode.addInstruction(new TypesInstruction(6, "[S"));
                            break block0;
                        }
                        case 10: {
                            this.mCurrentNode.addInstruction(new TypesInstruction(6, "[I"));
                            break block0;
                        }
                        case 11: {
                            this.mCurrentNode.addInstruction(new TypesInstruction(6, "[J"));
                        }
                    }
                }
            }
        }
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        TypesNode try_node;
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitTryCatchBlock      (" + start + ", " + end + ", " + handler + ", \"" + type + "\")");
        }
        if ((try_node = (TypesNode)this.mLabelMapping.get(start)) != null) {
            try_node.addSuccessor(handler);
        }
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitLookupSwitchInsn   (" + dflt + ", " + (null == keys ? null : StringUtils.join(keys, ",")) + ", " + (null == labels ? null : StringUtils.join(labels, ",")) + ")");
        }
        if (this.mCurrentNode != null) {
            this.mCurrentNode.addInstruction(new TypesInstruction(4));
            this.mCurrentNode.addSuccessor(dflt);
            for (int i = 0; i < labels.length; ++i) {
                this.mCurrentNode.addSuccessor(labels[i]);
            }
            this.mCurrentNode = null;
        }
    }

    public void visitJumpInsn(int opcode, Label label) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitJumpInsn           (" + ContinuationDebug.OPCODES[opcode] + ", " + label + ")");
        }
        if (this.mCurrentNode != null) {
            switch (opcode) {
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 198: 
                case 199: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addSuccessor(label);
                    break;
                }
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addInstruction(new TypesInstruction(4));
                    this.mCurrentNode.addSuccessor(label);
                    break;
                }
                case 168: {
                    this.mCurrentNode.addInstruction(new TypesInstruction(6, "1A"));
                    this.mCurrentNode.addSuccessor(label);
                    break;
                }
                case 167: {
                    this.mCurrentNode.addSuccessor(label);
                    this.mCurrentNode = null;
                }
            }
        }
    }

    public void visitLabel(Label label) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitLabel              (" + label + ")");
        }
        TypesNode new_node = new TypesNode();
        this.mLabelMapping.put(label, new_node);
        if (this.mCurrentNode != null) {
            this.mCurrentNode.setFollowingNode(new_node);
        }
        this.mCurrentNode = new_node;
        this.mCurrentNode.addInstruction(new TypesInstruction(16, ++this.mLabelcount));
        String exception_type = this.mClassVisitor.getMetrics().nextExceptionType();
        if (exception_type != null) {
            this.mCurrentNode.setSort(1);
            this.mCurrentNode.addInstruction(new TypesInstruction(6, exception_type));
        }
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitTableSwitchInsn    (" + min + ", " + max + ", " + dflt + ", " + (null == labels ? null : StringUtils.join(labels, ",")) + ")");
        }
        if (this.mCurrentNode != null) {
            this.mCurrentNode.addInstruction(new TypesInstruction(4));
            this.mCurrentNode.addSuccessor(dflt);
            for (int i = 0; i < labels.length; ++i) {
                this.mCurrentNode.addSuccessor(labels[i]);
            }
            this.mCurrentNode = null;
        }
    }

    public void visitMaxs(int maxStack, int maxLocals) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest("\nPROCESSING CONTROL FLOW");
        }
        this.mPauseContexts = new TypesContext[this.mPausecount + 1];
        this.mLabelContexts = new TypesContext[this.mLabelcount + 1];
        TypesNode following_node = null;
        TypesNode successor_node = null;
        TypesNode stack = this.mRootNode;
        while (stack != null) {
            TypesNode node = stack;
            stack = stack.getNextToProcess();
            this.processInstructions(node);
            for (TypesSuccessor successor = node.getSuccessors(); successor != null; successor = successor.getNextSuccessor()) {
                successor_node = (TypesNode)this.mLabelMapping.get(successor.getLabel());
                if (successor_node.isProcessed()) continue;
                successor_node.setProcessed(true);
                successor_node.setPreceeder(true, node);
                successor_node.setNextToProcess(stack);
                stack = successor_node;
            }
            if (node.getFollowingNode() == null || node.getFollowingNode().isProcessed()) continue;
            following_node = node.getFollowingNode();
            following_node.setProcessed(true);
            following_node.setPreceeder(false, node);
            following_node.setNextToProcess(stack);
            stack = following_node;
        }
        this.mClassVisitor.setPauseContexts(this.mPauseContexts);
        this.mClassVisitor.setLabelContexts(this.mLabelContexts);
    }

    private void processInstructions(TypesNode node) {
        TypesContext context = null;
        if (null == node.getPreceeder()) {
            context = new TypesContext();
        } else {
            TypesContext preceeder_context = node.getPreceeder().getContext();
            context = node.getIsSuccessor() ? (TypesContext)preceeder_context.clone() : new TypesContext(preceeder_context.getVars(), preceeder_context.getStackClone());
        }
        node.setContext(context);
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            context.setDebugIndent(StringUtils.repeat("  ", node.getLevel()));
        }
        TypesContext exception_context = null;
        Iterator iterator = node.getInstructions().iterator();
        block18: while (iterator.hasNext()) {
            TypesInstruction instruction = (TypesInstruction)iterator.next();
            switch (instruction.getOpcode()) {
                case 1: {
                    String type = context.peek();
                    if (instruction.getType() != null) {
                        type = instruction.getType();
                    }
                    String current_var_type = context.getVar(instruction.getArgument());
                    if (node.getPreceeder() != null && context.getVars() == node.getPreceeder().getContext().getVars() && (null == current_var_type || current_var_type != "NULL" && !current_var_type.equals(type))) {
                        context.cloneVars();
                    }
                    if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
                        ContinuationDebug.LOGGER.finest(StringUtils.repeat("  ", node.getLevel()) + "  SET  " + instruction.getArgument() + ", " + type);
                    }
                    context.pop();
                    context.setVar(instruction.getArgument(), type);
                    if (exception_context == null) continue block18;
                    exception_context.setVar(instruction.getArgument(), type);
                    exception_context = null;
                    break;
                }
                case 2: {
                    String type = instruction.getType();
                    if (null == type) {
                        type = context.getVar(instruction.getArgument());
                    }
                    if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
                        ContinuationDebug.LOGGER.finest(StringUtils.repeat("  ", node.getLevel()) + "  GET  " + instruction.getArgument() + ", " + type);
                    }
                    context.push(type);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
                        ContinuationDebug.LOGGER.finest(StringUtils.repeat("  ", node.getLevel()) + "  POP " + context.peek());
                    }
                    context.pop();
                    break;
                }
                case 5: {
                    String type;
                    if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
                        ContinuationDebug.LOGGER.finest(StringUtils.repeat("  ", node.getLevel()) + "  POP2 " + context.peek());
                    }
                    if ((type = context.pop()).startsWith("2")) continue block18;
                    context.pop();
                    break;
                }
                case 6: {
                    if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
                        ContinuationDebug.LOGGER.finest(StringUtils.repeat("  ", node.getLevel()) + "  PUSH " + instruction.getType());
                    }
                    context.push(instruction.getType());
                    break;
                }
                case 7: {
                    context.pop();
                    String array_desc = context.pop();
                    String element_desc = null;
                    if (array_desc.startsWith("[[")) {
                        element_desc = array_desc.substring(1);
                    } else {
                        Type array_type = Type.getType(array_desc);
                        element_desc = array_type.getElementType().getInternalName();
                    }
                    context.push(element_desc);
                    break;
                }
                case 8: {
                    context.push(context.peek());
                    break;
                }
                case 9: {
                    String type1 = context.pop();
                    String type2 = context.pop();
                    context.push(type1);
                    context.push(type2);
                    context.push(type1);
                    break;
                }
                case 10: {
                    String type1 = context.pop();
                    String type2 = context.pop();
                    if (type2.startsWith("2")) {
                        context.push(type1);
                        context.push(type2);
                        context.push(type1);
                        break;
                    }
                    String type3 = context.pop();
                    if (type3 == null) continue block18;
                    context.push(type1);
                    context.push(type3);
                    context.push(type2);
                    context.push(type1);
                    break;
                }
                case 11: {
                    String type1 = context.pop();
                    if (type1.startsWith("2")) {
                        context.push(type1);
                        context.push(type1);
                        break;
                    }
                    String type2 = context.pop();
                    context.push(type2);
                    context.push(type1);
                    context.push(type2);
                    context.push(type1);
                    break;
                }
                case 12: {
                    String type1 = context.pop();
                    String type2 = context.pop();
                    if (type1.startsWith("2")) {
                        context.push(type1);
                        context.push(type2);
                        context.push(type1);
                        break;
                    }
                    String type3 = context.pop();
                    context.push(type2);
                    context.push(type1);
                    context.push(type3);
                    context.push(type2);
                    context.push(type1);
                    break;
                }
                case 13: {
                    String type3;
                    String type1 = context.pop();
                    String type2 = context.pop();
                    if (type1.startsWith("2")) {
                        if (type2.startsWith("2")) {
                            context.push(type1);
                            context.push(type2);
                            context.push(type1);
                            break;
                        }
                        type3 = context.pop();
                        context.push(type1);
                        context.push(type3);
                        context.push(type2);
                        context.push(type1);
                        break;
                    }
                    if (type2.startsWith("2")) continue block18;
                    type3 = context.pop();
                    if (type3.startsWith("2")) {
                        context.push(type2);
                        context.push(type1);
                        context.push(type3);
                        context.push(type2);
                        context.push(type1);
                        break;
                    }
                    String type4 = context.pop();
                    context.push(type2);
                    context.push(type1);
                    context.push(type4);
                    context.push(type3);
                    context.push(type2);
                    context.push(type1);
                    break;
                }
                case 14: {
                    String type1 = context.pop();
                    String type2 = context.pop();
                    context.push(type1);
                    context.push(type2);
                    break;
                }
                case 15: {
                    if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
                        ContinuationDebug.LOGGER.finest(StringUtils.repeat("  ", node.getLevel()) + "PAUSE " + instruction.getArgument());
                    }
                    this.mPauseContexts[instruction.getArgument()] = context.clone(node);
                    break;
                }
                case 16: {
                    TypesContext label_context;
                    if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
                        ContinuationDebug.LOGGER.finest(StringUtils.repeat("  ", node.getLevel()) + "LABEL " + instruction.getArgument());
                    }
                    this.mLabelContexts[instruction.getArgument()] = label_context = context.clone(node);
                    if (1 != node.getSort()) break;
                    exception_context = label_context;
                }
            }
        }
    }

    public void visitLineNumber(int line, Label start) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitLineNumber         (" + line + ", " + start + ")");
        }
    }

    public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitLocalVariable      (\"" + name + "\", \"" + desc + "\", \"" + signature + "\", " + start + ", " + end + ", " + index + ")");
        }
    }

    public void visitAttribute(Attribute attr) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitAttribute          (" + attr + ")");
        }
    }

    public void visitCode() {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Code:visitCode               ()");
        }
    }

    public AnnotationVisitor visitAnnotationDefault() {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitAnnotationDefault  ()");
        }
        return null;
    }

    public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitAnnotation         (\"" + desc + "\", " + visible + ")");
        }
        return null;
    }

    public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitParameterAnnotation(" + parameter + ", \"" + desc + "\", " + visible + ")");
        }
        return null;
    }

    public void visitEnd() {
        if (ContinuationDebug.LOGGER.isLoggable(Level.FINEST)) {
            ContinuationDebug.LOGGER.finest(" Type:visitEnd                ()");
        }
    }
}

