/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.rife.continuations.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.logging.Logger;

public class ObjectUtils {
    public static Object genericClone(Object object) {
        if (object == null) {
            return null;
        }
        if (Object.class == object.getClass()) {
            return object;
        }
        if (String.class == object.getClass()) {
            return object;
        }
        if (object instanceof Throwable) {
            return object;
        }
        if (StringBuffer.class == object.getClass()) {
            return new StringBuffer(object.toString());
        }
        if (object instanceof Number || object instanceof Boolean || object instanceof Character) {
            return object;
        }
        if (!(object instanceof Cloneable)) {
            return null;
        }
        try {
            Method method = object.getClass().getMethod("clone", null);
            method.setAccessible(true);
            return method.invoke(object, (Object[])null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Object deepClone(Object object) throws CloneNotSupportedException {
        if (null == object) {
            return null;
        }
        String classname = object.getClass().getName();
        if ('[' == classname.charAt(0)) {
            if (classname.charAt(1) != '[' && classname.charAt(1) != 'L') {
                switch (classname.charAt(1)) {
                    case 'B': {
                        return ((byte[])object).clone();
                    }
                    case 'Z': {
                        return ((boolean[])object).clone();
                    }
                    case 'C': {
                        return ((char[])object).clone();
                    }
                    case 'S': {
                        return ((short[])object).clone();
                    }
                    case 'I': {
                        return ((int[])object).clone();
                    }
                    case 'J': {
                        return ((long[])object).clone();
                    }
                    case 'F': {
                        return ((float[])object).clone();
                    }
                    case 'D': {
                        return ((double[])object).clone();
                    }
                }
                Logger.getLogger("com.uwyn.rife.continuations.util").severe("Unknown primitive array class: " + classname);
                return null;
            }
            int dimension_count = 1;
            while (classname.charAt(dimension_count) == '[') {
                ++dimension_count;
            }
            Class<?> baseClass = null;
            if (classname.charAt(dimension_count) != 'L') {
                baseClass = ObjectUtils.getBaseClass(object);
            } else {
                try {
                    baseClass = Class.forName(classname.substring(dimension_count + 1, classname.length() - 1));
                }
                catch (ClassNotFoundException e) {
                    Logger.getLogger("com.uwyn.rife.continuations.util").severe("Internal error: class definition inconsistency: " + classname);
                    return null;
                }
            }
            int[] dimensions = new int[dimension_count];
            dimensions[0] = Array.getLength(object);
            for (int i = 1; i < dimension_count; ++i) {
                dimensions[i] = 0;
            }
            Object copy = Array.newInstance(baseClass, dimensions);
            for (int i = 0; i < dimensions[0]; ++i) {
                Array.set(copy, i, ObjectUtils.deepClone(Array.get(object, i)));
            }
            return copy;
        }
        if (object instanceof Collection && object instanceof Cloneable) {
            Collection collection = (Collection)object;
            Collection copy = (Collection)ObjectUtils.genericClone(object);
            copy.clear();
            Iterator collection_it = collection.iterator();
            while (collection_it.hasNext()) {
                copy.add(ObjectUtils.deepClone(collection_it.next()));
            }
            return copy;
        }
        if (object instanceof Map && object instanceof Cloneable) {
            Map map = (Map)object;
            Map copy = (Map)ObjectUtils.genericClone(object);
            copy.clear();
            Iterator collection_it = map.entrySet().iterator();
            Map.Entry entry = null;
            while (collection_it.hasNext()) {
                entry = collection_it.next();
                copy.put(ObjectUtils.deepClone(entry.getKey()), ObjectUtils.deepClone(entry.getValue()));
            }
            return copy;
        }
        Object copy = ObjectUtils.genericClone(object);
        if (null == copy) {
            throw new CloneNotSupportedException(object.getClass().getName());
        }
        return copy;
    }

    public static Class getBaseClass(Object object) {
        if (object == null) {
            return Void.TYPE;
        }
        String className = object.getClass().getName();
        int dims = 0;
        while (className.charAt(dims) == '[') {
            ++dims;
        }
        if (dims == 0) {
            return object.getClass();
        }
        switch (className.charAt(dims)) {
            case 'Z': {
                return Boolean.TYPE;
            }
            case 'B': {
                return Byte.TYPE;
            }
            case 'S': {
                return Short.TYPE;
            }
            case 'C': {
                return Character.TYPE;
            }
            case 'I': {
                return Integer.TYPE;
            }
            case 'J': {
                return Long.TYPE;
            }
            case 'F': {
                return Float.TYPE;
            }
            case 'D': {
                return Double.TYPE;
            }
            case 'L': {
                try {
                    return Class.forName(className.substring(dims + 1, className.length() - 1));
                }
                catch (ClassNotFoundException e) {
                    return null;
                }
            }
        }
        return null;
    }
}

