/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.devtools.restart;

import java.lang.reflect.Method;

class RestartLauncher
extends Thread {
    private final String mainClassName;
    private final String[] args;
    private Throwable error;

    RestartLauncher(ClassLoader classLoader, String mainClassName, String[] args, Thread.UncaughtExceptionHandler exceptionHandler) {
        this.mainClassName = mainClassName;
        this.args = args;
        this.setName("restartedMain");
        this.setUncaughtExceptionHandler(exceptionHandler);
        this.setDaemon(false);
        this.setContextClassLoader(classLoader);
    }

    @Override
    public void run() {
        try {
            Class<?> mainClass = Class.forName(this.mainClassName, false, this.getContextClassLoader());
            Method mainMethod = mainClass.getDeclaredMethod("main", String[].class);
            mainMethod.setAccessible(true);
            mainMethod.invoke(null, new Object[]{this.args});
        }
        catch (Throwable ex) {
            this.error = ex;
            this.getUncaughtExceptionHandler().uncaughtException(this, ex);
        }
    }

    Throwable getError() {
        return this.error;
    }
}

