/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.context.config;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.jspecify.annotations.Nullable;
import org.springframework.boot.context.config.ConfigDataLocation;
import org.springframework.boot.context.properties.bind.AbstractBindHandler;
import org.springframework.boot.context.properties.bind.BindContext;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.source.ConfigurationProperty;
import org.springframework.boot.context.properties.source.ConfigurationPropertyName;
import org.springframework.boot.origin.Origin;

class ConfigDataLocationBindHandler
extends AbstractBindHandler {
    ConfigDataLocationBindHandler() {
    }

    @Override
    public @Nullable Object onSuccess(ConfigurationPropertyName name, Bindable<?> target, BindContext context, Object result) {
        OriginMapper originMapper = new OriginMapper(context.getConfigurationProperty());
        if (result instanceof ConfigDataLocation) {
            ConfigDataLocation location = (ConfigDataLocation)result;
            return originMapper.map(location);
        }
        if (result instanceof List) {
            List locations = (List)result;
            return locations.stream().map(originMapper::mapIfPossible).collect(Collectors.toCollection(ArrayList::new));
        }
        if (result instanceof ConfigDataLocation[]) {
            ConfigDataLocation[] locations = (ConfigDataLocation[])result;
            return Arrays.stream(locations).map(originMapper::mapIfPossible).toArray(ConfigDataLocation[]::new);
        }
        return result;
    }

    private record OriginMapper(@Nullable ConfigurationProperty property) {
        @Nullable Object mapIfPossible(@Nullable Object object) {
            Object object2;
            if (object instanceof ConfigDataLocation) {
                ConfigDataLocation location = (ConfigDataLocation)object;
                object2 = this.map(location);
            } else {
                object2 = object;
            }
            return object2;
        }

        @Nullable ConfigDataLocation map(@Nullable ConfigDataLocation location) {
            if (location == null) {
                return null;
            }
            Origin origin = Origin.from(location);
            return origin != null ? location : location.withOrigin(Origin.from(this.property()));
        }
    }
}

