/*
 * Copyright 2004-present the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.springframework.security.config.web.server

/**
 * A Kotlin DSL to configure the [ServerHttpSecurity] permissions policy header using
 * idiomatic Kotlin code.
 *
 * @author Christophe Gilles
 * @since 5.5
 * @property policy the policy to be used in the response header.
 */
@ServerSecurityMarker
class ServerPermissionsPolicyDsl {
    var policy: String? = null

    internal fun get(): (ServerHttpSecurity.HeaderSpec.PermissionsPolicySpec) -> Unit {
        return { permissionsPolicy ->
            policy?.also {
                permissionsPolicy.policy(policy)
            }
        }
    }
}
