/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.config.web.server;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.reactivestreams.Publisher;
import org.springframework.core.ResolvableType;
import org.springframework.core.io.buffer.DataBuffer;
import org.springframework.core.io.buffer.DataBufferFactory;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.MediaType;
import org.springframework.http.codec.HttpMessageEncoder;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.security.config.web.server.HttpMessageConverters;
import org.springframework.security.oauth2.core.OAuth2Error;
import org.springframework.util.MimeType;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

class OAuth2ErrorEncoder
implements HttpMessageEncoder<OAuth2Error> {
    private final HttpMessageConverter<Object> messageConverter = HttpMessageConverters.getJsonMessageConverter();

    OAuth2ErrorEncoder() {
    }

    @NotNull
    public List<MediaType> getStreamingMediaTypes() {
        return List.of();
    }

    public boolean canEncode(ResolvableType elementType, MimeType mimeType) {
        return this.getEncodableMimeTypes().contains(mimeType);
    }

    @NotNull
    public Flux<DataBuffer> encode(Publisher<? extends OAuth2Error> error, DataBufferFactory bufferFactory, ResolvableType elementType, MimeType mimeType, Map<String, Object> hints) {
        return Mono.from(error).flatMap(data -> {
            ByteArrayHttpOutputMessage bytes = new ByteArrayHttpOutputMessage();
            try {
                this.messageConverter.write(data, MediaType.APPLICATION_JSON, (HttpOutputMessage)bytes);
                return Mono.just((Object)bytes.getBody().toByteArray());
            }
            catch (IOException ex) {
                return Mono.error((Throwable)ex);
            }
        }).map(arg_0 -> ((DataBufferFactory)bufferFactory).wrap(arg_0)).flux();
    }

    @NotNull
    public List<MimeType> getEncodableMimeTypes() {
        return List.of(MediaType.APPLICATION_JSON);
    }

    private static class ByteArrayHttpOutputMessage
    implements HttpOutputMessage {
        private final ByteArrayOutputStream body = new ByteArrayOutputStream();

        private ByteArrayHttpOutputMessage() {
        }

        @NotNull
        public ByteArrayOutputStream getBody() {
            return this.body;
        }

        @NotNull
        public HttpHeaders getHeaders() {
            return new HttpHeaders();
        }
    }
}

