/*
 * Decompiled with CFR 0.152.
 */
package com.clickhouse.jdbc.internal;

import com.clickhouse.client.ClickHouseColumn;
import com.clickhouse.client.ClickHouseConfig;
import com.clickhouse.client.ClickHouseRequest;
import com.clickhouse.client.ClickHouseUtils;
import com.clickhouse.client.ClickHouseValue;
import com.clickhouse.client.ClickHouseValues;
import com.clickhouse.client.data.ClickHousePipedStream;
import com.clickhouse.client.data.ClickHouseRowBinaryProcessor;
import com.clickhouse.client.logging.Logger;
import com.clickhouse.client.logging.LoggerFactory;
import com.clickhouse.jdbc.ClickHousePreparedStatement;
import com.clickhouse.jdbc.SqlExceptionUtils;
import com.clickhouse.jdbc.internal.ClickHouseConnectionImpl;
import com.clickhouse.jdbc.internal.ClickHouseStatementImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;

public class InputBasedPreparedStatement
extends ClickHouseStatementImpl
implements ClickHousePreparedStatement {
    private static final Logger log = LoggerFactory.getLogger(InputBasedPreparedStatement.class);
    private final Calendar defaultCalendar;
    private final ZoneId timeZoneForDate;
    private final ZoneId timeZoneForTs;
    private final List<ClickHouseColumn> columns;
    private final ClickHouseValue[] values;
    private final boolean[] flags;
    private int counter;
    private ClickHousePipedStream stream;

    protected InputBasedPreparedStatement(ClickHouseConnectionImpl connection, ClickHouseRequest<?> request, List<ClickHouseColumn> columns, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        super(connection, request, resultSetType, resultSetConcurrency, resultSetHoldability);
        if (columns == null) {
            throw SqlExceptionUtils.clientError("Non-null column list is required");
        }
        ClickHouseConfig config = this.getConfig();
        this.defaultCalendar = connection.getDefaultCalendar();
        this.timeZoneForTs = config.getUseTimeZone().toZoneId();
        this.timeZoneForDate = config.isUseServerTimeZoneForDates() ? this.timeZoneForTs : null;
        this.columns = columns;
        int size = columns.size();
        int i = 0;
        this.values = new ClickHouseValue[size];
        for (ClickHouseColumn col : columns) {
            this.values[i++] = ClickHouseValues.newValue((ClickHouseConfig)config, (ClickHouseColumn)col);
        }
        this.flags = new boolean[size];
        this.counter = 0;
        this.stream = new ClickHousePipedStream(config.getMaxBufferSize(), 0, config.getSocketTimeout());
    }

    protected void ensureParams() throws SQLException {
        ArrayList<String> list = new ArrayList<String>();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (this.flags[i]) continue;
            list.add(String.valueOf(i + 1));
        }
        if (!list.isEmpty()) {
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Missing parameter(s): %s", (Object[])new Object[]{list}));
        }
    }

    protected int toArrayIndex(int parameterIndex) throws SQLException {
        if (parameterIndex < 1 || parameterIndex > this.values.length) {
            throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Parameter index must between 1 and %d but we got %d", (Object[])new Object[]{this.values.length, parameterIndex}));
        }
        return parameterIndex - 1;
    }

    @Override
    public ResultSet executeQuery() throws SQLException {
        throw SqlExceptionUtils.clientError("Input function can be only used for insertion not query");
    }

    @Override
    public int executeUpdate() throws SQLException {
        this.ensureParams();
        this.addBatch();
        int row = this.getUpdateCount();
        return row > 0 ? row : 0;
    }

    @Override
    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setShort(int parameterIndex, short x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setInt(int parameterIndex, int x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setLong(int parameterIndex, long x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setString(int parameterIndex, String x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(new String(x, StandardCharsets.UTF_8));
        this.flags[idx] = true;
    }

    @Override
    public void clearParameters() throws SQLException {
        this.ensureOpen();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            this.flags[i] = false;
        }
    }

    @Override
    public void setObject(int parameterIndex, Object x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }

    @Override
    public boolean execute() throws SQLException {
        this.ensureParams();
        this.addBatch();
        this.executeBatch();
        return false;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        this.ensureOpen();
        throw SqlExceptionUtils.unsupportedError("addBatch(String) cannot be called in PreparedStatement or CallableStatement!");
    }

    @Override
    public void addBatch() throws SQLException {
        this.ensureOpen();
        ClickHouseConfig config = this.getConfig();
        ClickHouseRowBinaryProcessor.MappedFunctions functions = ClickHouseRowBinaryProcessor.getMappedFunctions();
        int len = this.values.length;
        for (int i = 0; i < len; ++i) {
            if (!this.flags[i]) {
                throw SqlExceptionUtils.clientError(ClickHouseUtils.format((String)"Missing value for parameter #%d", (Object[])new Object[]{i + 1}));
            }
            try {
                functions.serialize(this.values[i], config, this.columns.get(i), (OutputStream)this.stream);
                continue;
            }
            catch (IOException e) {
                throw SqlExceptionUtils.handle(e);
            }
        }
        ++this.counter;
        this.clearParameters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] executeBatch() throws SQLException {
        this.ensureOpen();
        boolean continueOnError = this.getConnection().getJdbcConfig().isContinueBatchOnError();
        int[] results = new int[this.counter];
        int result = 0;
        try {
            this.stream.close();
            result = this.executeInsert((String)this.getRequest().getStatements(false).get(0), (InputStream)this.stream.getInput());
        }
        catch (Exception e) {
            if (!continueOnError) {
                throw SqlExceptionUtils.handle(e);
            }
            result = -3;
            log.error((Object)"Failed to execute batch insert of %d records", new Object[]{this.counter + 1, e});
        }
        finally {
            this.clearBatch();
        }
        Arrays.fill(results, result);
        return results;
    }

    @Override
    public void clearBatch() throws SQLException {
        this.ensureOpen();
        this.counter = 0;
        ClickHouseConfig config = this.getConfig();
        this.stream = new ClickHousePipedStream(config.getMaxBufferSize(), 0, config.getSocketTimeout());
    }

    @Override
    public void setArray(int parameterIndex, Array x) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        Object array = x != null ? x.getArray() : x;
        this.values[idx].update(array);
        this.flags[idx] = true;
    }

    @Override
    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        if (x != null) {
            LocalDate d;
            if (cal == null) {
                cal = this.defaultCalendar;
            }
            ZoneId tz = cal.getTimeZone().toZoneId();
            if (this.timeZoneForDate == null || tz.equals(this.timeZoneForDate)) {
                d = x.toLocalDate();
            } else {
                Calendar c = (Calendar)cal.clone();
                c.setTime(x);
                d = c.toInstant().atZone(tz).withZoneSameInstant(this.timeZoneForDate).toLocalDate();
            }
            this.values[idx].update(d);
        } else {
            this.values[idx].resetToNullOrEmpty();
        }
        this.flags[idx] = true;
    }

    @Override
    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        if (x != null) {
            LocalTime t;
            ZoneId tz;
            if (cal == null) {
                cal = this.defaultCalendar;
            }
            if ((tz = cal.getTimeZone().toZoneId()).equals(this.timeZoneForTs)) {
                t = x.toLocalTime();
            } else {
                Calendar c = (Calendar)cal.clone();
                c.setTime(x);
                t = c.toInstant().atZone(tz).withZoneSameInstant(this.timeZoneForTs).toLocalTime();
            }
            this.values[idx].update(t);
        } else {
            this.values[idx].resetToNullOrEmpty();
        }
        this.flags[idx] = true;
    }

    @Override
    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        if (x != null) {
            LocalDateTime dt;
            ZoneId tz;
            if (cal == null) {
                cal = this.defaultCalendar;
            }
            if ((tz = cal.getTimeZone().toZoneId()).equals(this.timeZoneForTs)) {
                dt = x.toLocalDateTime();
            } else {
                Calendar c = (Calendar)cal.clone();
                c.setTime(x);
                dt = c.toInstant().atZone(tz).withZoneSameInstant(this.timeZoneForTs).toLocalDateTime();
            }
            this.values[idx].update(dt);
        } else {
            this.values[idx].resetToNullOrEmpty();
        }
        this.flags[idx] = true;
    }

    @Override
    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].resetToNullOrEmpty();
        this.flags[idx] = true;
    }

    @Override
    public ParameterMetaData getParameterMetaData() throws SQLException {
        return null;
    }

    @Override
    public void setObject(int parameterIndex, Object x, int targetSqlType, int scaleOrLength) throws SQLException {
        this.ensureOpen();
        int idx = this.toArrayIndex(parameterIndex);
        this.values[idx].update(x);
        this.flags[idx] = true;
    }
}

