/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.core.tracker.manager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import tech.powerjob.worker.core.tracker.processor.ProcessorTracker;

public class ProcessorTrackerManager {
    private static final Map<Long, Map<String, ProcessorTracker>> PROCESSOR_TRACKER_CONTAINER = Maps.newHashMap();

    public static synchronized ProcessorTracker getProcessorTracker(Long instanceId, String address, Supplier<ProcessorTracker> creator) {
        ProcessorTracker processorTracker = (ProcessorTracker)PROCESSOR_TRACKER_CONTAINER.getOrDefault(instanceId, Collections.emptyMap()).get(address);
        if (processorTracker == null) {
            processorTracker = creator.get();
            PROCESSOR_TRACKER_CONTAINER.computeIfAbsent(instanceId, ignore -> Maps.newHashMap()).put(address, processorTracker);
        }
        return processorTracker;
    }

    public static synchronized List<ProcessorTracker> removeProcessorTracker(Long instanceId) {
        LinkedList res = Lists.newLinkedList();
        Map<String, ProcessorTracker> ttAddress2Pt = PROCESSOR_TRACKER_CONTAINER.remove(instanceId);
        if (ttAddress2Pt != null) {
            res.addAll(ttAddress2Pt.values());
            ttAddress2Pt.clear();
        }
        return res;
    }
}

