/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.log.impl;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.helpers.FormattingTuple;
import org.slf4j.helpers.MessageFormatter;
import tech.powerjob.common.enums.LogLevel;
import tech.powerjob.common.enums.LogType;
import tech.powerjob.common.model.LogConfig;
import tech.powerjob.worker.log.OmsLogger;

public abstract class AbstractOmsLogger
implements OmsLogger {
    private final LogConfig logConfig;

    public AbstractOmsLogger(LogConfig logConfig) {
        this.logConfig = logConfig;
        if (logConfig.getLevel() == null) {
            logConfig.setLevel(Integer.valueOf(LogLevel.INFO.getV()));
        }
        if (logConfig.getType() == null) {
            logConfig.setType(LogType.ONLINE.getV());
        }
    }

    abstract void debug0(String var1, Object ... var2);

    abstract void info0(String var1, Object ... var2);

    abstract void warn0(String var1, Object ... var2);

    abstract void error0(String var1, Object ... var2);

    @Override
    public void debug(String messagePattern, Object ... args) {
        if (LogLevel.DEBUG.getV() < this.logConfig.getLevel()) {
            return;
        }
        this.debug0(messagePattern, args);
    }

    @Override
    public void info(String messagePattern, Object ... args) {
        if (LogLevel.INFO.getV() < this.logConfig.getLevel()) {
            return;
        }
        this.info0(messagePattern, args);
    }

    @Override
    public void warn(String messagePattern, Object ... args) {
        if (LogLevel.WARN.getV() < this.logConfig.getLevel()) {
            return;
        }
        this.warn0(messagePattern, args);
    }

    @Override
    public void error(String messagePattern, Object ... args) {
        if (LogLevel.ERROR.getV() < this.logConfig.getLevel()) {
            return;
        }
        this.error0(messagePattern, args);
    }

    protected static String genLogContent(String messagePattern, Object ... arg) {
        FormattingTuple formattingTuple = MessageFormatter.arrayFormat((String)messagePattern, (Object[])arg);
        if (formattingTuple.getThrowable() != null) {
            String stackTrace = ExceptionUtils.getStackTrace((Throwable)formattingTuple.getThrowable());
            return formattingTuple.getMessage() + System.lineSeparator() + stackTrace;
        }
        return formattingTuple.getMessage();
    }
}

