/*
 * Decompiled with CFR 0.152.
 */
package tech.powerjob.worker.persistence.db;

import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import tech.powerjob.common.utils.CollectionUtils;

public class SimpleTaskQuery {
    private static final String LINK = " and ";
    private String taskId;
    private Collection<String> taskIds;
    private Long subInstanceId;
    private Long instanceId;
    private String taskName;
    private String address;
    private Integer status;
    private String queryContent = " * ";
    private String queryCondition;
    private String otherCondition;
    private Integer limit;
    private String fullCustomQueryCondition;
    private boolean readOnly = false;

    public String getQueryCondition() {
        StringBuilder sb = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)this.taskId)) {
            sb.append("task_id = '").append(this.taskId).append("'").append(LINK);
        }
        if (!CollectionUtils.isEmpty(this.taskIds)) {
            String taskIdsInQuery = this.taskIds.stream().map(id -> String.format("'%s'", id)).collect(Collectors.joining(", "));
            sb.append("task_id in (").append(taskIdsInQuery).append(")").append(LINK);
        }
        if (this.subInstanceId != null) {
            sb.append("sub_instance_id = ").append(this.subInstanceId).append(LINK);
        }
        if (this.instanceId != null) {
            sb.append("instance_id = ").append(this.instanceId).append(LINK);
        }
        if (!StringUtils.isEmpty((CharSequence)this.address)) {
            sb.append("address = '").append(this.address).append("'").append(LINK);
        }
        if (!StringUtils.isEmpty((CharSequence)this.taskName)) {
            sb.append("task_name = '").append(this.taskName).append("'").append(LINK);
        }
        if (this.status != null) {
            sb.append("status = ").append(this.status).append(LINK);
        }
        if (StringUtils.isNotEmpty((CharSequence)this.fullCustomQueryCondition)) {
            sb.append(this.fullCustomQueryCondition);
            return sb.toString();
        }
        if (!StringUtils.isEmpty((CharSequence)this.queryCondition)) {
            sb.append(this.queryCondition).append(LINK);
        }
        String substring = sb.substring(0, sb.length() - LINK.length());
        if (!StringUtils.isEmpty((CharSequence)this.otherCondition)) {
            substring = substring + this.otherCondition;
        }
        if (this.limit != null) {
            substring = substring + " limit " + this.limit;
        }
        return substring;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Collection<String> getTaskIds() {
        return this.taskIds;
    }

    public Long getSubInstanceId() {
        return this.subInstanceId;
    }

    public Long getInstanceId() {
        return this.instanceId;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public String getAddress() {
        return this.address;
    }

    public Integer getStatus() {
        return this.status;
    }

    public String getQueryContent() {
        return this.queryContent;
    }

    public String getOtherCondition() {
        return this.otherCondition;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public String getFullCustomQueryCondition() {
        return this.fullCustomQueryCondition;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setTaskId(String taskId) {
        this.taskId = taskId;
    }

    public void setTaskIds(Collection<String> taskIds) {
        this.taskIds = taskIds;
    }

    public void setSubInstanceId(Long subInstanceId) {
        this.subInstanceId = subInstanceId;
    }

    public void setInstanceId(Long instanceId) {
        this.instanceId = instanceId;
    }

    public void setTaskName(String taskName) {
        this.taskName = taskName;
    }

    public void setAddress(String address) {
        this.address = address;
    }

    public void setStatus(Integer status) {
        this.status = status;
    }

    public void setQueryContent(String queryContent) {
        this.queryContent = queryContent;
    }

    public void setQueryCondition(String queryCondition) {
        this.queryCondition = queryCondition;
    }

    public void setOtherCondition(String otherCondition) {
        this.otherCondition = otherCondition;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public void setFullCustomQueryCondition(String fullCustomQueryCondition) {
        this.fullCustomQueryCondition = fullCustomQueryCondition;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SimpleTaskQuery)) {
            return false;
        }
        SimpleTaskQuery other = (SimpleTaskQuery)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$taskId = this.getTaskId();
        String other$taskId = other.getTaskId();
        if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
            return false;
        }
        Collection<String> this$taskIds = this.getTaskIds();
        Collection<String> other$taskIds = other.getTaskIds();
        if (this$taskIds == null ? other$taskIds != null : !((Object)this$taskIds).equals(other$taskIds)) {
            return false;
        }
        Long this$subInstanceId = this.getSubInstanceId();
        Long other$subInstanceId = other.getSubInstanceId();
        if (this$subInstanceId == null ? other$subInstanceId != null : !((Object)this$subInstanceId).equals(other$subInstanceId)) {
            return false;
        }
        Long this$instanceId = this.getInstanceId();
        Long other$instanceId = other.getInstanceId();
        if (this$instanceId == null ? other$instanceId != null : !((Object)this$instanceId).equals(other$instanceId)) {
            return false;
        }
        String this$taskName = this.getTaskName();
        String other$taskName = other.getTaskName();
        if (this$taskName == null ? other$taskName != null : !this$taskName.equals(other$taskName)) {
            return false;
        }
        String this$address = this.getAddress();
        String other$address = other.getAddress();
        if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
            return false;
        }
        Integer this$status = this.getStatus();
        Integer other$status = other.getStatus();
        if (this$status == null ? other$status != null : !((Object)this$status).equals(other$status)) {
            return false;
        }
        String this$queryContent = this.getQueryContent();
        String other$queryContent = other.getQueryContent();
        if (this$queryContent == null ? other$queryContent != null : !this$queryContent.equals(other$queryContent)) {
            return false;
        }
        String this$queryCondition = this.getQueryCondition();
        String other$queryCondition = other.getQueryCondition();
        if (this$queryCondition == null ? other$queryCondition != null : !this$queryCondition.equals(other$queryCondition)) {
            return false;
        }
        String this$otherCondition = this.getOtherCondition();
        String other$otherCondition = other.getOtherCondition();
        if (this$otherCondition == null ? other$otherCondition != null : !this$otherCondition.equals(other$otherCondition)) {
            return false;
        }
        Integer this$limit = this.getLimit();
        Integer other$limit = other.getLimit();
        if (this$limit == null ? other$limit != null : !((Object)this$limit).equals(other$limit)) {
            return false;
        }
        String this$fullCustomQueryCondition = this.getFullCustomQueryCondition();
        String other$fullCustomQueryCondition = other.getFullCustomQueryCondition();
        if (this$fullCustomQueryCondition == null ? other$fullCustomQueryCondition != null : !this$fullCustomQueryCondition.equals(other$fullCustomQueryCondition)) {
            return false;
        }
        return this.isReadOnly() == other.isReadOnly();
    }

    protected boolean canEqual(Object other) {
        return other instanceof SimpleTaskQuery;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $taskId = this.getTaskId();
        result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
        Collection<String> $taskIds = this.getTaskIds();
        result = result * 59 + ($taskIds == null ? 43 : ((Object)$taskIds).hashCode());
        Long $subInstanceId = this.getSubInstanceId();
        result = result * 59 + ($subInstanceId == null ? 43 : ((Object)$subInstanceId).hashCode());
        Long $instanceId = this.getInstanceId();
        result = result * 59 + ($instanceId == null ? 43 : ((Object)$instanceId).hashCode());
        String $taskName = this.getTaskName();
        result = result * 59 + ($taskName == null ? 43 : $taskName.hashCode());
        String $address = this.getAddress();
        result = result * 59 + ($address == null ? 43 : $address.hashCode());
        Integer $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : ((Object)$status).hashCode());
        String $queryContent = this.getQueryContent();
        result = result * 59 + ($queryContent == null ? 43 : $queryContent.hashCode());
        String $queryCondition = this.getQueryCondition();
        result = result * 59 + ($queryCondition == null ? 43 : $queryCondition.hashCode());
        String $otherCondition = this.getOtherCondition();
        result = result * 59 + ($otherCondition == null ? 43 : $otherCondition.hashCode());
        Integer $limit = this.getLimit();
        result = result * 59 + ($limit == null ? 43 : ((Object)$limit).hashCode());
        String $fullCustomQueryCondition = this.getFullCustomQueryCondition();
        result = result * 59 + ($fullCustomQueryCondition == null ? 43 : $fullCustomQueryCondition.hashCode());
        result = result * 59 + (this.isReadOnly() ? 79 : 97);
        return result;
    }

    public String toString() {
        return "SimpleTaskQuery(taskId=" + this.getTaskId() + ", taskIds=" + this.getTaskIds() + ", subInstanceId=" + this.getSubInstanceId() + ", instanceId=" + this.getInstanceId() + ", taskName=" + this.getTaskName() + ", address=" + this.getAddress() + ", status=" + this.getStatus() + ", queryContent=" + this.getQueryContent() + ", queryCondition=" + this.getQueryCondition() + ", otherCondition=" + this.getOtherCondition() + ", limit=" + this.getLimit() + ", fullCustomQueryCondition=" + this.getFullCustomQueryCondition() + ", readOnly=" + this.isReadOnly() + ")";
    }
}

