/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.tools.view.context;

import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.tools.view.context.ToolboxContext;
import org.apache.velocity.tools.view.context.ViewContext;

public class ChainedContext
extends VelocityContext
implements ViewContext {
    private HttpServletRequest request;
    private HttpServletResponse response;
    private HttpSession session;
    private ServletContext application;
    private ToolboxContext toolboxContext = null;
    public static final String REQUEST = "request";
    public static final String RESPONSE = "response";
    public static final String SESSION = "session";
    public static final String APPLICATION = "application";

    public ChainedContext(Context ctx, HttpServletRequest request, HttpServletResponse response, ServletContext application) {
        super(null, ctx);
        this.request = request;
        this.response = response;
        this.session = request.getSession(false);
        this.application = application;
    }

    public void setToolbox(ToolboxContext box) {
        this.toolboxContext = box;
        this.session = this.request.getSession(false);
    }

    public Object internalGet(String key) {
        Object o = null;
        if (this.toolboxContext != null && (o = this.toolboxContext.get(key)) != null) {
            return o;
        }
        if (key.equals(REQUEST)) {
            return this.request;
        }
        if (key.equals(RESPONSE)) {
            return this.response;
        }
        if (key.equals(SESSION)) {
            return this.session;
        }
        if (key.equals(APPLICATION)) {
            return this.application;
        }
        o = super.internalGet(key);
        if (o != null) {
            return o;
        }
        o = this.request.getAttribute(key);
        if (o == null) {
            if (this.session != null) {
                o = this.session.getAttribute(key);
            }
            if (o == null) {
                o = this.application.getAttribute(key);
            }
        }
        return o;
    }

    public HttpServletRequest getRequest() {
        return this.request;
    }

    public HttpServletResponse getResponse() {
        return this.response;
    }

    public ServletContext getServletContext() {
        return this.application;
    }

    public Context getVelocityContext() {
        return this;
    }
}

