/*
 * Decompiled with CFR 0.152.
 */
package cn.afterturn.easypoi.wps.service;

public class EasyPoiWpsFileUtil {
    private static String[] OFFICE = new String[]{"word", "excel", "ppt"};
    private static String[] EXCEL_EXTS = new String[]{"et", "xls", "xlt", "xlsx", "xlsm", "xltx", "xltm", "csv"};
    private static String[] WORD_EXTS = new String[]{"doc", "docx", "txt", "dot", "wps", "wpt", "dotx", "docm", "dotm"};
    private static String[] PPT_EXTS = new String[]{"ppt", "pptx", "pptm", "pptm", "ppsm", "pps", "potx", "potm", "dpt", "dps"};
    private static String[] PDF_EXTS = new String[]{"pdf"};

    public static String getFileTypeCode(String fileType) {
        for (String et : EXCEL_EXTS) {
            if (!et.equalsIgnoreCase(fileType)) continue;
            return "s";
        }
        for (String et : WORD_EXTS) {
            if (!et.equalsIgnoreCase(fileType)) continue;
            return "w";
        }
        for (String et : PPT_EXTS) {
            if (!et.equalsIgnoreCase(fileType)) continue;
            return "p";
        }
        for (String et : PDF_EXTS) {
            if (!et.equalsIgnoreCase(fileType)) continue;
            return "f";
        }
        return null;
    }

    public static boolean checkCode(String fileType) {
        for (String et : OFFICE) {
            if (!et.equalsIgnoreCase(fileType)) continue;
            return true;
        }
        return false;
    }

    public static String getTypeCode(String fileType) {
        if ("word".equalsIgnoreCase(fileType)) {
            return "w";
        }
        if ("excel".equalsIgnoreCase(fileType)) {
            return "s";
        }
        if ("ppt".equalsIgnoreCase(fileType)) {
            return "p";
        }
        return null;
    }

    public static String getFileName(String filePath) {
        String[] pathArr = filePath.split("/");
        String fileName = pathArr.length > 1 ? pathArr[pathArr.length - 1] : filePath;
        return fileName;
    }

    public static String getFileTypeByPath(String filePath) {
        String fileName = EasyPoiWpsFileUtil.getFileName(filePath);
        String[] arr = fileName.split("\\.");
        return arr[arr.length - 1];
    }

    public static String getFileTypeByName(String fileName) {
        String[] arr = fileName.split("\\.");
        return arr[arr.length - 1];
    }
}

