/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastjson2.support.redission;

import com.alibaba.fastjson2.JSONException;
import com.alibaba.fastjson2.JSONFactory;
import com.alibaba.fastjson2.JSONObject;
import com.alibaba.fastjson2.JSONReader;
import com.alibaba.fastjson2.JSONWriter;
import com.alibaba.fastjson2.writer.ObjectWriter;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.redisson.client.codec.BaseCodec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.Encoder;

public class JSONCodec
extends BaseCodec {
    final JSONEncoder encoder;
    final JSONDecoder decoder;

    public JSONCodec(Type type) {
        this(JSONFactory.createWriteContext(), JSONFactory.createReadContext(), type, StandardCharsets.UTF_8);
    }

    public JSONCodec(Type type, Charset charset) {
        this(JSONFactory.createWriteContext(), JSONFactory.createReadContext(), type, charset);
    }

    public JSONCodec(JSONWriter.Context writerContext, JSONReader.Context readerContext) {
        this(writerContext, readerContext, null, StandardCharsets.UTF_8);
    }

    public JSONCodec(JSONWriter.Context writerContext, JSONReader.Context readerContext, Charset charset) {
        this(writerContext, readerContext, null, charset);
    }

    public JSONCodec(JSONWriter.Context writerContext, JSONReader.Context readerContext, Type valueType, Charset charset) {
        this(new JSONEncoder(writerContext, charset), new JSONDecoder(valueType, charset, readerContext));
    }

    public JSONCodec(JSONEncoder encoder, JSONDecoder decoder) {
        this.encoder = encoder;
        this.decoder = decoder;
    }

    @Override
    public Decoder<Object> getValueDecoder() {
        return this.decoder;
    }

    @Override
    public Encoder getValueEncoder() {
        return this.encoder;
    }

    public static class JSONEncoder
    implements Encoder {
        final JSONWriter.Context context;
        final Charset charset;

        public JSONEncoder() {
            this(new JSONWriter.Context(new JSONWriter.Feature[0]));
        }

        public JSONEncoder(JSONWriter.Context context) {
            this(context, StandardCharsets.UTF_8);
        }

        public JSONEncoder(JSONWriter.Context context, Charset charset) {
            this.context = context;
            this.charset = charset;
        }

        @Override
        public ByteBuf encode(Object object) throws IOException {
            JSONWriter writer = JSONWriter.of(this.context);
            try {
                if (object == null) {
                    writer.writeNull();
                } else {
                    writer.setRootObject(object);
                    Class<?> valueClass = object.getClass();
                    if (valueClass == JSONObject.class && this.context.getFeatures() == 0L) {
                        writer.write((JSONObject)object);
                    } else {
                        ObjectWriter<?> objectWriter = this.context.getObjectWriter(valueClass, valueClass);
                        objectWriter.write(writer, object, null, null, 0L);
                    }
                }
                int size = writer.size();
                if (!this.context.isEnabled(JSONWriter.Feature.OptimizedForAscii)) {
                    size <<= 2;
                }
                ByteBuf out = ByteBufAllocator.DEFAULT.buffer(size);
                ByteBufOutputStream baos = new ByteBufOutputStream(out);
                writer.flushTo(baos, this.charset);
                ByteBuf byteBuf = baos.buffer();
                if (writer != null) {
                    writer.close();
                }
                return byteBuf;
            }
            catch (Throwable throwable) {
                try {
                    if (writer != null) {
                        try {
                            writer.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (NullPointerException | NumberFormatException e) {
                    throw new JSONException("JSON#toJSONString cannot serialize '" + object + "'", e);
                }
            }
        }
    }

    public static class JSONDecoder
    implements Decoder<Object> {
        final Type valueType;
        final Charset charset;
        final JSONReader.Context context;

        public JSONDecoder(Type valueType) {
            this(valueType, JSONFactory.createReadContext());
        }

        public JSONDecoder(Type valueType, JSONReader.Context context) {
            this(valueType, StandardCharsets.UTF_8, context);
        }

        public JSONDecoder(Type valueType, Charset charset, JSONReader.Context context) {
            this.valueType = valueType;
            this.charset = charset;
            this.context = context;
        }

        @Override
        public Object decode(ByteBuf buf, State state) throws IOException {
            Object value;
            try (JSONReader jsonReader = JSONReader.of(new ByteBufInputStream(buf), this.charset, this.context);){
                value = this.valueType == null || this.valueType == Object.class ? jsonReader.readAny() : jsonReader.read(this.valueType);
            }
            return value;
        }
    }
}

