/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.client.protocol.decoder;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.redisson.client.codec.Codec;
import org.redisson.client.handler.State;
import org.redisson.client.protocol.Decoder;
import org.redisson.client.protocol.decoder.MultiDecoder;

public class ObjectMapReplayDecoder<K, V>
implements MultiDecoder<Map<K, V>> {
    private boolean swapKeyValue;
    private final Codec codec;

    public ObjectMapReplayDecoder(Codec codec) {
        this.codec = codec;
    }

    public ObjectMapReplayDecoder() {
        this(null);
    }

    public ObjectMapReplayDecoder(boolean swapKeyValue, Codec codec) {
        this.swapKeyValue = swapKeyValue;
        this.codec = codec;
    }

    @Override
    public Decoder<Object> getDecoder(Codec codec, int paramNum, State state) {
        Codec c = Optional.ofNullable(this.codec).orElse(codec);
        if (paramNum % 2 != 0) {
            return c.getMapValueDecoder();
        }
        return c.getMapKeyDecoder();
    }

    @Override
    public Map<K, V> decode(List<Object> parts, State state) {
        LinkedHashMap<Object, Object> result = MultiDecoder.newLinkedHashMap(parts.size() / 2);
        for (int i = 0; i < parts.size(); ++i) {
            if (i % 2 == 0) continue;
            if (this.swapKeyValue) {
                result.put(parts.get(i), parts.get(i - 1));
                continue;
            }
            result.put(parts.get(i - 1), parts.get(i));
        }
        return result;
    }
}

