/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.connection;

import org.redisson.config.MasterSlaveServersConfig;
import org.redisson.config.ReadMode;
import org.redisson.config.SingleServerConfig;
import org.redisson.config.SubscriptionMode;
import org.redisson.connection.MasterSlaveConnectionManager;
import org.redisson.connection.ServiceManager;

public class SingleConnectionManager
extends MasterSlaveConnectionManager {
    public SingleConnectionManager(SingleServerConfig cfg, ServiceManager serviceManager) {
        super(SingleConnectionManager.create(cfg), serviceManager);
    }

    private static MasterSlaveServersConfig create(SingleServerConfig cfg) {
        MasterSlaveServersConfig newconfig = new MasterSlaveServersConfig();
        newconfig.setPingConnectionInterval(cfg.getPingConnectionInterval());
        newconfig.setSslEnableEndpointIdentification(cfg.isSslEnableEndpointIdentification());
        newconfig.setSslProvider(cfg.getSslProvider());
        newconfig.setSslTruststore(cfg.getSslTruststore());
        newconfig.setSslTruststorePassword(cfg.getSslTruststorePassword());
        newconfig.setSslKeystore(cfg.getSslKeystore());
        newconfig.setSslKeystorePassword(cfg.getSslKeystorePassword());
        newconfig.setSslProtocols(cfg.getSslProtocols());
        newconfig.setSslCiphers(cfg.getSslCiphers());
        newconfig.setSslKeyManagerFactory(cfg.getSslKeyManagerFactory());
        newconfig.setSslTrustManagerFactory(cfg.getSslTrustManagerFactory());
        newconfig.setRetryAttempts(cfg.getRetryAttempts());
        newconfig.setRetryInterval(cfg.getRetryInterval());
        newconfig.setTimeout(cfg.getTimeout());
        newconfig.setPassword(cfg.getPassword());
        newconfig.setUsername(cfg.getUsername());
        newconfig.setDatabase(cfg.getDatabase());
        newconfig.setClientName(cfg.getClientName());
        newconfig.setMasterAddress(cfg.getAddress());
        newconfig.setMasterConnectionPoolSize(cfg.getConnectionPoolSize());
        newconfig.setSubscriptionsPerConnection(cfg.getSubscriptionsPerConnection());
        newconfig.setSubscriptionConnectionPoolSize(cfg.getSubscriptionConnectionPoolSize());
        newconfig.setConnectTimeout(cfg.getConnectTimeout());
        newconfig.setIdleConnectionTimeout(cfg.getIdleConnectionTimeout());
        newconfig.setDnsMonitoringInterval(cfg.getDnsMonitoringInterval());
        newconfig.setMasterConnectionMinimumIdleSize(cfg.getConnectionMinimumIdleSize());
        newconfig.setSubscriptionConnectionMinimumIdleSize(cfg.getSubscriptionConnectionMinimumIdleSize());
        newconfig.setReadMode(ReadMode.MASTER);
        newconfig.setSubscriptionMode(SubscriptionMode.MASTER);
        newconfig.setKeepAlive(cfg.isKeepAlive());
        newconfig.setTcpKeepAliveCount(cfg.getTcpKeepAliveCount());
        newconfig.setTcpKeepAliveIdle(cfg.getTcpKeepAliveIdle());
        newconfig.setTcpKeepAliveInterval(cfg.getTcpKeepAliveInterval());
        newconfig.setTcpUserTimeout(cfg.getTcpUserTimeout());
        newconfig.setTcpNoDelay(cfg.isTcpNoDelay());
        newconfig.setNameMapper(cfg.getNameMapper());
        newconfig.setCredentialsResolver(cfg.getCredentialsResolver());
        newconfig.setCommandMapper(cfg.getCommandMapper());
        newconfig.setSubscriptionTimeout(cfg.getSubscriptionTimeout());
        return newconfig;
    }
}

