/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.cache;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.binder.cache.CacheMeterBinder;
import org.redisson.spring.cache.RedissonCache;

public class RedissonCacheMetrics
extends CacheMeterBinder {
    private final RedissonCache cache;

    public RedissonCacheMetrics(RedissonCache cache, Iterable<Tag> tags) {
        super(cache, cache.getName(), tags);
        this.cache = cache;
    }

    public static RedissonCache monitor(MeterRegistry registry, RedissonCache cache, Iterable<Tag> tags) {
        new RedissonCacheMetrics(cache, tags).bindTo(registry);
        return cache;
    }

    @Override
    protected Long size() {
        return this.cache.getNativeCache().size();
    }

    @Override
    protected long hitCount() {
        return this.cache.getCacheHits();
    }

    @Override
    protected Long missCount() {
        return this.cache.getCacheMisses();
    }

    @Override
    protected Long evictionCount() {
        return this.cache.getCacheEvictions();
    }

    @Override
    protected long putCount() {
        return this.cache.getCachePuts();
    }

    @Override
    protected void bindImplementationSpecificMetrics(MeterRegistry registry) {
    }
}

