/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.util.ArrayList;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.data.redis.connection.ReactiveHyperLogLogCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.util.Assert;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveHyperLogLogCommands
extends RedissonBaseReactive
implements ReactiveHyperLogLogCommands {
    private static final RedisCommand<Long> PFADD = new RedisCommand("PFADD");
    private static final RedisStrictCommand<String> PFMERGE = new RedisStrictCommand("PFMERGE");

    RedissonReactiveHyperLogLogCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHyperLogLogCommands.PfAddCommand, Long>> pfAdd(Publisher<ReactiveHyperLogLogCommands.PfAddCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notEmpty(command.getValues(), "Values must not be empty!");
            byte[] keyBuf = RedissonReactiveHyperLogLogCommands.toByteArray(command.getKey());
            ArrayList<byte[]> params = new ArrayList<byte[]>(command.getValues().size() + 1);
            params.add(keyBuf);
            params.addAll(command.getValues().stream().map(v -> RedissonReactiveHyperLogLogCommands.toByteArray(v)).collect(Collectors.toList()));
            Mono<Long> m = this.write(keyBuf, StringCodec.INSTANCE, PFADD, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveHyperLogLogCommands.PfAddCommand, Long>((ReactiveHyperLogLogCommands.PfAddCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveHyperLogLogCommands.PfCountCommand, Long>> pfCount(Publisher<ReactiveHyperLogLogCommands.PfCountCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notEmpty(command.getKeys(), "Keys must not be empty!");
            Object[] args = command.getKeys().stream().map(v -> RedissonReactiveHyperLogLogCommands.toByteArray(v)).toArray();
            Mono<Long> m = this.write((byte[])args[0], StringCodec.INSTANCE, RedisCommands.PFCOUNT, args);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveHyperLogLogCommands.PfCountCommand, Long>((ReactiveHyperLogLogCommands.PfCountCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveHyperLogLogCommands.PfMergeCommand>> pfMerge(Publisher<ReactiveHyperLogLogCommands.PfMergeCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Destination key must not be null!");
            Assert.notEmpty(command.getSourceKeys(), "Source keys must not be null!");
            byte[] keyBuf = RedissonReactiveHyperLogLogCommands.toByteArray(command.getKey());
            ArrayList<byte[]> args = new ArrayList<byte[]>(command.getSourceKeys().size() + 1);
            args.add(keyBuf);
            args.addAll(command.getSourceKeys().stream().map(v -> RedissonReactiveHyperLogLogCommands.toByteArray(v)).collect(Collectors.toList()));
            Mono<String> m = this.write(keyBuf, StringCodec.INSTANCE, PFMERGE, args.toArray());
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveHyperLogLogCommands.PfMergeCommand>((ReactiveHyperLogLogCommands.PfMergeCommand)command, true));
        });
    }
}

