/*
 * Decompiled with CFR 0.152.
 */
package org.redisson.spring.data.connection;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import org.redisson.client.codec.ByteArrayCodec;
import org.redisson.client.codec.StringCodec;
import org.redisson.client.protocol.RedisCommand;
import org.redisson.client.protocol.RedisCommands;
import org.redisson.client.protocol.RedisStrictCommand;
import org.redisson.reactive.CommandReactiveExecutor;
import org.redisson.spring.data.connection.RedissonBaseReactive;
import org.springframework.dao.InvalidDataAccessApiUsageException;
import org.springframework.data.redis.connection.ReactiveListCommands;
import org.springframework.data.redis.connection.ReactiveRedisConnection;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class RedissonReactiveListCommands
extends RedissonBaseReactive
implements ReactiveListCommands {
    private static final RedisStrictCommand<Long> RPUSH = new RedisStrictCommand("RPUSH");
    private static final RedisStrictCommand<Long> LPUSH = new RedisStrictCommand("LPUSH");
    private static final RedisStrictCommand<Long> RPUSHX = new RedisStrictCommand("RPUSHX");
    private static final RedisStrictCommand<Long> LPUSHX = new RedisStrictCommand("LPUSHX");
    private static final RedisStrictCommand<Long> LLEN = new RedisStrictCommand("LLEN");
    private static final RedisStrictCommand<String> LTRIM = new RedisStrictCommand("LTRIM");
    private static final RedisStrictCommand<Long> LINSERT = new RedisStrictCommand("LINSERT");
    private static final RedisStrictCommand<String> LSET = new RedisStrictCommand("LSET");
    private static final RedisStrictCommand<Long> LREM = new RedisStrictCommand("LREM");

    RedissonReactiveListCommands(CommandReactiveExecutor executorService) {
        super(executorService);
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveListCommands.PushCommand, Long>> push(Publisher<ReactiveListCommands.PushCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notEmpty(command.getValues(), "Values must not be null or empty!");
            if (!command.getUpsert() && command.getValues().size() > 1) {
                throw new InvalidDataAccessApiUsageException(String.format("%s PUSHX only allows one value!", new Object[]{command.getDirection()}));
            }
            ArrayList<byte[]> params = new ArrayList<byte[]>();
            params.add(RedissonReactiveListCommands.toByteArray(command.getKey()));
            params.addAll(command.getValues().stream().map(v -> RedissonReactiveListCommands.toByteArray(v)).collect(Collectors.toList()));
            RedisStrictCommand<Long> redisCommand = ObjectUtils.nullSafeEquals((Object)ReactiveListCommands.Direction.RIGHT, (Object)command.getDirection()) ? (command.getUpsert() ? RPUSH : RPUSHX) : (command.getUpsert() ? LPUSH : LPUSHX);
            Mono<Long> m = this.write((byte[])params.get(0), StringCodec.INSTANCE, redisCommand, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveListCommands.PushCommand, Long>((ReactiveListCommands.PushCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>> lLen(Publisher<ReactiveRedisConnection.KeyCommand> commands) {
        return this.execute(commands, key -> {
            Assert.notNull((Object)key.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(key.getKey());
            Mono<Long> m = this.read(keyBuf, StringCodec.INSTANCE, LLEN, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveRedisConnection.KeyCommand, Long>((ReactiveRedisConnection.KeyCommand)key, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.RangeCommand, Flux<ByteBuffer>>> lRange(Publisher<ReactiveRedisConnection.RangeCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getRange(), "Range must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            Mono<List> m = this.read(keyBuf, ByteArrayCodec.INSTANCE, RedisCommands.LRANGE, keyBuf, command.getRange().getLowerBound().getValue().orElse(0L), command.getRange().getUpperBound().getValue().orElse(-1L));
            return m.map(v -> new ReactiveRedisConnection.CommandResponse<ReactiveRedisConnection.RangeCommand, Flux<ByteBuffer>>((ReactiveRedisConnection.RangeCommand)command, Flux.fromIterable(v).map(e -> ByteBuffer.wrap(e))));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.RangeCommand>> lTrim(Publisher<ReactiveRedisConnection.RangeCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull(command.getRange(), "Range must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            Mono<String> m = this.write(keyBuf, StringCodec.INSTANCE, LTRIM, keyBuf, command.getRange().getLowerBound().getValue().orElse(0L), command.getRange().getUpperBound().getValue().orElse(-1L));
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveRedisConnection.RangeCommand>((ReactiveRedisConnection.RangeCommand)command, true));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.LIndexCommand>> lIndex(Publisher<ReactiveListCommands.LIndexCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getIndex(), "Index value must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            Mono<byte[]> m = this.read(keyBuf, ByteArrayCodec.INSTANCE, RedisCommands.LINDEX, keyBuf, command.getIndex());
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.LIndexCommand>((ReactiveListCommands.LIndexCommand)command, ByteBuffer.wrap(v)));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveListCommands.LInsertCommand, Long>> lInsert(Publisher<ReactiveListCommands.LInsertCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getValue(), "Value must not be null!");
            Assert.notNull((Object)command.getPivot(), "Pivot must not be null!");
            Assert.notNull((Object)command.getPosition(), "Position must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveListCommands.toByteArray(command.getValue());
            byte[] pivotBuf = RedissonReactiveListCommands.toByteArray(command.getPivot());
            Mono<Long> m = this.write(keyBuf, StringCodec.INSTANCE, LINSERT, new Object[]{keyBuf, command.getPosition(), pivotBuf, valueBuf});
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveListCommands.LInsertCommand, Long>((ReactiveListCommands.LInsertCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.BooleanResponse<ReactiveListCommands.LSetCommand>> lSet(Publisher<ReactiveListCommands.LSetCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getValue(), "value must not be null!");
            Assert.notNull((Object)command.getIndex(), "Index must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveListCommands.toByteArray(command.getValue());
            Mono<String> m = this.write(keyBuf, StringCodec.INSTANCE, LSET, keyBuf, command.getIndex(), valueBuf);
            return m.map(v -> new ReactiveRedisConnection.BooleanResponse<ReactiveListCommands.LSetCommand>((ReactiveListCommands.LSetCommand)command, true));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveListCommands.LRemCommand, Long>> lRem(Publisher<ReactiveListCommands.LRemCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getValue(), "Value must not be null!");
            Assert.notNull((Object)command.getCount(), "Count must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            byte[] valueBuf = RedissonReactiveListCommands.toByteArray(command.getValue());
            Mono<Long> m = this.write(keyBuf, StringCodec.INSTANCE, LREM, keyBuf, command.getCount(), valueBuf);
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveListCommands.LRemCommand, Long>((ReactiveListCommands.LRemCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.PopCommand>> pop(Publisher<ReactiveListCommands.PopCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getDirection(), "Direction must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            RedisCommand<Object> redisCommand = RedisCommands.LPOP;
            if (command.getDirection() == ReactiveListCommands.Direction.RIGHT) {
                redisCommand = RedisCommands.RPOP;
            }
            Mono<byte[]> m = this.write(keyBuf, ByteArrayCodec.INSTANCE, redisCommand, new Object[]{keyBuf});
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.PopCommand>((ReactiveListCommands.PopCommand)command, ByteBuffer.wrap(v)));
        });
    }

    @Override
    public Flux<ReactiveListCommands.PopResponse> bPop(Publisher<ReactiveListCommands.BPopCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull(command.getKeys(), "Keys must not be null!");
            Assert.notNull((Object)command.getDirection(), "Direction must not be null!");
            Assert.notNull((Object)command.getTimeout(), "Timeout must not be null!");
            RedisCommand<List<Object>> redisCommand = RedisCommands.BLPOP;
            if (command.getDirection() == ReactiveListCommands.Direction.RIGHT) {
                redisCommand = RedisCommands.BRPOP;
            }
            ArrayList<Long> params = new ArrayList<Long>(command.getKeys().size() + 1);
            params.addAll(command.getKeys().stream().map(v -> RedissonReactiveListCommands.toByteArray(v)).collect(Collectors.toList()));
            params.add(command.getTimeout().getSeconds());
            Mono<List> m = this.write((byte[])params.get(0), ByteArrayCodec.INSTANCE, redisCommand, params.toArray());
            return m.map(v -> new ReactiveListCommands.PopResponse((ReactiveListCommands.BPopCommand)command, new ReactiveListCommands.PopResult(v.stream().map(e -> ByteBuffer.wrap(e)).collect(Collectors.toList()))));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.RPopLPushCommand>> rPopLPush(Publisher<ReactiveListCommands.RPopLPushCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getDestination(), "Destination key must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            byte[] destinationBuf = RedissonReactiveListCommands.toByteArray(command.getDestination());
            Mono<byte[]> m = this.write(keyBuf, ByteArrayCodec.INSTANCE, RedisCommands.RPOPLPUSH, keyBuf, destinationBuf);
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.RPopLPushCommand>((ReactiveListCommands.RPopLPushCommand)command, ByteBuffer.wrap(v)));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.BRPopLPushCommand>> bRPopLPush(Publisher<ReactiveListCommands.BRPopLPushCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getDestination(), "Destination key must not be null!");
            Assert.notNull((Object)command.getTimeout(), "Timeout must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            byte[] destinationBuf = RedissonReactiveListCommands.toByteArray(command.getDestination());
            Mono<byte[]> m = this.write(keyBuf, ByteArrayCodec.INSTANCE, RedisCommands.BRPOPLPUSH, keyBuf, destinationBuf, command.getTimeout().getSeconds());
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.BRPopLPushCommand>((ReactiveListCommands.BRPopLPushCommand)command, ByteBuffer.wrap(v)));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.NumericResponse<ReactiveListCommands.LPosCommand, Long>> lPos(Publisher<ReactiveListCommands.LPosCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getElement(), "Element must not be null!");
            ArrayList<Object> params = new ArrayList<Object>();
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            params.add(keyBuf);
            params.add(RedissonReactiveListCommands.toByteArray(command.getElement()));
            if (command.getRank() != null) {
                params.add("RANK");
                params.add(command.getRank());
            }
            if (command.getCount() != null) {
                params.add("COUNT");
                params.add(command.getCount());
            }
            Mono<Long> m = this.read(keyBuf, ByteArrayCodec.INSTANCE, RedisCommands.LPOS, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.NumericResponse<ReactiveListCommands.LPosCommand, Long>((ReactiveListCommands.LPosCommand)command, (Long)v));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.LMoveCommand>> lMove(Publisher<? extends ReactiveListCommands.LMoveCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getDestinationKey(), "Destination key must not be null!");
            Assert.notNull((Object)command.getFrom(), "From must not be null!");
            Assert.notNull((Object)command.getTo(), "To must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            byte[] destinationBuf = RedissonReactiveListCommands.toByteArray(command.getDestinationKey());
            Mono<byte[]> m = this.write(keyBuf, ByteArrayCodec.INSTANCE, RedisCommands.LMOVE, new Object[]{keyBuf, destinationBuf, command.getFrom(), command.getTo()});
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.LMoveCommand>((ReactiveListCommands.LMoveCommand)command, ByteBuffer.wrap(v)));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.BLMoveCommand>> bLMove(Publisher<ReactiveListCommands.BLMoveCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            Assert.notNull((Object)command.getDestinationKey(), "Destination key must not be null!");
            Assert.notNull((Object)command.getFrom(), "From must not be null!");
            Assert.notNull((Object)command.getTo(), "To must not be null!");
            Assert.notNull((Object)command.getTimeout(), "Timeout must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            byte[] destinationBuf = RedissonReactiveListCommands.toByteArray(command.getDestinationKey());
            Mono<byte[]> m = this.write(keyBuf, ByteArrayCodec.INSTANCE, RedisCommands.BLMOVE, new Object[]{keyBuf, destinationBuf, command.getFrom(), command.getTo(), command.getTimeout().getSeconds()});
            return m.map(v -> new ReactiveRedisConnection.ByteBufferResponse<ReactiveListCommands.BLMoveCommand>((ReactiveListCommands.BLMoveCommand)command, ByteBuffer.wrap(v)));
        });
    }

    @Override
    public Flux<ReactiveRedisConnection.CommandResponse<ReactiveListCommands.PopCommand, Flux<ByteBuffer>>> popList(Publisher<ReactiveListCommands.PopCommand> commands) {
        return this.execute(commands, command -> {
            Assert.notNull((Object)command.getKey(), "Key must not be null!");
            byte[] keyBuf = RedissonReactiveListCommands.toByteArray(command.getKey());
            RedisCommand<List<Object>> cmd = command.getDirection() == ReactiveListCommands.Direction.RIGHT ? RedisCommands.RPOP_LIST : RedisCommands.LPOP_LIST;
            ArrayList<Object> params = new ArrayList<Object>(2);
            params.add(keyBuf);
            if (command.getCount() > 0L) {
                params.add(command.getCount());
            }
            Mono<List> m = this.write(keyBuf, ByteArrayCodec.INSTANCE, cmd, params.toArray());
            return m.map(v -> new ReactiveRedisConnection.CommandResponse<ReactiveListCommands.PopCommand, Flux<ByteBuffer>>((ReactiveListCommands.PopCommand)command, Flux.fromIterable(v).map(e -> ByteBuffer.wrap(e))));
        });
    }
}

