/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics;

import io.micrometer.core.instrument.Meter;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.convert.DurationStyle;

public final class MeterValue {
    private final Object value;

    MeterValue(double value) {
        this.value = value;
    }

    MeterValue(Duration value) {
        this.value = value;
    }

    public Double getValue(Meter.Type meterType) {
        Long timerValue;
        if (meterType == Meter.Type.DISTRIBUTION_SUMMARY) {
            return this.getDistributionSummaryValue();
        }
        if (meterType == Meter.Type.TIMER && (timerValue = this.getTimerValue()) != null) {
            return timerValue.doubleValue();
        }
        return null;
    }

    private Double getDistributionSummaryValue() {
        if (this.value instanceof Double) {
            return (Double)this.value;
        }
        return null;
    }

    private Long getTimerValue() {
        if (this.value instanceof Double) {
            return TimeUnit.MILLISECONDS.toNanos(((Double)this.value).longValue());
        }
        if (this.value instanceof Duration) {
            return ((Duration)this.value).toNanos();
        }
        return null;
    }

    public static MeterValue valueOf(String value) {
        Duration duration = MeterValue.safeParseDuration(value);
        if (duration != null) {
            return new MeterValue(duration);
        }
        return new MeterValue(Double.valueOf(value));
    }

    public static MeterValue valueOf(double value) {
        return new MeterValue(value);
    }

    private static Duration safeParseDuration(String value) {
        try {
            return DurationStyle.detectAndParse(value);
        }
        catch (IllegalArgumentException ex) {
            return null;
        }
    }
}

