/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.autoconfigure.metrics.data;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.actuate.metrics.data.MetricsRepositoryMethodInvocationListener;
import org.springframework.data.repository.core.support.RepositoryFactoryBeanSupport;
import org.springframework.data.repository.core.support.RepositoryFactoryCustomizer;
import org.springframework.data.repository.core.support.RepositoryFactorySupport;
import org.springframework.util.function.SingletonSupplier;

class MetricsRepositoryMethodInvocationListenerBeanPostProcessor
implements BeanPostProcessor {
    private final RepositoryFactoryCustomizer customizer;

    MetricsRepositoryMethodInvocationListenerBeanPostProcessor(SingletonSupplier<MetricsRepositoryMethodInvocationListener> listener) {
        this.customizer = new MetricsRepositoryFactoryCustomizer(listener);
    }

    @Override
    public Object postProcessBeforeInitialization(Object bean2, String beanName) throws BeansException {
        if (bean2 instanceof RepositoryFactoryBeanSupport) {
            ((RepositoryFactoryBeanSupport)bean2).addRepositoryFactoryCustomizer(this.customizer);
        }
        return bean2;
    }

    private static final class MetricsRepositoryFactoryCustomizer
    implements RepositoryFactoryCustomizer {
        private final SingletonSupplier<MetricsRepositoryMethodInvocationListener> listenerSupplier;

        private MetricsRepositoryFactoryCustomizer(SingletonSupplier<MetricsRepositoryMethodInvocationListener> listenerSupplier) {
            this.listenerSupplier = listenerSupplier;
        }

        @Override
        public void customize(RepositoryFactorySupport repositoryFactory) {
            repositoryFactory.addInvocationListener(this.listenerSupplier.get());
        }
    }
}

