/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.core;

import java.util.NoSuchElementException;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.dao.support.PersistenceExceptionTranslator;
import org.springframework.data.keyvalue.core.UncategorizedKeyValueException;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public class KeyValuePersistenceExceptionTranslator
implements PersistenceExceptionTranslator {
    @Override
    @Nullable
    public DataAccessException translateExceptionIfPossible(RuntimeException exception) {
        Assert.notNull((Object)exception, "Exception must not be null!");
        if (exception instanceof DataAccessException) {
            return (DataAccessException)exception;
        }
        if (exception instanceof NoSuchElementException || exception instanceof IndexOutOfBoundsException || exception instanceof IllegalStateException) {
            return new DataRetrievalFailureException(exception.getMessage(), exception);
        }
        if (exception.getClass().getName().startsWith("java")) {
            return new UncategorizedKeyValueException(exception.getMessage(), exception);
        }
        return null;
    }
}

