/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.keyvalue.repository.config;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.data.keyvalue.core.mapping.context.KeyValueMappingContext;
import org.springframework.data.keyvalue.repository.KeyValueRepository;
import org.springframework.data.keyvalue.repository.config.QueryCreatorType;
import org.springframework.data.keyvalue.repository.query.KeyValuePartTreeQuery;
import org.springframework.data.keyvalue.repository.query.SpelQueryCreator;
import org.springframework.data.keyvalue.repository.support.KeyValueRepositoryFactoryBean;
import org.springframework.data.repository.config.AnnotationRepositoryConfigurationSource;
import org.springframework.data.repository.config.RepositoryConfigurationExtensionSupport;
import org.springframework.data.repository.config.RepositoryConfigurationSource;
import org.springframework.lang.Nullable;
import org.springframework.util.CollectionUtils;

public abstract class KeyValueRepositoryConfigurationExtension
extends RepositoryConfigurationExtensionSupport {
    protected static final String MAPPING_CONTEXT_BEAN_NAME = "keyValueMappingContext";
    protected static final String KEY_VALUE_TEMPLATE_BEAN_REF_ATTRIBUTE = "keyValueTemplateRef";

    @Override
    public String getRepositoryFactoryBeanClassName() {
        return KeyValueRepositoryFactoryBean.class.getName();
    }

    @Override
    public String getModuleName() {
        return "KeyValue";
    }

    @Override
    protected String getModulePrefix() {
        return "keyvalue";
    }

    @Override
    protected Collection<Class<?>> getIdentifyingTypes() {
        return Collections.singleton(KeyValueRepository.class);
    }

    @Override
    public void postProcess(BeanDefinitionBuilder builder, AnnotationRepositoryConfigurationSource config) {
        AnnotationAttributes attributes = config.getAttributes();
        builder.addPropertyReference("keyValueOperations", attributes.getString(KEY_VALUE_TEMPLATE_BEAN_REF_ATTRIBUTE));
        builder.addPropertyValue("queryCreator", KeyValueRepositoryConfigurationExtension.getQueryCreatorType(config));
        builder.addPropertyValue("queryType", KeyValueRepositoryConfigurationExtension.getQueryType(config));
        builder.addPropertyReference("mappingContext", this.getMappingContextBeanRef());
    }

    private static Class<?> getQueryCreatorType(AnnotationRepositoryConfigurationSource config) {
        AnnotationMetadata metadata = config.getEnableAnnotationMetadata();
        Map<String, Object> queryCreatorAnnotationAttributes = metadata.getAnnotationAttributes(QueryCreatorType.class.getName());
        if (CollectionUtils.isEmpty(queryCreatorAnnotationAttributes)) {
            return SpelQueryCreator.class;
        }
        AnnotationAttributes queryCreatorAttributes = new AnnotationAttributes(queryCreatorAnnotationAttributes);
        return queryCreatorAttributes.getClass("value");
    }

    private static Class<?> getQueryType(AnnotationRepositoryConfigurationSource config) {
        AnnotationMetadata metadata = config.getEnableAnnotationMetadata();
        Map<String, Object> queryCreatorAnnotationAttributes = metadata.getAnnotationAttributes(QueryCreatorType.class.getName());
        if (queryCreatorAnnotationAttributes == null) {
            return KeyValuePartTreeQuery.class;
        }
        AnnotationAttributes queryCreatorAttributes = new AnnotationAttributes(queryCreatorAnnotationAttributes);
        return queryCreatorAttributes.getClass("repositoryQueryType");
    }

    @Override
    public void registerBeansForRoot(BeanDefinitionRegistry registry, RepositoryConfigurationSource configurationSource) {
        AbstractBeanDefinition beanDefinition;
        super.registerBeansForRoot(registry, configurationSource);
        KeyValueRepositoryConfigurationExtension.registerIfNotAlreadyRegistered(() -> {
            RootBeanDefinition definitionefinition = new RootBeanDefinition(KeyValueMappingContext.class);
            definitionefinition.setSource(configurationSource.getSource());
            return definitionefinition;
        }, registry, this.getMappingContextBeanRef(), configurationSource);
        Optional<String> keyValueTemplateName = configurationSource.getAttribute(KEY_VALUE_TEMPLATE_BEAN_REF_ATTRIBUTE);
        if (keyValueTemplateName.isPresent() && this.getDefaultKeyValueTemplateRef().equals(keyValueTemplateName.get()) && !registry.containsBeanDefinition(keyValueTemplateName.get()) && (beanDefinition = this.getDefaultKeyValueTemplateBeanDefinition(configurationSource)) != null) {
            KeyValueRepositoryConfigurationExtension.registerIfNotAlreadyRegistered(() -> beanDefinition, registry, keyValueTemplateName.get(), configurationSource.getSource());
        }
    }

    @Nullable
    protected AbstractBeanDefinition getDefaultKeyValueTemplateBeanDefinition(RepositoryConfigurationSource configurationSource) {
        return null;
    }

    protected abstract String getDefaultKeyValueTemplateRef();

    protected String getMappingContextBeanRef() {
        return MAPPING_CONTEXT_BEAN_NAME;
    }
}

