/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.redis.listener;

import org.springframework.data.redis.listener.Topic;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

public class ChannelTopic
implements Topic {
    private final String channelName;

    public ChannelTopic(String name) {
        Assert.notNull((Object)name, "Topic name must not be null!");
        this.channelName = name;
    }

    public static ChannelTopic of(String name) {
        return new ChannelTopic(name);
    }

    @Override
    public String getTopic() {
        return this.channelName;
    }

    public String toString() {
        return this.channelName;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ChannelTopic that = (ChannelTopic)o;
        return ObjectUtils.nullSafeEquals(this.channelName, that.channelName);
    }

    public int hashCode() {
        return ObjectUtils.nullSafeHashCode(this.channelName);
    }
}

