/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.aliyun.spring.boot.autoconfigure.oss;

import cn.javaer.aliyun.spring.boot.autoconfigure.oss.AliyunOssProperties;
import cn.javaer.aliyun.spring.boot.autoconfigure.oss.OssClientFactoryBean;
import com.aliyun.oss.OSSClient;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnClass(value={OSSClient.class})
@EnableConfigurationProperties(value={AliyunOssProperties.class})
public class AliyunOssAutoConfiguration {
    private final AliyunOssProperties aliyunOssProperties;

    public AliyunOssAutoConfiguration(AliyunOssProperties aliyunOssProperties) {
        this.aliyunOssProperties = aliyunOssProperties;
    }

    @Bean
    public OssClientFactoryBean ossClientFactoryBean() {
        OssClientFactoryBean factoryBean = new OssClientFactoryBean();
        factoryBean.setEndpoint(this.aliyunOssProperties.getEndpoint());
        factoryBean.setAccessKeyId(this.aliyunOssProperties.getAccessKeyId());
        factoryBean.setAccessKeySecret(this.aliyunOssProperties.getAccessKeySecret());
        return factoryBean;
    }
}

