/*
 * Decompiled with CFR 0.152.
 */
package cn.javaer.aliyun.spring.boot.autoconfigure.oss;

import com.aliyun.oss.OSSClient;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class OssClientFactoryBean
implements FactoryBean<OSSClient>,
InitializingBean,
DisposableBean {
    private OSSClient ossClient;
    private String endpoint;
    private String accessKeyId;
    private String accessKeySecret;

    public OSSClient getObject() throws Exception {
        return this.ossClient;
    }

    public Class<?> getObjectType() {
        return OSSClient.class;
    }

    public boolean isSingleton() {
        return true;
    }

    public void destroy() throws Exception {
        if (this.ossClient != null) {
            this.ossClient.shutdown();
        }
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.endpoint, (String)"'endpoint' must be not null");
        Assert.notNull((Object)this.accessKeyId, (String)"'accessKeyId' must be not null");
        Assert.notNull((Object)this.accessKeySecret, (String)"'accessKeySecret' must be not null");
        this.ossClient = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }
}

