/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api;

import cn.jpush.api.CustomMessageParams;
import cn.jpush.api.DeviceEnum;
import cn.jpush.api.MessageParams;
import cn.jpush.api.MessageResult;
import cn.jpush.api.NotifyMessageParams;
import cn.jpush.api.ReceiverTypeEnum;
import cn.jpush.api.receive.ReceiveManager;
import cn.jpush.api.receive.ReceiveResult;
import cn.jpush.http.BaseClient;
import cn.jpush.http.HttpClient;
import java.util.List;
import java.util.Map;

public class JPushClient
extends BaseClient {
    protected static HttpClient httpClient = new HttpClient();
    protected ReceiveManager receiveManager = new ReceiveManager();

    public JPushClient(String masterSecret, String appKey) {
        this.masterSecret = masterSecret;
        this.appKey = appKey;
        this.receiveManager.appKey = appKey;
        this.receiveManager.masterSecret = masterSecret;
    }

    public JPushClient(String masterSecret, String appKey, long timeToLive) {
        this.masterSecret = masterSecret;
        this.appKey = appKey;
        this.timeToLive = timeToLive;
        this.receiveManager.appKey = appKey;
        this.receiveManager.masterSecret = masterSecret;
    }

    public JPushClient(String masterSecret, String appKey, DeviceEnum device) {
        this.masterSecret = masterSecret;
        this.appKey = appKey;
        this.devices.add(device);
        this.receiveManager.appKey = appKey;
        this.receiveManager.masterSecret = masterSecret;
    }

    public JPushClient(String masterSecret, String appKey, long timeToLive, DeviceEnum device) {
        this.masterSecret = masterSecret;
        this.appKey = appKey;
        this.timeToLive = timeToLive;
        this.devices.add(device);
        this.receiveManager.appKey = appKey;
        this.receiveManager.masterSecret = masterSecret;
    }

    public MessageResult sendNotificationWithTag(int sendNo, String tag, String msgTitle, String msgContent) {
        NotifyMessageParams p = new NotifyMessageParams();
        p.setReceiverType(ReceiverTypeEnum.TAG);
        p.setReceiverValue(tag);
        return this.sendNotification(p, sendNo, msgTitle, msgContent, 0, null);
    }

    public MessageResult sendNotificationWithTag(int sendNo, String tag, String msgTitle, String msgContent, int builderId, Map<String, Object> extra) {
        NotifyMessageParams p = new NotifyMessageParams();
        p.setReceiverType(ReceiverTypeEnum.TAG);
        p.setReceiverValue(tag);
        return this.sendNotification(p, sendNo, msgTitle, msgContent, builderId, extra);
    }

    public MessageResult sendNotificationWithTag(int sendNo, String tag, String msgTitle, String msgContent, int builderId, Map<String, Object> extra, String overrideMsgId) {
        NotifyMessageParams p = new NotifyMessageParams();
        p.setReceiverType(ReceiverTypeEnum.TAG);
        p.setReceiverValue(tag);
        p.setOverrideMsgId(overrideMsgId);
        return this.sendNotification(p, sendNo, msgTitle, msgContent, builderId, extra);
    }

    public MessageResult sendCustomMessageWithTag(int sendNo, String tag, String msgTitle, String msgContent) {
        CustomMessageParams p = new CustomMessageParams();
        p.setReceiverType(ReceiverTypeEnum.TAG);
        p.setReceiverValue(tag);
        return this.sendCustomMessage(p, sendNo, msgTitle, msgContent, null, null);
    }

    public MessageResult sendCustomMessageWithTag(int sendNo, String tag, String msgTitle, String msgContent, String msgContentType, Map<String, Object> extra) {
        CustomMessageParams p = new CustomMessageParams();
        p.setReceiverType(ReceiverTypeEnum.TAG);
        p.setReceiverValue(tag);
        return this.sendCustomMessage(p, sendNo, msgTitle, msgContent, msgContentType, extra);
    }

    public MessageResult sendCustomMessageWithTag(int sendNo, String tag, String msgTitle, String msgContent, String msgContentType, Map<String, Object> extra, String overrideMsgId) {
        CustomMessageParams p = new CustomMessageParams();
        p.setReceiverType(ReceiverTypeEnum.TAG);
        p.setReceiverValue(tag);
        p.setOverrideMsgId(overrideMsgId);
        return this.sendCustomMessage(p, sendNo, msgTitle, msgContent, msgContentType, extra);
    }

    public MessageResult sendNotificationWithAlias(int sendNo, String alias, String msgTitle, String msgContent) {
        NotifyMessageParams p = new NotifyMessageParams();
        p.setReceiverType(ReceiverTypeEnum.ALIAS);
        p.setReceiverValue(alias);
        return this.sendNotification(p, sendNo, msgTitle, msgContent, 0, null);
    }

    public MessageResult sendNotificationWithAlias(int sendNo, String alias, String msgTitle, String msgContent, int builderId, Map<String, Object> extra) {
        NotifyMessageParams p = new NotifyMessageParams();
        p.setReceiverType(ReceiverTypeEnum.ALIAS);
        p.setReceiverValue(alias);
        return this.sendNotification(p, sendNo, msgTitle, msgContent, builderId, extra);
    }

    public MessageResult sendNotificationWithAlias(int sendNo, String alias, String msgTitle, String msgContent, int builderId, Map<String, Object> extra, String overrideMsgId) {
        NotifyMessageParams p = new NotifyMessageParams();
        p.setReceiverType(ReceiverTypeEnum.ALIAS);
        p.setReceiverValue(alias);
        p.setOverrideMsgId(overrideMsgId);
        return this.sendNotification(p, sendNo, msgTitle, msgContent, builderId, extra);
    }

    public MessageResult sendCustomMessageWithAlias(int sendNo, String alias, String msgTitle, String msgContent) {
        CustomMessageParams p = new CustomMessageParams();
        p.setReceiverType(ReceiverTypeEnum.ALIAS);
        p.setReceiverValue(alias);
        return this.sendCustomMessage(p, sendNo, msgTitle, msgContent, null, null);
    }

    public MessageResult sendCustomMessageWithAlias(int sendNo, String alias, String msgTitle, String msgContent, String msgContentType, Map<String, Object> extra) {
        CustomMessageParams p = new CustomMessageParams();
        p.setReceiverType(ReceiverTypeEnum.ALIAS);
        p.setReceiverValue(alias);
        return this.sendCustomMessage(p, sendNo, msgTitle, msgContent, msgContentType, extra);
    }

    public MessageResult sendCustomMessageWithAlias(int sendNo, String alias, String msgTitle, String msgContent, String msgContentType, Map<String, Object> extra, String overrideMsgId) {
        CustomMessageParams p = new CustomMessageParams();
        p.setReceiverType(ReceiverTypeEnum.ALIAS);
        p.setReceiverValue(alias);
        p.setOverrideMsgId(overrideMsgId);
        return this.sendCustomMessage(p, sendNo, msgTitle, msgContent, msgContentType, extra);
    }

    public MessageResult sendNotificationWithAppKey(int sendNo, String msgTitle, String msgContent) {
        NotifyMessageParams p = new NotifyMessageParams();
        p.setReceiverType(ReceiverTypeEnum.APPKEYS);
        return this.sendNotification(p, sendNo, msgTitle, msgContent, 0, null);
    }

    public MessageResult sendNotificationWithAppKey(int sendNo, String msgTitle, String msgContent, int builderId, Map<String, Object> extra) {
        NotifyMessageParams p = new NotifyMessageParams();
        p.setReceiverType(ReceiverTypeEnum.APPKEYS);
        return this.sendNotification(p, sendNo, msgTitle, msgContent, builderId, extra);
    }

    public MessageResult sendNotificationWithAppKey(int sendNo, String msgTitle, String msgContent, int builderId, Map<String, Object> extra, String overrideMsgId) {
        NotifyMessageParams p = new NotifyMessageParams();
        p.setReceiverType(ReceiverTypeEnum.APPKEYS);
        p.setOverrideMsgId(overrideMsgId);
        return this.sendNotification(p, sendNo, msgTitle, msgContent, builderId, extra);
    }

    public MessageResult sendCustomMessageWithAppKey(int sendNo, String msgTitle, String msgContent) {
        CustomMessageParams p = new CustomMessageParams();
        p.setReceiverType(ReceiverTypeEnum.APPKEYS);
        return this.sendCustomMessage(p, sendNo, msgTitle, msgContent, null, null);
    }

    public MessageResult sendCustomMessageWithAppKey(int sendNo, String msgTitle, String msgContent, String msgContentType, Map<String, Object> extra) {
        CustomMessageParams p = new CustomMessageParams();
        p.setReceiverType(ReceiverTypeEnum.APPKEYS);
        return this.sendCustomMessage(p, sendNo, msgTitle, msgContent, msgContentType, extra);
    }

    public MessageResult sendCustomMessageWithAppKey(int sendNo, String msgTitle, String msgContent, String msgContentType, Map<String, Object> extra, String overrideMsgId) {
        CustomMessageParams p = new CustomMessageParams();
        p.setReceiverType(ReceiverTypeEnum.APPKEYS);
        p.setOverrideMsgId(overrideMsgId);
        return this.sendCustomMessage(p, sendNo, msgTitle, msgContent, msgContentType, extra);
    }

    protected MessageResult sendCustomMessage(CustomMessageParams p, int sendNo, String msgTitle, String msgContent, String msgContentType, Map<String, Object> extra) {
        if (null != msgContentType) {
            p.getMsgContent().setContentType(msgContentType);
        }
        if (null != extra) {
            p.getMsgContent().setExtra(extra);
        }
        return this.sendMessage(p, sendNo, msgTitle, msgContent);
    }

    protected MessageResult sendNotification(NotifyMessageParams p, int sendNo, String msgTitle, String msgContent, int builderId, Map<String, Object> extra) {
        p.getMsgContent().setBuilderId(builderId);
        if (null != extra) {
            p.getMsgContent().setExtra(extra);
        }
        return this.sendMessage(p, sendNo, msgTitle, msgContent);
    }

    protected MessageResult sendMessage(MessageParams p, int sendNo, String msgTitle, String msgContent) {
        p.setSendNo(sendNo);
        p.setAppKey(this.getAppKey());
        p.setMasterSecret(this.masterSecret);
        p.setTimeToLive(this.timeToLive);
        p.setSendDescription(this.getSendDescription());
        for (DeviceEnum device : this.getDevices()) {
            p.addPlatform(device);
        }
        if (null != msgTitle) {
            p.getMsgContent().setTitle(msgTitle);
        }
        p.getMsgContent().setMessage(msgContent);
        return this.sendMessage(p);
    }

    protected MessageResult sendMessage(MessageParams params) {
        return httpClient.sendPush("/v2/push", this.enableSSL, params);
    }

    public List<ReceiveResult> getReceiveds(String[] msgIds) {
        return this.receiveManager.getReceiveds(msgIds);
    }

    public ReceiveResult getReceived(String msgId) {
        return this.receiveManager.getReceived(msgId);
    }
}

