/*
 * Decompiled with CFR 0.152.
 */
package cn.jpush.api.common.resp;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResponseWrapper
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(ResponseWrapper.class);
    private static final int RESPONSE_CODE_NONE = -1;
    private static final long serialVersionUID = -4227962073448507865L;
    private static Gson _gson = new Gson();
    private static JsonParser jsonParser = new JsonParser();
    public int responseCode = -1;
    public String responseContent;
    public ErrorObject error;
    public int rateLimitQuota;
    public int rateLimitRemaining;
    public int rateLimitReset;

    public void setRateLimit(String quota, String remaining, String reset) {
        if (null == quota) {
            return;
        }
        try {
            this.rateLimitQuota = Integer.parseInt(quota);
            this.rateLimitRemaining = Integer.parseInt(remaining);
            this.rateLimitReset = Integer.parseInt(reset);
            LOG.debug("JPush API Rate Limiting params - quota:" + quota + ", remaining:" + remaining + ", reset:" + reset);
        }
        catch (NumberFormatException e) {
            LOG.debug("Unexpected - parse rate limiting headers error.");
        }
    }

    public void setErrorObject() {
        this.error = new ErrorObject();
        this.error.error = new ErrorEntity();
        try {
            JsonElement element = jsonParser.parse(this.responseContent);
            JsonObject errorObj = null;
            if (element instanceof JsonArray) {
                JsonArray array = (JsonArray)element;
                for (int i = 0; i < array.size(); ++i) {
                    if (!array.get(i).getAsJsonObject().has("error")) continue;
                    errorObj = array.get(i).getAsJsonObject();
                    break;
                }
            } else if (element instanceof JsonObject) {
                errorObj = (JsonObject)element;
            }
            if (null != errorObj) {
                JsonObject errorMsg = errorObj;
                if (errorObj.has("msg_id")) {
                    this.error.msg_id = errorObj.get("msg_id").getAsLong();
                }
                if (errorObj.has("error")) {
                    errorMsg = (JsonObject)errorObj.get("error");
                }
                if (errorMsg.has("code")) {
                    this.error.error.code = errorMsg.get("code").getAsInt();
                }
                if (errorMsg.has("message")) {
                    this.error.error.message = errorMsg.get("message").getAsString();
                }
            }
        }
        catch (JsonSyntaxException e) {
            LOG.error("Unexpected - responseContent:" + this.responseContent, (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("Unexpected - responseContent:" + this.responseContent, (Throwable)e);
        }
    }

    public boolean isServerResponse() {
        if (this.responseCode / 100 == 2) {
            return true;
        }
        return this.responseCode > 0 && null != this.error && this.error.error.code > 0;
    }

    public String toString() {
        return _gson.toJson((Object)this);
    }

    public static class ErrorEntity {
        public int code;
        public String message;

        public String toString() {
            return _gson.toJson((Object)this);
        }
    }

    public static class ErrorObject {
        public long msg_id;
        public ErrorEntity error;
    }
}

