/*
 * Decompiled with CFR 0.152.
 */
package com.lly835.bestpay.service.impl;

import com.lly835.bestpay.model.wxpay.WxPayApi;
import com.lly835.bestpay.model.wxpay.response.WxPaySandboxKeyResponse;
import com.lly835.bestpay.service.impl.WxPaySignature;
import com.lly835.bestpay.utils.JsonUtil;
import com.lly835.bestpay.utils.RandomUtil;
import com.lly835.bestpay.utils.XmlUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.simpleframework.xml.Element;
import org.simpleframework.xml.Root;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;
import retrofit2.converter.simplexml.SimpleXmlConverterFactory;

public class WxPaySandboxKey {
    private static final Logger log = LoggerFactory.getLogger(WxPaySandboxKey.class);

    public void get(String mchId) {
        Retrofit retrofit = new Retrofit.Builder().baseUrl("https://api.mch.weixin.qq.com/").addConverterFactory((Converter.Factory)SimpleXmlConverterFactory.create()).build();
        SandboxParam sandboxParam = new SandboxParam();
        sandboxParam.setMchId(mchId);
        sandboxParam.setNonceStr(RandomUtil.getRandomStr());
        sandboxParam.setSign(WxPaySignature.sign(sandboxParam.buildMap(), ""));
        String xml = XmlUtil.toString(sandboxParam);
        RequestBody body = RequestBody.create((MediaType)MediaType.parse((String)"application/xml; charset=utf-8"), (String)xml);
        Call<WxPaySandboxKeyResponse> call = ((WxPayApi)retrofit.create(WxPayApi.class)).getsignkey(body);
        Response retrofitResponse = null;
        try {
            retrofitResponse = call.execute();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (!retrofitResponse.isSuccessful()) {
            throw new RuntimeException("\u3010\u5fae\u4fe1\u7edf\u4e00\u652f\u4ed8\u3011\u53d1\u8d77\u652f\u4ed8\uff0c\u7f51\u7edc\u5f02\u5e38\uff0c" + retrofitResponse);
        }
        Object response = retrofitResponse.body();
        log.info("\u3010\u83b7\u53d6\u5fae\u4fe1\u6c99\u7bb1\u5bc6\u94a5\u3011response={}", (Object)JsonUtil.toJson(response));
    }

    @Root(name="xml")
    static class SandboxParam {
        @Element(name="mch_id")
        private String mchId;
        @Element(name="nonce_str")
        private String nonceStr;
        @Element(name="sign")
        private String sign;

        public Map<String, String> buildMap() {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("mch_id", this.mchId);
            map.put("nonce_str", this.nonceStr);
            return map;
        }

        public String getMchId() {
            return this.mchId;
        }

        public String getNonceStr() {
            return this.nonceStr;
        }

        public String getSign() {
            return this.sign;
        }

        public void setMchId(String mchId) {
            this.mchId = mchId;
        }

        public void setNonceStr(String nonceStr) {
            this.nonceStr = nonceStr;
        }

        public void setSign(String sign) {
            this.sign = sign;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SandboxParam)) {
                return false;
            }
            SandboxParam other = (SandboxParam)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$mchId = this.getMchId();
            String other$mchId = other.getMchId();
            if (this$mchId == null ? other$mchId != null : !this$mchId.equals(other$mchId)) {
                return false;
            }
            String this$nonceStr = this.getNonceStr();
            String other$nonceStr = other.getNonceStr();
            if (this$nonceStr == null ? other$nonceStr != null : !this$nonceStr.equals(other$nonceStr)) {
                return false;
            }
            String this$sign = this.getSign();
            String other$sign = other.getSign();
            return !(this$sign == null ? other$sign != null : !this$sign.equals(other$sign));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SandboxParam;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $mchId = this.getMchId();
            result = result * 59 + ($mchId == null ? 43 : $mchId.hashCode());
            String $nonceStr = this.getNonceStr();
            result = result * 59 + ($nonceStr == null ? 43 : $nonceStr.hashCode());
            String $sign = this.getSign();
            result = result * 59 + ($sign == null ? 43 : $sign.hashCode());
            return result;
        }

        public String toString() {
            return "WxPaySandboxKey.SandboxParam(mchId=" + this.getMchId() + ", nonceStr=" + this.getNonceStr() + ", sign=" + this.getSign() + ")";
        }
    }
}

