/*
 * Decompiled with CFR 0.152.
 */
package com.lly835.bestpay.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.lly835.bestpay.utils.CamelCaseUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.simpleframework.xml.Element;

public class MapUtil {
    static final ObjectMapper objectMapper = new ObjectMapper();

    public static Map<String, String> buildMap(Object obj) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Class<?> clazz = obj.getClass();
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                String fieldName = field.getName();
                Element element = field.getAnnotation(Element.class);
                if (element != null && StringUtils.isNotEmpty((CharSequence)element.name())) {
                    fieldName = element.name();
                }
                String value = field.get(obj) == null ? "" : String.valueOf(field.get(obj));
                map.put(fieldName, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, String> getMap(String mapStr) {
        if (StringUtils.isEmpty((CharSequence)mapStr)) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        String[] key2ValArr = mapStr.replace("{", "").replace("}", "").split(", ");
        for (int i = 0; i < key2ValArr.length; ++i) {
            String[] keyAndVal = key2ValArr[i].split("=");
            map.put(keyAndVal[0], keyAndVal[1]);
        }
        return map;
    }

    public static String toUrl(Map<String, String> map) {
        String url = "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            url = url + entry.getKey() + "=" + entry.getValue() + "&";
        }
        url = StringUtils.substringBeforeLast((String)url, (String)"&");
        return url;
    }

    public static String toUrlWithSort(Map<String, String> map) {
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        String prestr = "";
        for (int i = 0; i < keys.size(); ++i) {
            String key = (String)keys.get(i);
            String value = map.get(key);
            prestr = i == keys.size() - 1 ? prestr + key + "=" + value : prestr + key + "=" + value + "&";
        }
        return prestr;
    }

    public static Map<String, String> removeParamsForAlipaySign(Map<String, String> map) {
        map.remove("sign");
        map.remove("sign_type");
        return map;
    }

    public static Map<String, String> removeEmptyKeyAndValue(Map<String, String> map) {
        Iterator<Map.Entry<String, String>> it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            String key = entry.getKey();
            String value = entry.getValue();
            if (!StringUtils.isBlank((CharSequence)key) && !StringUtils.isBlank((CharSequence)value)) continue;
            it.remove();
        }
        return map;
    }

    public static Map<String, String> keyToLowerCase(Map<String, String> map) {
        HashMap<String, String> responseMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            responseMap.put(key.toLowerCase(), value);
        }
        return responseMap;
    }

    public static String toUrlWithSortAndEncode(Map<String, String> map) {
        String key;
        String value;
        ArrayList<String> keys = new ArrayList<String>(map.keySet());
        Collections.sort(keys);
        String prestr = "";
        for (int i = 0; i < keys.size() && (value = map.get(key = (String)keys.get(i))) != null; ++i) {
            prestr = i == keys.size() - 1 ? prestr + key + "=" + URLEncoder.encode(value) : prestr + key + "=" + URLEncoder.encode(value) + "&";
        }
        return prestr;
    }

    public static HashMap<String, String> form2Map(String orderinfo) {
        String[] listinfo;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : listinfo = orderinfo.split("&")) {
            String[] list = s.split("=");
            if (list.length <= 1) continue;
            map.put(list[0], list[1]);
        }
        return map;
    }

    public static HashMap<String, String> form2MapWithCamelCase(String orderinfo) {
        String[] listinfo;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String s : listinfo = orderinfo.split("&")) {
            String[] list = s.split("=");
            if (list.length <= 1) continue;
            map.put(CamelCaseUtil.toCamelCase(list[0]), list[1]);
        }
        return map;
    }

    public static Map<String, String> object2MapWithUnderline(Object obj) {
        HashMap<String, String> map = new HashMap<String, String>();
        try {
            Class<?> clazz = obj.getClass();
            for (Field field : clazz.getDeclaredFields()) {
                field.setAccessible(true);
                String fieldName = field.getName();
                fieldName = CamelCaseUtil.toUnderlineName(fieldName);
                String value = field.get(obj) == null ? "" : String.valueOf(field.get(obj));
                map.put(fieldName, value);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static <T> T mapToObject(Object obj, Class<T> clazz) {
        try {
            return (T)objectMapper.readValue(MapUtil.serialize(obj), clazz);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String serialize(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj.getClass() == String.class) {
            return (String)obj;
        }
        try {
            return objectMapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            return null;
        }
    }

    static {
        objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

