/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.ageiport.common.logger;

import com.alibaba.ageiport.common.exception.ExceptionUtils;
import com.alibaba.ageiport.common.logger.Logger;
import com.alibaba.ageiport.common.utils.StringUtils;
import java.util.Date;

public class NopLogger
implements Logger {
    private String name;
    private static String DEBUG = "DEBUG";
    private static String INFO = "INFO";
    private static String WARN = "WARN";
    private static String ERROR = "ERROR";

    public NopLogger(String name) {
        this.name = name;
    }

    private String getFixPrefix(String tag) {
        return "NopLogger " + tag + " - " + this.name + " - " + new Date() + " - ";
    }

    @Override
    public void debug(String message, Throwable t) {
        System.out.println(this.getFixPrefix(DEBUG) + message);
        System.out.println(ExceptionUtils.stackOf(t));
    }

    @Override
    public void debug(String message) {
        System.out.println(this.getFixPrefix(DEBUG) + message);
    }

    @Override
    public void debug(String message, Object ... args) {
        System.out.println(this.getFixPrefix(DEBUG) + StringUtils.format(message, args));
    }

    @Override
    public void info(String message, Throwable t) {
        System.out.println(this.getFixPrefix(INFO) + message);
        System.out.println(ExceptionUtils.stackOf(t));
    }

    @Override
    public void info(String message) {
        System.out.println(this.getFixPrefix(INFO) + message);
    }

    @Override
    public void info(String message, Object ... args) {
        System.out.println(this.getFixPrefix(INFO) + StringUtils.format(message, args));
    }

    @Override
    public void warn(String message, Throwable t) {
        System.out.println(this.getFixPrefix(WARN) + message);
        System.out.println(ExceptionUtils.stackOf(t));
    }

    @Override
    public void warn(String message) {
        System.out.println(this.getFixPrefix(WARN) + message);
    }

    @Override
    public void warn(String message, Object ... args) {
        System.out.println(this.getFixPrefix(WARN) + StringUtils.format(message, args));
    }

    @Override
    public void error(String message, Throwable t) {
        System.out.println(this.getFixPrefix(ERROR) + message);
        System.out.println(ExceptionUtils.stackOf(t));
    }

    @Override
    public void error(String message) {
        System.out.println(this.getFixPrefix(ERROR) + message);
    }

    @Override
    public void error(Throwable t) {
        System.out.println(this.getFixPrefix(ERROR));
        System.out.println(ExceptionUtils.stackOf(t));
    }

    @Override
    public void error(String message, Object ... args) {
        System.out.println(this.getFixPrefix(ERROR) + StringUtils.format(message, args));
    }
}

